/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.ezbug.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueNormalizationService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.samples.ezbug.IBugReport;
import org.eclipse.sapphire.samples.ezbug.IHardwareItem;
import org.eclipse.sapphire.samples.ezbug.ProductStage;
import org.eclipse.sapphire.samples.ezbug.ProductVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BugReport
extends ModelElement
implements IBugReport {
    private Value<String> customerId;
    private Value<String> details;
    private ModelElementList<IHardwareItem> hardware;
    private Value<ProductStage> productStage;
    private Value<ProductVersion> productVersion;
    private Value<String> title;

    public BugReport(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public BugReport(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getCustomerId() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.customerId == null) {
                this.refresh((ModelProperty)PROP_CUSTOMER_ID, true);
            }
            return this.customerId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCustomerId(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_CUSTOMER_ID.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_CUSTOMER_ID, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_CUSTOMER_ID, true);
            if (!BugReport.equal((String)this.customerId.getText(false), (String)value)) {
                this.resource().binding(PROP_CUSTOMER_ID).write(value);
                this.refresh((ModelProperty)PROP_CUSTOMER_ID, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getDetails() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.details == null) {
                this.refresh((ModelProperty)PROP_DETAILS, true);
            }
            return this.details;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDetails(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_DETAILS.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_DETAILS, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_DETAILS, true);
            if (!BugReport.equal((String)this.details.getText(false), (String)value)) {
                this.resource().binding(PROP_DETAILS).write(value);
                this.refresh((ModelProperty)PROP_DETAILS, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IHardwareItem> getHardware() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.hardware == null) {
                this.refresh((ModelProperty)PROP_HARDWARE, true);
            }
            return this.hardware;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<ProductStage> getProductStage() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.productStage == null) {
                this.refresh((ModelProperty)PROP_PRODUCT_STAGE, true);
            }
            return this.productStage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProductStage(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_PRODUCT_STAGE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_PRODUCT_STAGE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_PRODUCT_STAGE, true);
            if (!BugReport.equal((String)this.productStage.getText(false), (String)value)) {
                this.resource().binding(PROP_PRODUCT_STAGE).write(value);
                this.refresh((ModelProperty)PROP_PRODUCT_STAGE, false);
            }
        }
    }

    @Override
    public void setProductStage(ProductStage value) {
        this.setProductStage(value != null ? ((ValueSerializationService)this.service((ModelProperty)PROP_PRODUCT_STAGE, ValueSerializationService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<ProductVersion> getProductVersion() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.productVersion == null) {
                this.refresh((ModelProperty)PROP_PRODUCT_VERSION, true);
            }
            return this.productVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProductVersion(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_PRODUCT_VERSION.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_PRODUCT_VERSION, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_PRODUCT_VERSION, true);
            if (!BugReport.equal((String)this.productVersion.getText(false), (String)value)) {
                this.resource().binding(PROP_PRODUCT_VERSION).write(value);
                this.refresh((ModelProperty)PROP_PRODUCT_VERSION, false);
            }
        }
    }

    @Override
    public void setProductVersion(ProductVersion value) {
        this.setProductVersion(value != null ? ((ValueSerializationService)this.service((ModelProperty)PROP_PRODUCT_VERSION, ValueSerializationService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getTitle() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.title == null) {
                this.refresh((ModelProperty)PROP_TITLE, true);
            }
            return this.title;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTitle(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_TITLE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_TITLE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_TITLE, true);
            if (!BugReport.equal((String)this.title.getText(false), (String)value)) {
                this.resource().binding(PROP_TITLE).write(value);
                this.refresh((ModelProperty)PROP_TITLE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CUSTOMER_ID) {
                if (this.customerId != null || force) {
                    Value<String> oldValue = this.customerId;
                    String val = this.resource().binding(PROP_CUSTOMER_ID).read();
                    this.customerId = new Value((IModelElement)this, PROP_CUSTOMER_ID, ((ValueNormalizationService)this.service((ModelProperty)PROP_CUSTOMER_ID, ValueNormalizationService.class)).normalize(PROP_CUSTOMER_ID.encodeKeywords(val)));
                    this.customerId.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CUSTOMER_ID);
                    if (oldValue != null) {
                        if (this.customerId.equals(oldValue)) {
                            this.customerId = oldValue;
                        }
                        if (this.customerId != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_CUSTOMER_ID, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_DETAILS) {
                if (this.details != null || force) {
                    Value<String> oldValue = this.details;
                    String val = this.resource().binding(PROP_DETAILS).read();
                    this.details = new Value((IModelElement)this, PROP_DETAILS, ((ValueNormalizationService)this.service((ModelProperty)PROP_DETAILS, ValueNormalizationService.class)).normalize(PROP_DETAILS.encodeKeywords(val)));
                    this.details.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DETAILS);
                    if (oldValue != null) {
                        if (this.details.equals(oldValue)) {
                            this.details = oldValue;
                        }
                        if (this.details != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_DETAILS, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_HARDWARE) {
                if (this.hardware == null) {
                    if (force) {
                        this.hardware = new ModelElementList((IModelElement)this, PROP_HARDWARE);
                        ListBindingImpl binding = this.resource().binding(PROP_HARDWARE);
                        this.hardware.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_HARDWARE);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_HARDWARE);
                    boolean notified = this.hardware.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_HARDWARE, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_PRODUCT_STAGE) {
                if (this.productStage != null || force) {
                    Value<ProductStage> oldValue = this.productStage;
                    String val = this.resource().binding(PROP_PRODUCT_STAGE).read();
                    this.productStage = new Value((IModelElement)this, PROP_PRODUCT_STAGE, ((ValueNormalizationService)this.service((ModelProperty)PROP_PRODUCT_STAGE, ValueNormalizationService.class)).normalize(PROP_PRODUCT_STAGE.encodeKeywords(val)));
                    this.productStage.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_PRODUCT_STAGE);
                    if (oldValue != null) {
                        if (this.productStage.equals(oldValue)) {
                            this.productStage = oldValue;
                        }
                        if (this.productStage != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_PRODUCT_STAGE, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_PRODUCT_VERSION) {
                if (this.productVersion != null || force) {
                    Value<ProductVersion> oldValue = this.productVersion;
                    String val = this.resource().binding(PROP_PRODUCT_VERSION).read();
                    this.productVersion = new Value((IModelElement)this, PROP_PRODUCT_VERSION, ((ValueNormalizationService)this.service((ModelProperty)PROP_PRODUCT_VERSION, ValueNormalizationService.class)).normalize(PROP_PRODUCT_VERSION.encodeKeywords(val)));
                    this.productVersion.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_PRODUCT_VERSION);
                    if (oldValue != null) {
                        if (this.productVersion.equals(oldValue)) {
                            this.productVersion = oldValue;
                        }
                        if (this.productVersion != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_PRODUCT_VERSION, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_TITLE && (this.title != null || force)) {
                Value<String> oldValue = this.title;
                String val = this.resource().binding(PROP_TITLE).read();
                this.title = new Value((IModelElement)this, PROP_TITLE, ((ValueNormalizationService)this.service((ModelProperty)PROP_TITLE, ValueNormalizationService.class)).normalize(PROP_TITLE.encodeKeywords(val)));
                this.title.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_TITLE);
                if (oldValue != null) {
                    if (this.title.equals(oldValue)) {
                        this.title = oldValue;
                    }
                    if (this.title != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_TITLE, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CUSTOMER_ID) {
            return this.getCustomerId();
        }
        if (property == PROP_DETAILS) {
            return this.getDetails();
        }
        if (property == PROP_HARDWARE) {
            return this.getHardware();
        }
        if (property == PROP_PRODUCT_STAGE) {
            return this.getProductStage();
        }
        if (property == PROP_PRODUCT_VERSION) {
            return this.getProductVersion();
        }
        if (property == PROP_TITLE) {
            return this.getTitle();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_CUSTOMER_ID) {
            this.setCustomerId((String)value);
            return;
        }
        if (property == PROP_DETAILS) {
            this.setDetails((String)value);
            return;
        }
        if (property == PROP_PRODUCT_STAGE) {
            if (!(value instanceof String)) {
                this.setProductStage((ProductStage)((Object)value));
            } else {
                this.setProductStage((String)value);
            }
            return;
        }
        if (property == PROP_PRODUCT_VERSION) {
            if (!(value instanceof String)) {
                this.setProductVersion((ProductVersion)((Object)value));
            } else {
                this.setProductVersion((String)value);
            }
            return;
        }
        if (property == PROP_TITLE) {
            this.setTitle((String)value);
            return;
        }
        super.write(property, value);
    }
}

