/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ValueImageService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;

public final class EnumValueImageService
extends ValueImageService {
    private EnumValueType enumType;
    private ValueSerializationService valueSerializationService;
    private final Map<Enum<?>, ImageData> images = new HashMap();

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element);
        this.enumType = new EnumValueType(property.getTypeClass());
        this.valueSerializationService = element.service(property, ValueSerializationService.class);
    }

    public ImageData provide(String value) {
        Image imageAnnotation;
        Enum item = (Enum)this.valueSerializationService.decode(value);
        if (item == null) {
            return null;
        }
        ImageData image = this.images.get(item);
        if (image == null && (imageAnnotation = this.enumType.getAnnotation(item, Image.class)) != null && (image = ImageData.readFromClassLoader(this.enumType.getEnumTypeClass(), imageAnnotation.path())) != null) {
            this.images.put(item, image);
        }
        return image;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return property instanceof ValueProperty && Enum.class.isAssignableFrom(property.getTypeClass());
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return new EnumValueImageService();
        }
    }
}

