/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.util;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableReference<T> {
    private T value;
    private final Set<Listener> listeners;

    public MutableReference() {
        this(null);
    }

    public MutableReference(T value) {
        this.value = value;
        this.listeners = new CopyOnWriteArraySet<Listener>();
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        T oldValue = this.value;
        this.value = value;
        this.notifyListeners(oldValue, this.value);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(T oldValue, T newValue) {
        for (Listener listener : this.listeners) {
            listener.handleReferenceChanged(oldValue, newValue);
        }
    }

    public static abstract class Listener {
        public abstract void handleReferenceChanged(Object var1, Object var2);
    }
}

