/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.ITestModelElement;
import org.eclipse.sapphire.tests.modeling.el.t0001.TestExpr0001;
import org.eclipse.sapphire.tests.modeling.el.t0002.TestExpr0002;
import org.eclipse.sapphire.tests.modeling.el.t0003.TestExpr0003;
import org.eclipse.sapphire.tests.modeling.el.t0004.TestExpr0004;
import org.eclipse.sapphire.tests.modeling.el.t0005.TestExpr0005;
import org.eclipse.sapphire.tests.modeling.el.t0006.TestExpr0006;

public final class ExpressionLanguageTests
extends TestCase {
    private ExpressionLanguageTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("ExpressionLanguageTests");
        suite.addTest((Test)new ExpressionLanguageTests("literalNull"));
        int i = 1;
        while (i <= 2) {
            suite.addTest((Test)new ExpressionLanguageTests("literalBoolean" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 2) {
            suite.addTest((Test)new ExpressionLanguageTests("literalInteger" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 14) {
            suite.addTest((Test)new ExpressionLanguageTests("literalDecimal" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 6) {
            suite.addTest((Test)new ExpressionLanguageTests("literalString" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 3) {
            suite.addTest((Test)new ExpressionLanguageTests("opAddition" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 3) {
            suite.addTest((Test)new ExpressionLanguageTests("opSubtraction" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 4) {
            suite.addTest((Test)new ExpressionLanguageTests("opMultiplication" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 6) {
            suite.addTest((Test)new ExpressionLanguageTests("opDivision" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 2) {
            suite.addTest((Test)new ExpressionLanguageTests("opUnaryMinus" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 12) {
            suite.addTest((Test)new ExpressionLanguageTests("opLessThan" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 12) {
            suite.addTest((Test)new ExpressionLanguageTests("opLessThanOrEq" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 12) {
            suite.addTest((Test)new ExpressionLanguageTests("opGreaterThan" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 12) {
            suite.addTest((Test)new ExpressionLanguageTests("opGreaterThanOrEq" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 12) {
            suite.addTest((Test)new ExpressionLanguageTests("opEqual" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 12) {
            suite.addTest((Test)new ExpressionLanguageTests("opNotEqual" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 8) {
            suite.addTest((Test)new ExpressionLanguageTests("opAnd" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 8) {
            suite.addTest((Test)new ExpressionLanguageTests("opOr" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 4) {
            suite.addTest((Test)new ExpressionLanguageTests("opNot" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 4) {
            suite.addTest((Test)new ExpressionLanguageTests("opEmpty" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 2) {
            suite.addTest((Test)new ExpressionLanguageTests("opConditional" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 2) {
            suite.addTest((Test)new ExpressionLanguageTests("precedence" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 6) {
            suite.addTest((Test)new ExpressionLanguageTests("composite" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 3) {
            suite.addTest((Test)new ExpressionLanguageTests("functions" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 2) {
            suite.addTest((Test)new ExpressionLanguageTests("concat" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 4) {
            suite.addTest((Test)new ExpressionLanguageTests("firstSegment" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 4) {
            suite.addTest((Test)new ExpressionLanguageTests("lastSegment" + String.valueOf(i)));
            ++i;
        }
        i = 1;
        while (i <= 2) {
            suite.addTest((Test)new ExpressionLanguageTests("properties" + String.valueOf(i)));
            ++i;
        }
        suite.addTest(TestExpr0001.suite());
        suite.addTest(TestExpr0002.suite());
        suite.addTest(TestExpr0003.suite());
        suite.addTest(TestExpr0004.suite());
        suite.addTest(TestExpr0005.suite());
        suite.addTest(TestExpr0006.suite());
        return suite;
    }

    private void test(String expr, Object expected) {
        this.test(expr, expected, new FunctionContext());
    }

    private void test(String expr, Object expected, FunctionContext context) {
        Object actual = ExpressionLanguageParser.parse((String)expr).evaluate(context).value();
        ExpressionLanguageTests.assertEquals((Object)expected, (Object)actual);
    }

    public void literalNull() {
        this.test("${null}", null);
    }

    private void literalBoolean(String literal) {
        this.test("${" + literal + "}", Boolean.valueOf(literal));
    }

    public void literalBoolean1() {
        this.literalBoolean("true");
    }

    public void literalBoolean2() {
        this.literalBoolean("false");
    }

    private void literalInteger(String literal) {
        this.test("${" + literal + "}", new BigInteger(literal));
    }

    public void literalInteger1() {
        this.literalInteger("1234567");
    }

    public void literalInteger2() {
        this.literalInteger("1234567890123456789012345678901234567890");
    }

    private void literalDecimal(String literal) {
        this.test("${" + literal + "}", new BigDecimal(literal));
    }

    public void literalDecimal1() {
        this.literalDecimal("12.34567");
    }

    public void literalDecimal2() {
        this.literalDecimal(".34567");
    }

    public void literalDecimal3() {
        this.literalDecimal("12e23");
    }

    public void literalDecimal4() {
        this.literalDecimal("12e+23");
    }

    public void literalDecimal5() {
        this.literalDecimal("12e-23");
    }

    public void literalDecimal6() {
        this.literalDecimal("12.345e23");
    }

    public void literalDecimal7() {
        this.literalDecimal("12.345e+23");
    }

    public void literalDecimal8() {
        this.literalDecimal("12.345e-23");
    }

    public void literalDecimal9() {
        this.literalDecimal("12E23");
    }

    public void literalDecimal10() {
        this.literalDecimal("12E+23");
    }

    public void literalDecimal11() {
        this.literalDecimal("12E-23");
    }

    public void literalDecimal12() {
        this.literalDecimal("12.345E23");
    }

    public void literalDecimal13() {
        this.literalDecimal("12.345E+23");
    }

    public void literalDecimal14() {
        this.literalDecimal("12.345E-23");
    }

    public void literalString1() {
        this.test("${\"abcdefg 12345 xyz%%\"}", "abcdefg 12345 xyz%%");
    }

    public void literalString2() {
        this.test("${'abcdefg 12345 xyz%%'}", "abcdefg 12345 xyz%%");
    }

    public void literalString3() {
        this.test("${\"abcdefg \\\"12345\\\" xyz%%\"}", "abcdefg \"12345\" xyz%%");
    }

    public void literalString4() {
        this.test("${\"abcdefg '12345' xyz%%\"}", "abcdefg '12345' xyz%%");
    }

    public void literalString5() {
        this.test("${'abcdefg \"12345\" xyz%%'}", "abcdefg \"12345\" xyz%%");
    }

    public void literalString6() {
        this.test("${'abcdefg \\'12345\\' xyz%%'}", "abcdefg '12345' xyz%%");
    }

    public void opAddition1() {
        this.test("${3+5}", new BigInteger("8"));
    }

    public void opAddition2() {
        this.test("${3+5+7}", new BigInteger("15"));
    }

    public void opAddition3() {
        this.test("${3.2+5}", new BigDecimal("8.2"));
    }

    public void opSubtraction1() {
        this.test("${3-5}", new BigInteger("-2"));
    }

    public void opSubtraction2() {
        this.test("${3-5-7}", new BigInteger("-9"));
    }

    public void opSubtraction3() {
        this.test("${3.2-5}", new BigDecimal("-1.8"));
    }

    public void opMultiplication1() {
        this.test("${3*5}", new BigInteger("15"));
    }

    public void opMultiplication2() {
        this.test("${3*5*7}", new BigInteger("105"));
    }

    public void opMultiplication3() {
        this.test("${3.2*5}", new BigDecimal("16.0"));
    }

    public void opMultiplication4() {
        this.test("${3.2*6}", new BigDecimal("19.2"));
    }

    public void opDivision1() {
        this.test("${32/5}", new BigDecimal("6"));
    }

    public void opDivision2() {
        this.test("${322/5/7}", new BigDecimal("9"));
    }

    public void opDivision3() {
        this.test("${32.2/5}", new BigDecimal("6.4"));
    }

    public void opDivision4() {
        this.test("${32 div 5}", new BigDecimal("6"));
    }

    public void opDivision5() {
        this.test("${322 div 5 div 7}", new BigDecimal("9"));
    }

    public void opDivision6() {
        this.test("${32.2 div 5}", new BigDecimal("6.4"));
    }

    public void opUnaryMinus1() {
        this.test("${-5}", new BigInteger("-5"));
    }

    public void opUnaryMinus2() {
        this.test("${-5.23}", new BigDecimal("-5.23"));
    }

    public void opLessThan1() {
        this.test("${3<5}", true);
    }

    public void opLessThan2() {
        this.test("${5<3}", false);
    }

    public void opLessThan3() {
        this.test("${3<3}", false);
    }

    public void opLessThan4() {
        this.test("${3.2<5}", true);
    }

    public void opLessThan5() {
        this.test("${5.3<3}", false);
    }

    public void opLessThan6() {
        this.test("${3.2<3.2}", false);
    }

    public void opLessThan7() {
        this.test("${3 lt 5}", true);
    }

    public void opLessThan8() {
        this.test("${5 lt 3}", false);
    }

    public void opLessThan9() {
        this.test("${3 lt 3}", false);
    }

    public void opLessThan10() {
        this.test("${3.2 lt 5}", true);
    }

    public void opLessThan11() {
        this.test("${5.3 lt 3}", false);
    }

    public void opLessThan12() {
        this.test("${3.2 lt 3.2}", false);
    }

    public void opLessThanOrEq1() {
        this.test("${3<=5}", true);
    }

    public void opLessThanOrEq2() {
        this.test("${5<=3}", false);
    }

    public void opLessThanOrEq3() {
        this.test("${3<=3}", true);
    }

    public void opLessThanOrEq4() {
        this.test("${3.2<=5}", true);
    }

    public void opLessThanOrEq5() {
        this.test("${5.3<=3}", false);
    }

    public void opLessThanOrEq6() {
        this.test("${3.2<=3.2}", true);
    }

    public void opLessThanOrEq7() {
        this.test("${3 le 5}", true);
    }

    public void opLessThanOrEq8() {
        this.test("${5 le 3}", false);
    }

    public void opLessThanOrEq9() {
        this.test("${3 le 3}", true);
    }

    public void opLessThanOrEq10() {
        this.test("${3.2 le 5}", true);
    }

    public void opLessThanOrEq11() {
        this.test("${5.3 le 3}", false);
    }

    public void opLessThanOrEq12() {
        this.test("${3.2 le 3.2}", true);
    }

    public void opGreaterThan1() {
        this.test("${3>5}", false);
    }

    public void opGreaterThan2() {
        this.test("${5>3}", true);
    }

    public void opGreaterThan3() {
        this.test("${3>3}", false);
    }

    public void opGreaterThan4() {
        this.test("${3.2>5}", false);
    }

    public void opGreaterThan5() {
        this.test("${5.3>3}", true);
    }

    public void opGreaterThan6() {
        this.test("${3.2>3.2}", false);
    }

    public void opGreaterThan7() {
        this.test("${3 gt 5}", false);
    }

    public void opGreaterThan8() {
        this.test("${5 gt 3}", true);
    }

    public void opGreaterThan9() {
        this.test("${3 gt 3}", false);
    }

    public void opGreaterThan10() {
        this.test("${3.2 gt 5}", false);
    }

    public void opGreaterThan11() {
        this.test("${5.3 gt 3}", true);
    }

    public void opGreaterThan12() {
        this.test("${3.2 gt 3.2}", false);
    }

    public void opGreaterThanOrEq1() {
        this.test("${3>=5}", false);
    }

    public void opGreaterThanOrEq2() {
        this.test("${5>=3}", true);
    }

    public void opGreaterThanOrEq3() {
        this.test("${3>=3}", true);
    }

    public void opGreaterThanOrEq4() {
        this.test("${3.2>=5}", false);
    }

    public void opGreaterThanOrEq5() {
        this.test("${5.3>=3}", true);
    }

    public void opGreaterThanOrEq6() {
        this.test("${3.2>=3.2}", true);
    }

    public void opGreaterThanOrEq7() {
        this.test("${3 ge 5}", false);
    }

    public void opGreaterThanOrEq8() {
        this.test("${5 ge 3}", true);
    }

    public void opGreaterThanOrEq9() {
        this.test("${3 ge 3}", true);
    }

    public void opGreaterThanOrEq10() {
        this.test("${3.2 ge 5}", false);
    }

    public void opGreaterThanOrEq11() {
        this.test("${5.3 ge 3}", true);
    }

    public void opGreaterThanOrEq12() {
        this.test("${3.2 ge 3.2}", true);
    }

    public void opEqual1() {
        this.test("${3==3}", true);
    }

    public void opEqual2() {
        this.test("${3==5}", false);
    }

    public void opEqual3() {
        this.test("${3.2==3.2}", true);
    }

    public void opEqual4() {
        this.test("${3.2==5}", false);
    }

    public void opEqual5() {
        this.test("${'abc'=='abc'}", true);
    }

    public void opEqual6() {
        this.test("${'abc'=='xyz'}", false);
    }

    public void opEqual7() {
        this.test("${3 eq 3}", true);
    }

    public void opEqual8() {
        this.test("${3 eq 5}", false);
    }

    public void opEqual9() {
        this.test("${3.2 eq 3.2}", true);
    }

    public void opEqual10() {
        this.test("${3.2 eq 5}", false);
    }

    public void opEqual11() {
        this.test("${'abc' eq 'abc'}", true);
    }

    public void opEqual12() {
        this.test("${'abc' eq 'xyz'}", false);
    }

    public void opNotEqual1() {
        this.test("${3!=3}", false);
    }

    public void opNotEqual2() {
        this.test("${3!=5}", true);
    }

    public void opNotEqual3() {
        this.test("${3.2!=3.2}", false);
    }

    public void opNotEqual4() {
        this.test("${3.2!=5}", true);
    }

    public void opNotEqual5() {
        this.test("${'abc'!='abc'}", false);
    }

    public void opNotEqual6() {
        this.test("${'abc'!='xyz'}", true);
    }

    public void opNotEqual7() {
        this.test("${3 ne 3}", false);
    }

    public void opNotEqual8() {
        this.test("${3 ne 5}", true);
    }

    public void opNotEqual9() {
        this.test("${3.2 ne 3.2}", false);
    }

    public void opNotEqual10() {
        this.test("${3.2 ne 5}", true);
    }

    public void opNotEqual11() {
        this.test("${'abc' ne 'abc'}", false);
    }

    public void opNotEqual12() {
        this.test("${'abc' ne 'xyz'}", true);
    }

    public void opAnd1() {
        this.test("${true&&true}", true);
    }

    public void opAnd2() {
        this.test("${true&&false}", false);
    }

    public void opAnd3() {
        this.test("${false&&true}", false);
    }

    public void opAnd4() {
        this.test("${false&&false}", false);
    }

    public void opAnd5() {
        this.test("${true and true}", true);
    }

    public void opAnd6() {
        this.test("${true and false}", false);
    }

    public void opAnd7() {
        this.test("${false and true}", false);
    }

    public void opAnd8() {
        this.test("${false and false}", false);
    }

    public void opOr1() {
        this.test("${true||true}", true);
    }

    public void opOr2() {
        this.test("${true||false}", true);
    }

    public void opOr3() {
        this.test("${false||true}", true);
    }

    public void opOr4() {
        this.test("${false||false}", false);
    }

    public void opOr5() {
        this.test("${true or true}", true);
    }

    public void opOr6() {
        this.test("${true or false}", true);
    }

    public void opOr7() {
        this.test("${false or true}", true);
    }

    public void opOr8() {
        this.test("${false or false}", false);
    }

    public void opNot1() {
        this.test("${!true}", false);
    }

    public void opNot2() {
        this.test("${!false}", true);
    }

    public void opNot3() {
        this.test("${not true}", false);
    }

    public void opNot4() {
        this.test("${not false}", true);
    }

    public void opEmpty1() {
        this.test("${empty null}", true);
    }

    public void opEmpty2() {
        this.test("${empty 5}", false);
    }

    public void opEmpty3() {
        this.test("${empty 'abc'}", false);
    }

    public void opEmpty4() {
        this.test("${empty ''}", true);
    }

    public void opConditional1() {
        this.test("${true?3:5}", new BigInteger("3"));
    }

    public void opConditional2() {
        this.test("${false?3:5}", new BigInteger("5"));
    }

    public void precedence1() {
        this.test("${3+4*5}", new BigInteger("23"));
    }

    public void precedence2() {
        this.test("${(3+4)*5}", new BigInteger("35"));
    }

    public void composite1() {
        this.test("abc", "abc");
    }

    public void composite2() {
        this.test("abc${'def'}", "abcdef");
    }

    public void composite3() {
        this.test("abc${'def'}ghi", "abcdefghi");
    }

    public void composite4() {
        this.test("abc${'def'}ghi${'jkl'}", "abcdefghijkl");
    }

    public void composite5() {
        this.test("abc${5}ghi${6}", "abc5ghi6");
    }

    public void composite6() {
        this.test("abc${3*5}ghi${3>5?6.2:7.3}", "abc15ghi7.3");
    }

    public void functions1() {
        FunctionContext context = new FunctionContext(){

            public Function function(String name, List<Function> operands) {
                Function function = null;
                if (name.equals("eclipse:add")) {
                    function = new Function(){

                        public String name() {
                            return "eclipse:add";
                        }

                        public FunctionResult evaluate(FunctionContext context) {
                            return new FunctionResult(this, context){

                                protected Object evaluate() {
                                    return ((BigInteger)this.cast(this.operand(0).value(), BigInteger.class)).add((BigInteger)this.cast(this.operand(1).value(), BigInteger.class));
                                }
                            };
                        }
                    };
                } else if (name.equals("subtract")) {
                    function = new Function(){

                        public String name() {
                            return "subtract";
                        }

                        public FunctionResult evaluate(FunctionContext context) {
                            return new FunctionResult(this, context){

                                protected Object evaluate() {
                                    return ((BigInteger)this.cast(this.operand(0).value(), BigInteger.class)).subtract((BigInteger)this.cast(this.operand(1).value(), BigInteger.class));
                                }
                            };
                        }
                    };
                }
                if (function != null) {
                    function.init(operands.toArray(new Function[operands.size()]));
                    return function;
                }
                return super.function(name, operands);
            }
        };
        this.test("${ 3 + eclipse:add( 4, 5 ) + subtract( 6, 7 ) + subtract( eclipse:add( 8 + 9, 10 + 11 ), 12 + 13 ) }", new BigInteger("24"), context);
    }

    public void functions2() {
        this.test("${ test:factorial( 7 ) }", new BigInteger("5040"));
    }

    public void functions3() {
        this.test("${ test:factorial( 15 + 5 ) }", new BigInteger("2432902008176640000"));
    }

    public void concat1() {
        this.test("${concat('a','b')}", "ab");
    }

    public void concat2() {
        this.test("${concat(2010,'-',12,'-',2)}", "2010-12-2");
    }

    public void firstSegment1() {
        this.test("${FirstSegment('abc.def.ghi','.')}", "abc");
    }

    public void firstSegment2() {
        this.test("${FirstSegment('abc/def\\\\ghi','\\\\/')}", "abc");
    }

    public void firstSegment3() {
        this.test("${FirstSegment('abc','.')}", "abc");
    }

    public void firstSegment4() {
        this.test("${FirstSegment(null,'.')}", "");
    }

    public void lastSegment1() {
        this.test("${LastSegment('abc.def.ghi','.')}", "ghi");
    }

    public void lastSegment2() {
        this.test("${LastSegment('abc/def\\\\ghi','\\\\/')}", "ghi");
    }

    public void lastSegment3() {
        this.test("${LastSegment('abc','.')}", "abc");
    }

    public void lastSegment4() {
        this.test("${LastSegment(null,'.')}", "");
    }

    private void properties(String expr, Object expected) {
        ITestModelElement root = (ITestModelElement)ITestModelElement.TYPE.instantiate();
        ITestModelElement child = (ITestModelElement)root.getFooBar().element(true);
        ITestModelElement grandchild = (ITestModelElement)child.getFooBar().element(true);
        root.setIntegerProp(1);
        root.setStringProp("ABC");
        child.setIntegerProp(2);
        child.setStringProp("DEF");
        grandchild.setIntegerProp(3);
        grandchild.setStringProp("GHI");
        ModelElementFunctionContext context = new ModelElementFunctionContext((IModelElement)root);
        this.test(expr, expected, (FunctionContext)context);
    }

    public void properties1() {
        this.properties("${ IntegerProp + FooBar.IntegerProp + FooBar.FooBar[ 'IntegerProp' ] }", 6L);
    }

    public void properties2() {
        this.properties("${ StringProp }${ FooBar.StringProp }${ FooBar.FooBar[ 'StringProp' ] }", "ABCDEFGHI");
    }
}

