/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.extensibility;

import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.Whitespace;
import org.eclipse.sapphire.modeling.localization.Localizable;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlValueBinding;
import org.eclipse.sapphire.sdk.extensibility.IModelElementServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Label(standard="model element service")
@GenerateImpl
public interface IModelElementServiceDef
extends IModelElement {
    public static final ModelElementType TYPE = new ModelElementType(IModelElementServiceDef.class);
    @Label(standard="ID")
    @Required
    @XmlBinding(path="id")
    @Documentation(content="Uniquely identifies this model element service to the system and other services.")
    public static final ValueProperty PROP_ID = new ValueProperty(TYPE, "Id");
    @LongString
    @Label(standard="description")
    @Localizable
    @Whitespace(collapse=true)
    @XmlValueBinding(path="description")
    @Documentation(content="Provides information about the model element service. The description should be in the form of properly capitalized and punctuated sentences.")
    public static final ValueProperty PROP_DESCRIPTION = new ValueProperty(TYPE, "Description");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="service type class")
    @Required
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS, JavaTypeKind.ABSTRACT_CLASS, JavaTypeKind.INTERFACE}, type={"org.eclipse.sapphire.modeling.ModelElementService"})
    @MustExist
    @XmlBinding(path="type")
    @Documentation(content="The type of service that the factory can create. Must extend ModelElementService.")
    public static final ValueProperty PROP_TYPE_CLASS = new ValueProperty(TYPE, "TypeClass");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="service factory class")
    @Required
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"org.eclipse.sapphire.modeling.ModelElementServiceFactory"})
    @MustExist
    @XmlBinding(path="factory")
    @Documentation(content="The factory that can create a service of the specified type. Must extend ModelElementServiceFactory.")
    public static final ValueProperty PROP_FACTORY_CLASS = new ValueProperty(TYPE, "FactoryClass");
    @Type(base=IModelElementServiceRef.class)
    @Label(standard="overrides")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="overrides", type=IModelElementServiceRef.class)})
    @Documentation(content="When multiple service implementations activate for a given context, overrides can be used to control which implementation is used.")
    public static final ListProperty PROP_OVERRIDES = new ListProperty(TYPE, "Overrides");

    public Value<String> getId();

    public void setId(String var1);

    public Value<String> getDescription();

    public void setDescription(String var1);

    public ReferenceValue<JavaTypeName, JavaType> getTypeClass();

    public void setTypeClass(String var1);

    public void setTypeClass(JavaTypeName var1);

    public ReferenceValue<JavaTypeName, JavaType> getFactoryClass();

    public void setFactoryClass(String var1);

    public void setFactoryClass(JavaTypeName var1);

    public ModelElementList<IModelElementServiceRef> getOverrides();
}

