/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementDisposedEvent;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireHint;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;
import org.eclipse.sapphire.ui.def.ISapphirePropertyEditorDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.BooleanPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.CheckBoxListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.DefaultListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.DefaultValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.EnumPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.NamedValuesPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.SlushBucketPropertyEditor;
import org.eclipse.sapphire.ui.swt.SapphireControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphirePropertyEditor
extends SapphirePart {
    public static final String RELATED_CONTROLS = "related-controls";
    public static final String BROWSE_BUTTON = "browse-button";
    public static final String DATA_BINDING = "binding";
    public static final String DATA_PROPERTY = "property";
    public static final String HINT_SHOW_LABEL = "show.label";
    public static final String HINT_SHOW_LABEL_ABOVE = "show.label.above";
    public static final String HINT_SHOW_HEADER = "show.header";
    public static final String HINT_AUX_TEXT = "aux.text";
    public static final String HINT_AUX_TEXT_PROVIDER = "aux.text.provider";
    public static final String HINT_HIDE_IF_DISABLED = "hide.if.disabled";
    public static final String HINT_BROWSE_ONLY = "browse.only";
    public static final String HINT_READ_ONLY = "read.only";
    public static final String HINT_BORDER = "border";
    public static final String HINT_ASSIST_CONTRIBUTORS = "assist.contributors";
    public static final String HINT_SUPPRESS_ASSIST_CONTRIBUTORS = "suppress.assist.contributors";
    public static final String HINT_LISTENERS = "listeners";
    public static final String HINT_COLUMN_WIDTHS = "column.widths";
    public static final String HINT_MARGIN_LEFT = "margin.left";
    public static final String HINT_PREFER_COMBO = "prefer.combo";
    public static final String HINT_PREFER_RADIO_BUTTONS = "prefer.radio.buttons";
    public static final String HINT_PREFER_VERTICAL_RADIO_BUTTONS = "prefer.vertical.radio.buttons";
    public static final String HINT_FACTORY = "factory";
    public static final String HINT_EXPAND_VERTICALLY = "expand.vertically";
    private static final List<PropertyEditorRendererFactory> FACTORIES = new ArrayList<PropertyEditorRendererFactory>();
    private IModelElement element;
    private ModelProperty property;
    private List<ModelProperty> childProperties;
    private List<ModelProperty> childPropertiesReadOnly;
    private Map<IModelElement, Map<ModelProperty, SapphirePropertyEditor>> childPropertyEditors;
    private Map<String, Object> hints;
    private List<SapphirePart> relatedContentParts;
    private List<SapphirePart> relatedContentPartsReadOnly;
    private ModelPropertyListener listener;

    static {
        FACTORIES.add(new BooleanPropertyEditorRenderer.Factory());
        FACTORIES.add(new EnumPropertyEditorRenderer.Factory());
        FACTORIES.add(new NamedValuesPropertyEditorRenderer.Factory());
        FACTORIES.add(new DefaultValuePropertyEditorRenderer.Factory());
        FACTORIES.add(new CheckBoxListPropertyEditorRenderer.EnumFactory());
        FACTORIES.add(new SlushBucketPropertyEditor.Factory());
        FACTORIES.add(new DefaultListPropertyEditorRenderer.Factory());
    }

    @Override
    protected void init() {
        super.init();
        ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.nearest(ISapphireUiDef.class);
        ISapphirePropertyEditorDef propertyEditorPartDef = (ISapphirePropertyEditorDef)this.definition;
        String pathString = (String)propertyEditorPartDef.getProperty().getContent();
        ModelPath path = new ModelPath(pathString);
        this.element = this.getModelElement();
        int i = 0;
        int n = path.length();
        while (i < n) {
            ModelPath.Segment segment = path.segment(i);
            if (segment instanceof ModelPath.ModelRootSegment) {
                this.element = (IModelElement)this.element.root();
            } else if (segment instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.element.parent();
                if (!(parent instanceof IModelElement)) {
                    parent = parent.parent();
                }
                this.element = (IModelElement)parent;
            } else if (segment instanceof ModelPath.PropertySegment) {
                this.property = this.resolve(this.element, ((ModelPath.PropertySegment)segment).getPropertyName());
                if (i + 1 != n) {
                    throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object)pathString));
                }
            } else {
                throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object)pathString));
            }
            ++i;
        }
        if (this.property == null) {
            throw new RuntimeException(NLS.bind((String)Resources.invalidPath, (Object)pathString));
        }
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                SapphirePropertyEditor.this.updateValidationState();
            }
        };
        this.element.addListener(this.listener, this.property.getName());
        this.childProperties = new ArrayList<ModelProperty>();
        this.childPropertiesReadOnly = Collections.unmodifiableList(this.childProperties);
        this.childPropertyEditors = new HashMap<IModelElement, Map<ModelProperty, SapphirePropertyEditor>>();
        ModelElementType type = this.property.getType();
        if (type != null) {
            if (propertyEditorPartDef.getChildProperties().isEmpty()) {
                for (ModelProperty childProperty : type.getProperties()) {
                    this.childProperties.add(childProperty);
                }
            } else {
                for (ISapphirePropertyEditorDef childPropertyEditor : propertyEditorPartDef.getChildProperties()) {
                    String childPropertyName = (String)childPropertyEditor.getProperty().getContent();
                    ModelProperty childProperty = type.getProperty(childPropertyName);
                    if (childProperty == null) {
                        SapphireUiFrameworkPlugin.logError("Could not resolve property: " + childPropertyName);
                        continue;
                    }
                    this.childProperties.add(childProperty);
                }
            }
        }
        this.hints = new HashMap<String, Object>();
        for (ISapphireHint hint : propertyEditorPartDef.getHints()) {
            String name = hint.getName().getText();
            String valueString = hint.getValue().getText();
            Serializable parsedValue = valueString;
            if (name.equals(HINT_SHOW_LABEL) || name.equals(HINT_SHOW_LABEL_ABOVE) || name.equals(HINT_SHOW_HEADER) || name.equals(HINT_BORDER) || name.equals(HINT_BROWSE_ONLY) || name.equals(HINT_PREFER_COMBO) || name.equals(HINT_PREFER_RADIO_BUTTONS) || name.equals(HINT_PREFER_VERTICAL_RADIO_BUTTONS) || name.equals(HINT_EXPAND_VERTICALLY) || name.equals(HINT_READ_ONLY)) {
                parsedValue = Boolean.parseBoolean(valueString);
            } else if (name.equals("height") || name.equals("width")) {
                try {
                    parsedValue = Integer.parseInt(valueString);
                }
                catch (NumberFormatException e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            } else if (name.startsWith(HINT_FACTORY) || name.startsWith(HINT_AUX_TEXT_PROVIDER)) {
                parsedValue = rootdef.resolveClass(valueString);
            } else if (name.equals(HINT_LISTENERS)) {
                ArrayList contributors = new ArrayList();
                String[] stringArray = valueString.split(",");
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String segment = stringArray[n3];
                    Class<?> cl = rootdef.resolveClass(segment.trim());
                    if (cl != null) {
                        contributors.add(cl);
                    }
                    ++n3;
                }
                parsedValue = contributors;
            }
            this.hints.put(name, parsedValue);
        }
        this.relatedContentParts = new ArrayList<SapphirePart>();
        this.relatedContentPartsReadOnly = Collections.unmodifiableList(this.relatedContentParts);
        for (ISapphirePartDef relatedContentPartDef : propertyEditorPartDef.getRelatedContent()) {
            this.relatedContentParts.add(SapphirePropertyEditor.create(this, this.element, relatedContentPartDef, this.params));
        }
    }

    public IModelElement getLocalModelElement() {
        return this.element;
    }

    public ModelProperty getProperty() {
        return this.property;
    }

    public List<ModelProperty> getChildProperties() {
        return this.childPropertiesReadOnly;
    }

    public SapphirePropertyEditor getChildPropertyEditor(final IModelElement element, ModelProperty property) {
        SapphirePropertyEditor propertyEditor;
        Map<ModelProperty, SapphirePropertyEditor> propertyEditorsForElement = this.childPropertyEditors.get(element);
        if (propertyEditorsForElement == null) {
            propertyEditorsForElement = new HashMap<ModelProperty, SapphirePropertyEditor>();
            this.childPropertyEditors.put(element, propertyEditorsForElement);
            final Map<ModelProperty, SapphirePropertyEditor> finalPropertyEditorsForElement = propertyEditorsForElement;
            element.addListener(new ModelElementListener(){

                public void handleElementDisposedEvent(ModelElementDisposedEvent event) {
                    for (SapphirePropertyEditor propertyEditor : finalPropertyEditorsForElement.values()) {
                        propertyEditor.dispose();
                    }
                    SapphirePropertyEditor.this.childPropertyEditors.remove(element);
                }
            });
        }
        if ((propertyEditor = propertyEditorsForElement.get(property)) == null) {
            String propertyName = property.getName();
            ISapphirePropertyEditorDef def = null;
            for (ISapphirePropertyEditorDef x : ((ISapphirePropertyEditorDef)this.definition).getChildProperties()) {
                if (!propertyName.equals(x.getProperty().getText())) continue;
                def = x;
                break;
            }
            if (def == null) {
                def = (ISapphirePropertyEditorDef)ISapphirePropertyEditorDef.TYPE.instantiate();
                def.setProperty(propertyName);
            }
            propertyEditor = new SapphirePropertyEditor();
            propertyEditor.init(this, element, def, this.params);
            propertyEditorsForElement.put(property, propertyEditor);
        }
        return propertyEditor;
    }

    public <T> T getRenderingHint(String name, T defaultValue) {
        Object hintValue = this.hints == null ? null : this.hints.get(name);
        return (T)(hintValue == null ? defaultValue : hintValue);
    }

    public boolean getRenderingHint(String name, boolean defaultValue) {
        Object hintValue = this.hints == null ? null : this.hints.get(name);
        return hintValue == null ? defaultValue : (Boolean)hintValue;
    }

    public int getLeftMarginHint() {
        String leftMarginHintStr = this.getRenderingHint(HINT_MARGIN_LEFT, null);
        int leftMarginHint = 0;
        if (leftMarginHintStr != null) {
            leftMarginHintStr = leftMarginHintStr.trim();
            int length = leftMarginHintStr.length();
            if (leftMarginHintStr.endsWith("px") && length > 2) {
                try {
                    leftMarginHint = Integer.parseInt(leftMarginHintStr.substring(0, length - 2));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (leftMarginHintStr.endsWith("u") && length > 1) {
                try {
                    leftMarginHint = Integer.parseInt(leftMarginHintStr.substring(0, length - 1)) * 20;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (leftMarginHint < 0) {
            leftMarginHint = 0;
        }
        return leftMarginHint;
    }

    public List<SapphirePart> getRelatedContent() {
        return this.relatedContentPartsReadOnly;
    }

    public int getRelatedContentWidth() {
        Value<Integer> relatedContentWidth = ((ISapphirePropertyEditorDef)this.getDefinition()).getRelatedContentWidth();
        if (relatedContentWidth.validate().ok()) {
            return (Integer)relatedContentWidth.getContent();
        }
        return (Integer)relatedContentWidth.getDefaultContent();
    }

    @Override
    public void render(SapphireRenderingContext context) {
        PropertyEditorRendererFactory factory = null;
        try {
            Class factoryClass = this.getRenderingHint(HINT_FACTORY, null);
            if (factoryClass != null) {
                factory = (PropertyEditorRendererFactory)factoryClass.newInstance();
            }
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
        }
        if (factory == null) {
            for (PropertyEditorRendererFactory f : FACTORIES) {
                if (!f.isApplicableTo(this)) continue;
                factory = f;
                break;
            }
        }
        if (factory == null) {
            throw new IllegalStateException(this.property.toString());
        }
        PropertyEditorRenderer editor = factory.create(context, this);
        editor.create(context.getComposite());
    }

    @Override
    protected Status computeValidationState() {
        if (this.element.isPropertyEnabled(this.property)) {
            Object particle = this.element.read(this.property);
            if (particle instanceof Value) {
                return ((Value)particle).validate();
            }
            if (particle instanceof ModelElementList) {
                return ((ModelElementList)particle).validate();
            }
            if (particle instanceof ModelElementHandle) {
                return ((ModelElementHandle)particle).validate();
            }
        }
        return Status.createOkStatus();
    }

    public static <T> T findControlForProperty(Control context, ModelProperty property, Class<T> type) {
        Control root = context;
        while (!(root instanceof Section) && !(root instanceof SapphireControl)) {
            Composite parent = root.getParent();
            if (parent instanceof Shell) break;
            root = parent;
        }
        return SapphirePropertyEditor.findControlForPropertyHelper(root, property, type);
    }

    private static <T> T findControlForPropertyHelper(Control context, ModelProperty property, Class<T> type) {
        if (context.getData(DATA_PROPERTY) == property && type.isAssignableFrom(context.getClass())) {
            return (T)context;
        }
        if (context instanceof Composite) {
            Control[] controlArray = ((Composite)context).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                T control = SapphirePropertyEditor.findControlForPropertyHelper(child, property, type);
                if (control != null) {
                    return control;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public boolean setFocus() {
        if (this.element.isPropertyEnabled(this.property)) {
            this.notifyFocusRecievedEventListeners();
            return true;
        }
        return false;
    }

    @Override
    public boolean setFocus(ModelPath path) {
        String propertyName;
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.PropertySegment && (propertyName = ((ModelPath.PropertySegment)head).getPropertyName()).equals(this.property.getName())) {
            return this.setFocus();
        }
        return false;
    }

    public String getActionContext() {
        String context;
        if (this.property instanceof ValueProperty) {
            context = "Sapphire.ValuePropertyEditor";
        } else if (this.property instanceof ElementProperty) {
            context = "Sapphire.ElementPropertyEditor";
        } else if (this.property instanceof ListProperty) {
            context = "Sapphire.ListPropertyEditor";
        } else {
            throw new IllegalStateException();
        }
        return context;
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton(this.getActionContext());
    }

    @Override
    public boolean isSingleLinePart() {
        return this.property instanceof ValueProperty && !this.property.hasAnnotation(LongString.class);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.element.removeListener(this.listener, this.property.getName());
        }
        for (Map<ModelProperty, SapphirePropertyEditor> propertyEditorsForElement : this.childPropertyEditors.values()) {
            for (SapphirePropertyEditor propertyEditor : propertyEditorsForElement.values()) {
                propertyEditor.dispose();
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidPath;

        static {
            Resources.initializeMessages((String)SapphirePropertyEditor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

