/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public final class ProblemsAssistContributor
extends PropertyEditorAssistContributor {
    private final Status status;

    public ProblemsAssistContributor(Status status) {
        this.setId("System.ProblemsContributor");
        this.setPriority(210);
        this.status = status;
    }

    public void contribute(PropertyEditorAssistContext context) {
        if (this.status.children().isEmpty()) {
            ProblemsAssistContributor.contribute(context, this.status);
        } else {
            for (Status child : this.status.children()) {
                ProblemsAssistContributor.contribute(context, child);
            }
        }
    }

    private static void contribute(PropertyEditorAssistContext context, Status status) {
        Status.Severity valResultSeverity = status.severity();
        String imageKey = null;
        Image image = null;
        if (valResultSeverity == Status.Severity.ERROR) {
            imageKey = "error";
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        } else if (valResultSeverity == Status.Severity.WARNING) {
            imageKey = "error";
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }
        if (imageKey != null) {
            PropertyEditorAssistContribution contribution = new PropertyEditorAssistContribution();
            contribution.setText("<li style=\"image\" value=\"" + imageKey + "\">" + ProblemsAssistContributor.escapeForXml(status.message()) + "</li>");
            contribution.setImage(imageKey, image);
            PropertyEditorAssistSection section = context.getSection("problems");
            section.addContribution(contribution);
        }
    }
}

