/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.IPropertiesViewContributorPart;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImageDecoratorDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramLabelDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeImageDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeProblemDecoratorDef;
import org.eclipse.sapphire.ui.diagram.def.ImagePlacement;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.FunctionUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramNodePart
extends SapphirePart
implements IPropertiesViewContributorPart {
    private static final String DEFAULT_ACTION_ID = "Sapphire.Diagram.Node.Default";
    private DiagramNodeTemplate nodeTemplate;
    private IDiagramNodeDef definition;
    private IModelElement modelElement;
    private FunctionResult labelFunctionResult;
    private FunctionResult idFunctionResult;
    private FunctionResult imageFunctionResult;
    private List<FunctionResult> imageDecoratorFunctionResults;
    private ValueProperty labelProperty;
    private SapphireAction defaultAction;
    private SapphireActionHandler defaultActionHandler;
    private ModelPropertyListener modelPropertyListener;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private Point leftTopPos = new Point(-1, -1);
    private int nodeWidth = -1;
    private int nodeHeight = -1;

    @Override
    protected void init() {
        super.init();
        this.nodeTemplate = (DiagramNodeTemplate)this.getParentPart();
        this.definition = (IDiagramNodeDef)((SapphirePart)this).definition;
        this.modelElement = this.getModelElement();
        this.labelFunctionResult = this.initExpression(this.modelElement, (Function)((IDiagramLabelDef)this.definition.getLabel().element()).getText().getContent(), String.class, null, new Runnable(){

            public void run() {
                DiagramNodePart.this.refreshLabel();
            }
        });
        this.labelProperty = FunctionUtil.getFunctionProperty(this.modelElement, this.labelFunctionResult);
        this.idFunctionResult = this.initExpression(this.modelElement, (Function)this.definition.getInstanceId().getContent(), String.class, null, new Runnable(){

            public void run() {
            }
        });
        if (this.definition.getImage().element() != null) {
            this.imageFunctionResult = this.initExpression(this.modelElement, (Function)((IDiagramNodeImageDef)this.definition.getImage().element()).getId().getContent(), String.class, null, new Runnable(){

                public void run() {
                    DiagramNodePart.this.refreshImage();
                }
            });
        }
        ModelElementList<IDiagramImageDecoratorDef> imageDecorators = this.definition.getImageDecorators();
        this.imageDecoratorFunctionResults = new ArrayList<FunctionResult>();
        for (IDiagramImageDecoratorDef imageDecorator : imageDecorators) {
            FunctionResult imageResult = this.initExpression(this.modelElement, (Function)imageDecorator.getVisibleWhen().getContent(), String.class, null, new Runnable(){

                public void run() {
                    DiagramNodePart.this.refreshDecorator();
                }
            });
            this.imageDecoratorFunctionResults.add(imageResult);
        }
        this.defaultAction = this.getAction(DEFAULT_ACTION_ID);
        this.defaultActionHandler = this.defaultAction.getFirstActiveHandler();
        this.modelPropertyListener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                DiagramNodePart.this.notifyNodeUpdate();
            }
        };
        this.modelElement.addListener(this.modelPropertyListener, "*");
    }

    public DiagramNodeTemplate getDiagramNodeTemplate() {
        return this.nodeTemplate;
    }

    public IModelElement getLocalModelElement() {
        return this.modelElement;
    }

    public List<IDiagramImageDecoratorDef> getImageDecorators() {
        ArrayList<IDiagramImageDecoratorDef> imageDecorators = new ArrayList<IDiagramImageDecoratorDef>();
        ModelElementList<IDiagramImageDecoratorDef> defs = this.definition.getImageDecorators();
        int i = 0;
        while (i < this.imageDecoratorFunctionResults.size()) {
            String show;
            FunctionResult result = this.imageDecoratorFunctionResults.get(i);
            IDiagramImageDecoratorDef def = (IDiagramImageDecoratorDef)defs.get(i);
            if (result != null && (show = (String)result.value()) != null && show.equals("true")) {
                imageDecorators.add(def);
            }
            ++i;
        }
        return imageDecorators;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.Diagram.Node");
    }

    public SapphireAction getDefaultAction() {
        return this.defaultAction;
    }

    public SapphireActionHandler getDefaultActionHandler() {
        return this.defaultActionHandler;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        if (this.idFunctionResult != null) {
            this.idFunctionResult.dispose();
        }
        if (this.imageFunctionResult != null) {
            this.imageFunctionResult.dispose();
        }
        int i = 0;
        while (i < this.imageDecoratorFunctionResults.size()) {
            FunctionResult result = this.imageDecoratorFunctionResults.get(i);
            if (result != null) {
                result.dispose();
            }
            ++i;
        }
        this.modelElement.removeListener(this.modelPropertyListener, "*");
    }

    public String getLabel() {
        String label = null;
        if (this.labelFunctionResult != null) {
            label = (String)this.labelFunctionResult.value();
        }
        if (label == null) {
            label = "#null#";
        }
        return label;
    }

    public void setLabel(String newValue) {
        if (this.labelProperty != null) {
            this.modelElement.write(this.labelProperty, (Object)newValue);
        }
    }

    public void refreshLabel() {
        this.notifyNodeUpdate();
    }

    public void refreshImage() {
        this.notifyNodeUpdate();
    }

    public void refreshDecorator() {
        this.notifyNodeUpdate();
    }

    public boolean canEditLabel() {
        return this.labelProperty != null;
    }

    public String getNodeTypeId() {
        return (String)this.definition.getId().getContent();
    }

    public String getInstanceId() {
        String id = null;
        if (this.idFunctionResult != null) {
            id = (String)this.idFunctionResult.value();
        }
        return id;
    }

    public boolean canResizeShape() {
        return (Boolean)this.definition.isResizable().getContent();
    }

    public int getNodeWidth() {
        if (this.nodeWidth == -1) {
            if (this.definition.getWidth().getContent() != null) {
                return (Integer)this.definition.getWidth().getContent();
            }
            return -1;
        }
        return this.nodeWidth;
    }

    public int getNodeHeight() {
        if (this.nodeHeight == -1) {
            if (this.definition.getHeight().getContent() != null) {
                return (Integer)this.definition.getHeight().getContent();
            }
            return -1;
        }
        return this.nodeHeight;
    }

    public void setNodeBounds(int x, int y, int width, int height) {
        this.setNodePosition(x, y);
        this.nodeWidth = width;
        this.nodeHeight = height;
    }

    public Bounds getNodeBounds() {
        return new Bounds(this.leftTopPos.getX(), this.leftTopPos.getY(), this.nodeWidth, this.nodeHeight);
    }

    public int getHorizontalSpacing() {
        if (this.definition.getHorizontalSpacing().getContent() != null) {
            return (Integer)this.definition.getHorizontalSpacing().getContent();
        }
        return 0;
    }

    public int getVerticalSpacing() {
        if (this.definition.getVerticalSpacing().getContent() != null) {
            return (Integer)this.definition.getVerticalSpacing().getContent();
        }
        return 0;
    }

    public String getImageId() {
        if (this.imageFunctionResult != null) {
            String idStr = (String)this.imageFunctionResult.value();
            return idStr;
        }
        return null;
    }

    public ImagePlacement getImagePlacement() {
        if (this.definition.getImage().element() != null) {
            return (ImagePlacement)((Object)((IDiagramNodeImageDef)this.definition.getImage().element()).getPlacement().getContent());
        }
        return null;
    }

    public int getImageWidth() {
        if (this.definition.getImage().element() != null && ((IDiagramNodeImageDef)this.definition.getImage().element()).getWidth().getContent() != null) {
            ((IDiagramNodeImageDef)this.definition.getImage().element()).getWidth().getContent();
        }
        return 0;
    }

    public int getImageHeight() {
        if (this.definition.getImage().element() != null && ((IDiagramNodeImageDef)this.definition.getImage().element()).getHeight().getContent() != null) {
            ((IDiagramNodeImageDef)this.definition.getImage().element()).getHeight().getContent();
        }
        return 0;
    }

    public int getLabelWidth() {
        if (((IDiagramLabelDef)this.definition.getLabel().element()).getWidth().getContent() != null) {
            return (Integer)((IDiagramLabelDef)this.definition.getLabel().element()).getWidth().getContent();
        }
        return 0;
    }

    public int getLabelHeight() {
        if (((IDiagramLabelDef)this.definition.getLabel().element()).getHeight().getContent() != null) {
            return (Integer)((IDiagramLabelDef)this.definition.getLabel().element()).getHeight().getContent();
        }
        return 0;
    }

    public IDiagramNodeProblemDecoratorDef getProblemIndicatorDef() {
        return this.definition.getProblemDecorator();
    }

    public void setNodePosition(int x, int y) {
        if (this.leftTopPos.getX() != x || this.leftTopPos.getY() != y) {
            this.leftTopPos.setX(x);
            this.leftTopPos.setY(y);
            this.notifyNodeMove();
        }
    }

    public Point getNodePosition() {
        return this.leftTopPos;
    }

    private void notifyNodeUpdate() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent nue = new DiagramNodeEvent(this);
            ((SapphireDiagramPartListener)listener).handleNodeUpdateEvent(nue);
        }
    }

    private void notifyNodeMove() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent ne = new DiagramNodeEvent(this);
            ((SapphireDiagramPartListener)listener).handleNodeMoveEvent(ne);
        }
    }

    @Override
    public PropertiesViewContributionPart getPropertiesViewContribution() {
        if (this.propertiesViewContributionManager == null) {
            this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.getLocalModelElement());
        }
        return this.propertiesViewContributionManager.getPropertiesViewContribution();
    }
}

