/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.geometry.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueNormalizationService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.diagram.geometry.IBendPoint;
import org.eclipse.sapphire.ui.diagram.geometry.IDiagramConnectionGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiagramConnectionGeometry
extends ModelElement
implements IDiagramConnectionGeometry {
    private ModelElementList<IBendPoint> connectionBendpoints;
    private Value<String> connectionId;

    public DiagramConnectionGeometry(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public DiagramConnectionGeometry(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IBendPoint> getConnectionBendpoints() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.connectionBendpoints == null) {
                this.refresh((ModelProperty)PROP_CONNECTION_BENDPOINTS, true);
            }
            return this.connectionBendpoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getConnectionId() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.connectionId == null) {
                this.refresh((ModelProperty)PROP_CONNECTION_ID, true);
            }
            return this.connectionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnectionId(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_CONNECTION_ID.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_CONNECTION_ID, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_CONNECTION_ID, true);
            if (!DiagramConnectionGeometry.equal((String)this.connectionId.getText(false), (String)value)) {
                this.resource().binding(PROP_CONNECTION_ID).write(value);
                this.refresh((ModelProperty)PROP_CONNECTION_ID, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CONNECTION_BENDPOINTS) {
                if (this.connectionBendpoints == null) {
                    if (force) {
                        this.connectionBendpoints = new ModelElementList((IModelElement)this, PROP_CONNECTION_BENDPOINTS);
                        ListBindingImpl binding = this.resource().binding(PROP_CONNECTION_BENDPOINTS);
                        this.connectionBendpoints.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_CONNECTION_BENDPOINTS);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CONNECTION_BENDPOINTS);
                    boolean notified = this.connectionBendpoints.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_CONNECTION_BENDPOINTS, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_CONNECTION_ID && (this.connectionId != null || force)) {
                Value<String> oldValue = this.connectionId;
                String val = this.resource().binding(PROP_CONNECTION_ID).read();
                this.connectionId = new Value((IModelElement)this, PROP_CONNECTION_ID, ((ValueNormalizationService)this.service((ModelProperty)PROP_CONNECTION_ID, ValueNormalizationService.class)).normalize(PROP_CONNECTION_ID.encodeKeywords(val)));
                this.connectionId.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CONNECTION_ID);
                if (oldValue != null) {
                    if (this.connectionId.equals(oldValue)) {
                        this.connectionId = oldValue;
                    }
                    if (this.connectionId != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_CONNECTION_ID, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CONNECTION_BENDPOINTS) {
            return this.getConnectionBendpoints();
        }
        if (property == PROP_CONNECTION_ID) {
            return this.getConnectionId();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_CONNECTION_ID) {
            this.setConnectionId((String)value);
            return;
        }
        super.write(property, value);
    }
}

