/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFilter;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireActionPresentation {
    private final SapphireActionPresentationManager manager;
    private final List<SapphireActionHandlerFilter> filters = new CopyOnWriteArrayList<SapphireActionHandlerFilter>();

    public SapphireActionPresentation(SapphireActionPresentationManager manager) {
        this.manager = manager;
        manager.addPresentation(this);
    }

    public final SapphireActionPresentationManager getManager() {
        return this.manager;
    }

    public final List<SapphireAction> getActions() {
        ArrayList<SapphireAction> actions = new ArrayList<SapphireAction>();
        for (SapphireAction action : this.getManager().getActions()) {
            if (!this.hasActionHandlers(action)) continue;
            actions.add(action);
        }
        return Collections.unmodifiableList(actions);
    }

    public final boolean hasActions() {
        for (SapphireAction action : this.getManager().getActions()) {
            if (!this.hasActionHandlers(action)) continue;
            return true;
        }
        return false;
    }

    public final List<SapphireActionHandler> getActionHandlers(SapphireAction action) {
        ArrayList<SapphireActionHandler> handlers = new ArrayList<SapphireActionHandler>();
        for (SapphireActionHandler handler : action.getActiveHandlers()) {
            boolean ok = true;
            ArrayList<SapphireActionHandlerFilter> failedFilters = null;
            for (SapphireActionHandlerFilter filter : this.filters) {
                try {
                    ok = filter.check(handler);
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                    if (failedFilters == null) {
                        failedFilters = new ArrayList<SapphireActionHandlerFilter>();
                    }
                    failedFilters.add(filter);
                }
                if (!ok) break;
            }
            if (failedFilters != null) {
                this.filters.removeAll(failedFilters);
            }
            if (!ok) continue;
            handlers.add(handler);
        }
        return Collections.unmodifiableList(handlers);
    }

    public final boolean hasActionHandlers(SapphireAction action) {
        for (SapphireActionHandler handler : action.getActiveHandlers()) {
            boolean ok = true;
            ArrayList<SapphireActionHandlerFilter> failedFilters = null;
            for (SapphireActionHandlerFilter filter : this.filters) {
                try {
                    ok = filter.check(handler);
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                    if (failedFilters == null) {
                        failedFilters = new ArrayList<SapphireActionHandlerFilter>();
                    }
                    failedFilters.add(filter);
                }
                if (!ok) break;
            }
            if (failedFilters != null) {
                this.filters.removeAll(failedFilters);
            }
            if (!ok) continue;
            return true;
        }
        return false;
    }

    public final void addFilter(SapphireActionHandlerFilter filter) {
        this.filters.add(filter);
    }

    public final void removeFilter(SapphireActionHandlerFilter filter) {
        this.filters.remove(filter);
    }

    public abstract void render();

    public abstract boolean displayActionHandlerChoice(SapphireAction var1);

    protected final MenuItem renderMenuItem(Menu menu, final SapphireActionHandler handler) {
        final MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setEnabled(handler.isEnabled());
        menuItem.setText(LabelTransformer.transform((String)handler.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false));
        this.setMenuItemImage(menuItem, handler);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                handler.execute(SapphireActionPresentation.this.getManager().getContext());
            }
        });
        final SapphireActionSystemPart.Listener handlerListener = new SapphireActionSystemPart.Listener(){

            public void handleEvent(SapphireActionSystemPart.Event event) {
                String type = event.getType();
                if (type.equals("label")) {
                    menuItem.setText(LabelTransformer.transform((String)handler.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false));
                } else if (type.equals("image")) {
                    SapphireActionPresentation.this.setMenuItemImage(menuItem, handler);
                } else if (type.equals("enablement")) {
                    menuItem.setEnabled(handler.isEnabled());
                }
            }
        };
        handler.addListener(handlerListener);
        menuItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                handler.removeListener(handlerListener);
            }
        });
        return menuItem;
    }

    protected void setMenuItemImage(MenuItem menuItem, SapphireActionHandler handler) {
        Image image = null;
        ImageDescriptor desc = handler.getImage(16);
        if (desc != null) {
            image = this.getManager().getContext().getImageCache().getImage(desc);
        }
        menuItem.setImage(image);
    }

    public void dispose() {
    }
}

