/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.jdt.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeReferenceService;
import org.eclipse.sapphire.java.jdt.JdtJavaType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.annotations.Reference;

public final class JdtJavaTypeReferenceService
extends JavaTypeReferenceService {
    private final IJavaProject project;
    private IElementChangedListener listener;

    public JdtJavaTypeReferenceService(IProject project) {
        this(JavaCore.create((IProject)project));
    }

    public JdtJavaTypeReferenceService(IJavaProject project) {
        this.project = project;
    }

    public void init(final IModelElement element, final ModelProperty property, String[] params) {
        super.init(element, property, params);
        this.listener = new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                IProject project = JdtJavaTypeReferenceService.this.project.getProject();
                if (!project.exists()) {
                    JavaCore.removeElementChangedListener((IElementChangedListener)this);
                } else if (project.isAccessible()) {
                    Thread thread = new Thread(){

                        public void run() {
                            element.refresh(property);
                        }
                    };
                    thread.start();
                }
            }
        };
        JavaCore.addElementChangedListener((IElementChangedListener)this.listener, (int)1);
    }

    public JavaType resolve(String name) {
        if (name.trim().length() == 0 || name.startsWith(".") || name.endsWith(".")) {
            return null;
        }
        try {
            String n = name.replace('$', '.');
            IType type = this.project.findType(n);
            if (type != null && type.exists() && !type.isAnonymous()) {
                return new JdtJavaType(type);
            }
        }
        catch (JavaModelException e) {
            LoggingService.log((Exception)((Object)e));
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        JavaCore.removeElementChangedListener((IElementChangedListener)this.listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            Reference referenceAnnotation = (Reference)property.getAnnotation(Reference.class);
            if (referenceAnnotation == null) return false;
            if (referenceAnnotation.target() != JavaType.class) return false;
            IProject project = (IProject)element.adapt(IProject.class);
            if (project == null) return false;
            try {
                String[] stringArray = project.getDescription().getNatureIds();
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    String nature = stringArray[n2];
                    if (nature.equals("org.eclipse.jdt.core.javanature")) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                LoggingService.log((Exception)((Object)e));
            }
            return false;
        }

        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            IProject project = (IProject)element.adapt(IProject.class);
            return new JdtJavaTypeReferenceService(project);
        }
    }
}

