/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelMetadataItem;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.PropertyListeners;
import org.eclipse.sapphire.modeling.annotations.ReadOnly;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.LocalizationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelProperty
extends ModelMetadataItem {
    public static final String PROPERTY_FIELD_PREFIX = "PROP_";
    private final ModelElementType modelElementType;
    private final String propertyName;
    private final ModelProperty baseProperty;
    private final Class<?> typeClass;
    private final ModelElementType type;
    private final List<Class<?>> allPossibleTypeClasses;
    private final List<Class<?>> allPossibleTypeClassesReadOnly;
    private final List<ModelElementType> allPossibleTypes;
    private final List<ModelElementType> allPossibleTypesReadOnly;
    private final Map<Class<? extends Annotation>, Annotation> annotations;
    private Set<ModelPropertyListener> listeners;
    private Set<ModelPropertyListener> listenersReadOnly;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelProperty(ModelElementType modelElementType, String propertyName, ModelProperty baseProperty) {
        block18: {
            Class<? extends ModelPropertyListener> cl;
            int n;
            int n2;
            Class<ModelPropertyListener>[] classArray;
            block17: {
                try {
                    this.modelElementType = modelElementType;
                    this.propertyName = propertyName;
                    this.baseProperty = baseProperty;
                    this.annotations = new HashMap<Class<? extends Annotation>, Annotation>();
                    this.gatherAnnotations();
                    PropertyListeners propertyListenersAnnotation = this.getAnnotation(PropertyListeners.class);
                    if (propertyListenersAnnotation == null) break block17;
                    classArray = propertyListenersAnnotation.value();
                    n2 = classArray.length;
                    n = 0;
                    while (n < n2) {
                        cl = classArray[n];
                        try {
                            this.addListener(cl.newInstance());
                        }
                        catch (Exception e) {
                            LoggingService.log(e);
                        }
                        ++n;
                    }
                }
                catch (RuntimeException e) {
                    LoggingService.log(e);
                    throw e;
                }
            }
            try {
                Type typeAnnotation = this.getAnnotation(Type.class);
                if (typeAnnotation == null) {
                    if (!(this instanceof ValueProperty)) {
                        String message = "Property \"" + propertyName + "\" of " + this.modelElementType.getModelElementClass().getClass() + " is missing the required Type annotation.";
                        throw new IllegalStateException(message);
                    }
                    this.typeClass = String.class;
                    this.allPossibleTypeClasses = Collections.singletonList(this.typeClass);
                    this.allPossibleTypeClassesReadOnly = this.allPossibleTypeClasses;
                    break block18;
                }
                this.typeClass = typeAnnotation.base();
                if (typeAnnotation.possible().length == 0) {
                    this.allPossibleTypeClasses = Collections.singletonList(this.typeClass);
                    this.allPossibleTypeClassesReadOnly = this.allPossibleTypeClasses;
                    break block18;
                }
                this.allPossibleTypeClasses = new ArrayList();
                classArray = typeAnnotation.possible();
                n2 = classArray.length;
                n = 0;
                while (true) {
                    if (n >= n2) {
                        this.allPossibleTypeClassesReadOnly = Collections.unmodifiableList(this.allPossibleTypeClasses);
                        break;
                    }
                    cl = classArray[n];
                    this.allPossibleTypeClasses.add(cl);
                    ++n;
                }
            }
            catch (RuntimeException e) {
                LoggingService.log(e);
                throw e;
            }
        }
        if (this instanceof ValueProperty || this instanceof TransientProperty) {
            this.type = null;
            this.allPossibleTypes = Collections.emptyList();
            this.allPossibleTypesReadOnly = Collections.emptyList();
        } else {
            this.type = ModelElementType.getModelElementType(this.typeClass);
            if (this.allPossibleTypeClasses.size() == 1) {
                this.allPossibleTypes = Collections.singletonList(ModelElementType.getModelElementType(this.typeClass));
                this.allPossibleTypesReadOnly = this.allPossibleTypes;
            } else {
                this.allPossibleTypes = new ArrayList<ModelElementType>();
                for (Class<?> cl : this.allPossibleTypeClasses) {
                    this.allPossibleTypes.add(ModelElementType.getModelElementType(cl));
                }
                this.allPossibleTypesReadOnly = Collections.unmodifiableList(this.allPossibleTypes);
            }
        }
        this.modelElementType.addProperty(this);
    }

    public ModelElementType getModelElementType() {
        return this.modelElementType;
    }

    public String getName() {
        return this.propertyName;
    }

    public final Class<?> getTypeClass() {
        return this.typeClass;
    }

    public final ModelElementType getType() {
        return this.type;
    }

    public final List<Class<?>> getAllPossibleTypeClasses() {
        return this.allPossibleTypeClassesReadOnly;
    }

    public final List<ModelElementType> getAllPossibleTypes() {
        return this.allPossibleTypesReadOnly;
    }

    public final boolean isOfType(Class<?> type) {
        return type.isAssignableFrom(this.getTypeClass());
    }

    @Override
    public ModelProperty getBase() {
        return this.baseProperty;
    }

    @Override
    public <A extends Annotation> List<A> getAnnotations(Class<A> type) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Annotation annotation = this.annotations.get(type);
        if (annotation != null) {
            annotations.add(annotation);
        }
        if (this.baseProperty != null) {
            annotations.addAll(this.baseProperty.getAnnotations(type));
        }
        return annotations;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> type, boolean localOnly) {
        Annotation annotation = this.annotations.get(type);
        if (annotation == null && this.baseProperty != null && !localOnly) {
            annotation = this.baseProperty.getAnnotation(type);
        }
        return (A)annotation;
    }

    @Override
    protected final String getDefaultLabel() {
        return LocalizationUtil.transformCamelCaseToLabel(this.propertyName);
    }

    @Override
    public final LocalizationService getLocalizationService() {
        return this.modelElementType.getLocalizationService();
    }

    public ModelProperty refine(ModelElementType type) {
        return type.getProperty(this.propertyName);
    }

    public ModelProperty refine(IModelElement modelElement) {
        return this.refine(ModelElementType.getModelElementType(modelElement.getClass()));
    }

    public boolean isReadOnly() {
        return this.hasAnnotation(ReadOnly.class);
    }

    private void gatherAnnotations() {
        AccessibleObject propField = null;
        Object[] objectArray = this.modelElementType.getModelElementClass().getFields();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propName;
            Field field = objectArray[n2];
            String fieldName = field.getName();
            if (fieldName.startsWith(PROPERTY_FIELD_PREFIX) && this.propertyName.equalsIgnoreCase(propName = ModelProperty.convertFieldNameToPropertyName(fieldName))) {
                propField = field;
                break;
            }
            ++n2;
        }
        if (propField != null) {
            objectArray = propField.getAnnotations();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object x = objectArray[n2];
                this.annotations.put(x.annotationType(), (Annotation)x);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ModelPropertyListener> getListeners() {
        ModelProperty modelProperty = this;
        synchronized (modelProperty) {
            if (this.listeners == null) {
                return Collections.emptySet();
            }
            return this.listenersReadOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ModelPropertyListener listener) {
        ModelProperty modelProperty = this;
        synchronized (modelProperty) {
            if (this.listeners == null) {
                this.listeners = new CopyOnWriteArraySet<ModelPropertyListener>();
                this.listenersReadOnly = Collections.unmodifiableSet(this.listeners);
            }
            this.listeners.add(listener);
        }
    }

    protected RuntimeException convertReflectiveInvocationException(Exception e) {
        Throwable cause = e.getCause();
        if (cause instanceof EditFailedException) {
            return (EditFailedException)cause;
        }
        return new RuntimeException(e);
    }

    private static String convertFieldNameToPropertyName(String fieldName) {
        if (fieldName.startsWith(PROPERTY_FIELD_PREFIX)) {
            StringBuilder buffer = new StringBuilder();
            int i = PROPERTY_FIELD_PREFIX.length();
            while (i < fieldName.length()) {
                char ch = fieldName.charAt(i);
                if (ch != '_') {
                    buffer.append(ch);
                }
                ++i;
            }
            return buffer.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.modelElementType.getModelElementClass().getName());
        buf.append('#');
        buf.append(this.propertyName);
        return buf.toString();
    }
}

