/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.EnablementService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;

public final class FunctionBasedEnablementService
extends EnablementService {
    private final List<FunctionResult> functionResults = new ArrayList<FunctionResult>();

    public void initEnablementService(IModelElement element, ModelProperty property, String[] params) {
        ModelElementFunctionContext context = new ModelElementFunctionContext(element);
        FunctionResult.Listener functionResultListener = new FunctionResult.Listener(){

            public void handleValueChanged() {
                FunctionBasedEnablementService.this.refresh();
            }
        };
        for (Enablement annotation : property.getAnnotations(Enablement.class)) {
            Function function = null;
            try {
                function = ExpressionLanguageParser.parse(annotation.expr());
            }
            catch (Exception e) {
                LoggingService.log(e);
                function = null;
            }
            if (function == null) continue;
            function = FailSafeFunction.create(function, Literal.create(Boolean.class), Literal.create(Boolean.FALSE));
            FunctionResult functionResult = function.evaluate(context);
            functionResult.addListener(functionResultListener);
            this.functionResults.add(functionResult);
        }
    }

    public boolean compute() {
        boolean state = true;
        for (FunctionResult result : this.functionResults) {
            boolean bl = state = state && (Boolean)result.value() != false;
        }
        return state;
    }

    public void dispose() {
        super.dispose();
        for (FunctionResult result : this.functionResults) {
            try {
                result.dispose();
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return property.hasAnnotation(Enablement.class);
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return new FunctionBasedEnablementService();
        }
    }
}

