/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validation;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyValidationService;
import org.eclipse.sapphire.modeling.ModelService;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.validation.PathValidation;
import org.eclipse.sapphire.services.FileExtensionsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PathValidationService
extends ModelPropertyValidationService<Value<Path>> {
    protected boolean resourceMustExist;
    protected FileSystemResourceType validResourceType;
    private FileExtensionsService fileExtensionsService;

    @Override
    public void init(final IModelElement element, final ModelProperty property, String[] params) {
        super.init(element, property, params);
        this.resourceMustExist = property.hasAnnotation(MustExist.class);
        ValidFileSystemResourceType validResourceTypeAnnotation = property.getAnnotation(ValidFileSystemResourceType.class);
        this.validResourceType = validResourceTypeAnnotation != null ? validResourceTypeAnnotation.value() : null;
        this.fileExtensionsService = element.service(property, FileExtensionsService.class);
        if (this.fileExtensionsService != null) {
            this.fileExtensionsService.addListener(new ModelService.Listener(){

                public void handleEvent(ModelService.Event event) {
                    if (event instanceof FileExtensionsService.FileExtensionsChangedEvent) {
                        element.refresh(property);
                    }
                }
            });
        }
    }

    protected final Status validateExtensions(Path path) {
        String fileName;
        if (this.fileExtensionsService != null && (fileName = path.lastSegment()) != null) {
            return PathValidation.validateExtensions(fileName, this.fileExtensionsService.extensions());
        }
        return Status.createOkStatus();
    }

    protected static final class Resources
    extends NLS {
        public static String folderMustExist;
        public static String fileMustExist;
        public static String resourceMustExist;
        public static String pathIsNotFile;
        public static String pathIsNotFolder;

        static {
            Resources.initializeMessages(PathValidationService.class.getName(), Resources.class);
        }

        protected Resources() {
        }
    }
}

