/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileExtensionsService
extends ModelPropertyService {
    private List<String> extensions = Collections.emptyList();

    @Override
    public final void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        this.initFileExtensionsService(element, property, params);
        this.refresh(false);
    }

    protected void initFileExtensionsService(IModelElement element, ModelProperty property, String[] params) {
    }

    public final List<String> extensions() {
        return this.extensions;
    }

    protected abstract void compute(List<String> var1);

    protected final void refresh() {
        this.refresh(true);
    }

    protected final void refresh(boolean notifyListeners) {
        List<String> extensions = new ArrayList<String>();
        try {
            this.compute(extensions);
        }
        catch (Exception e) {
            LoggingService.log(e);
        }
        extensions = FileExtensionsService.scrub(extensions);
        if (!this.extensions.equals(extensions)) {
            this.extensions = extensions;
            if (notifyListeners) {
                this.notifyListeners(new FileExtensionsChangedEvent(this));
            }
        }
    }

    private static List<String> scrub(List<String> extensions) {
        ArrayList<String> clean = new ArrayList<String>();
        for (String extension : extensions) {
            if (extension == null || (extension = extension.trim()).length() <= 0) continue;
            clean.add(extension);
        }
        return Collections.unmodifiableList(clean);
    }

    public static class FileExtensionsChangedEvent
    extends ModelService.Event {
        public FileExtensionsChangedEvent(ModelService service) {
            super(service);
        }
    }
}

