/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ImageService;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.ModelService;
import org.eclipse.sapphire.samples.contacts.IContact;

public final class ContactImageService
extends ImageService {
    private static final ImageData IMG_PERSON = ImageData.readFromClassLoader(IContact.class, (String)"Contact.png");
    private static final ImageData IMG_PERSON_FADED = ImageData.readFromClassLoader(IContact.class, (String)"ContactFaded.png");
    private ModelPropertyListener listener;

    public void init(IModelElement element, String[] params) {
        super.init(element, params);
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                ContactImageService.this.notifyListeners((ModelService.Event)new ImageService.ImageChangedEvent((ImageService)ContactImageService.this));
            }
        };
        element.addListener(this.listener, IContact.PROP_E_MAIL.getName());
    }

    public ImageData provide() {
        if (((IContact)this.element()).getEMail().getContent() == null) {
            return IMG_PERSON_FADED;
        }
        return IMG_PERSON;
    }

    public void dispose() {
        super.dispose();
        this.element().removeListener(this.listener, IContact.PROP_E_MAIL.getName());
    }
}

