/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueNormalizationService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.samples.gallery.IChildElementWithEnum;
import org.eclipse.sapphire.samples.gallery.ThreeChoiceAnswer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChildElementWithEnum
extends ModelElement
implements IChildElementWithEnum {
    private Value<ThreeChoiceAnswer> enumValue;
    private Value<String> stringValue;

    public ChildElementWithEnum(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ChildElementWithEnum(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<ThreeChoiceAnswer> getEnumValue() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.enumValue == null) {
                this.refresh((ModelProperty)PROP_ENUM_VALUE, true);
            }
            return this.enumValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnumValue(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ENUM_VALUE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_ENUM_VALUE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_ENUM_VALUE, true);
            if (!ChildElementWithEnum.equal((String)this.enumValue.getText(false), (String)value)) {
                this.resource().binding(PROP_ENUM_VALUE).write(value);
                this.refresh((ModelProperty)PROP_ENUM_VALUE, false);
            }
        }
    }

    @Override
    public void setEnumValue(ThreeChoiceAnswer value) {
        this.setEnumValue(value != null ? ((ValueSerializationService)this.service((ModelProperty)PROP_ENUM_VALUE, ValueSerializationService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStringValue() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.stringValue == null) {
                this.refresh((ModelProperty)PROP_STRING_VALUE, true);
            }
            return this.stringValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringValue(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STRING_VALUE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING_VALUE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_STRING_VALUE, true);
            if (!ChildElementWithEnum.equal((String)this.stringValue.getText(false), (String)value)) {
                this.resource().binding(PROP_STRING_VALUE).write(value);
                this.refresh((ModelProperty)PROP_STRING_VALUE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ENUM_VALUE) {
                if (this.enumValue != null || force) {
                    Value<ThreeChoiceAnswer> oldValue = this.enumValue;
                    String val = this.resource().binding(PROP_ENUM_VALUE).read();
                    this.enumValue = new Value((IModelElement)this, PROP_ENUM_VALUE, ((ValueNormalizationService)this.service((ModelProperty)PROP_ENUM_VALUE, ValueNormalizationService.class)).normalize(PROP_ENUM_VALUE.encodeKeywords(val)));
                    this.enumValue.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ENUM_VALUE);
                    if (oldValue != null) {
                        if (this.enumValue.equals(oldValue)) {
                            this.enumValue = oldValue;
                        }
                        if (this.enumValue != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_ENUM_VALUE, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_STRING_VALUE && (this.stringValue != null || force)) {
                Value<String> oldValue = this.stringValue;
                String val = this.resource().binding(PROP_STRING_VALUE).read();
                this.stringValue = new Value((IModelElement)this, PROP_STRING_VALUE, ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING_VALUE, ValueNormalizationService.class)).normalize(PROP_STRING_VALUE.encodeKeywords(val)));
                this.stringValue.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_STRING_VALUE);
                if (oldValue != null) {
                    if (this.stringValue.equals(oldValue)) {
                        this.stringValue = oldValue;
                    }
                    if (this.stringValue != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_STRING_VALUE, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_ENUM_VALUE) {
            return this.getEnumValue();
        }
        if (property == PROP_STRING_VALUE) {
            return this.getStringValue();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_ENUM_VALUE) {
            if (!(value instanceof String)) {
                this.setEnumValue((ThreeChoiceAnswer)((Object)value));
            } else {
                this.setEnumValue((String)value);
            }
            return;
        }
        if (property == PROP_STRING_VALUE) {
            this.setStringValue((String)value);
            return;
        }
        super.write(property, value);
    }
}

