/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.extensibility.internal;

import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueNormalizationService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.sdk.extensibility.IModelElementServiceDef;
import org.eclipse.sapphire.sdk.extensibility.IModelElementServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementServiceDef
extends ModelElement
implements IModelElementServiceDef {
    private Value<String> description;
    private ReferenceValue<JavaTypeName, JavaType> factoryClass;
    private Value<String> id;
    private ModelElementList<IModelElementServiceRef> overrides;
    private ReferenceValue<JavaTypeName, JavaType> typeClass;

    public ModelElementServiceDef(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ModelElementServiceDef(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getDescription() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.description == null) {
                this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            }
            return this.description;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_DESCRIPTION.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_DESCRIPTION, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            if (!ModelElementServiceDef.equal((String)this.description.getText(false), (String)value)) {
                this.resource().binding(PROP_DESCRIPTION).write(value);
                this.refresh((ModelProperty)PROP_DESCRIPTION, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceValue<JavaTypeName, JavaType> getFactoryClass() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.factoryClass == null) {
                this.refresh((ModelProperty)PROP_FACTORY_CLASS, true);
            }
            return this.factoryClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFactoryClass(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_FACTORY_CLASS.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_FACTORY_CLASS, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_FACTORY_CLASS, true);
            if (!ModelElementServiceDef.equal((String)this.factoryClass.getText(false), (String)value)) {
                this.resource().binding(PROP_FACTORY_CLASS).write(value);
                this.refresh((ModelProperty)PROP_FACTORY_CLASS, false);
            }
        }
    }

    @Override
    public void setFactoryClass(JavaTypeName value) {
        this.setFactoryClass(value != null ? ((ValueSerializationService)this.service((ModelProperty)PROP_FACTORY_CLASS, ValueSerializationService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getId() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.id == null) {
                this.refresh((ModelProperty)PROP_ID, true);
            }
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setId(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ID.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_ID, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_ID, true);
            if (!ModelElementServiceDef.equal((String)this.id.getText(false), (String)value)) {
                this.resource().binding(PROP_ID).write(value);
                this.refresh((ModelProperty)PROP_ID, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IModelElementServiceRef> getOverrides() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.overrides == null) {
                this.refresh((ModelProperty)PROP_OVERRIDES, true);
            }
            return this.overrides;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceValue<JavaTypeName, JavaType> getTypeClass() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.typeClass == null) {
                this.refresh((ModelProperty)PROP_TYPE_CLASS, true);
            }
            return this.typeClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTypeClass(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_TYPE_CLASS.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_TYPE_CLASS, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_TYPE_CLASS, true);
            if (!ModelElementServiceDef.equal((String)this.typeClass.getText(false), (String)value)) {
                this.resource().binding(PROP_TYPE_CLASS).write(value);
                this.refresh((ModelProperty)PROP_TYPE_CLASS, false);
            }
        }
    }

    @Override
    public void setTypeClass(JavaTypeName value) {
        this.setTypeClass(value != null ? ((ValueSerializationService)this.service((ModelProperty)PROP_TYPE_CLASS, ValueSerializationService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_DESCRIPTION) {
                if (this.description != null || force) {
                    Value<String> oldValue = this.description;
                    String val = this.resource().binding(PROP_DESCRIPTION).read();
                    this.description = new Value((IModelElement)this, PROP_DESCRIPTION, ((ValueNormalizationService)this.service((ModelProperty)PROP_DESCRIPTION, ValueNormalizationService.class)).normalize(PROP_DESCRIPTION.encodeKeywords(val)));
                    this.description.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DESCRIPTION);
                    if (oldValue != null) {
                        if (this.description.equals(oldValue)) {
                            this.description = oldValue;
                        }
                        if (this.description != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_DESCRIPTION, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_FACTORY_CLASS) {
                if (this.factoryClass != null || force) {
                    ReferenceValue<JavaTypeName, JavaType> oldValue = this.factoryClass;
                    String val = this.resource().binding(PROP_FACTORY_CLASS).read();
                    this.factoryClass = new ReferenceValue((IModelElement)this, PROP_FACTORY_CLASS, ((ValueNormalizationService)this.service((ModelProperty)PROP_FACTORY_CLASS, ValueNormalizationService.class)).normalize(PROP_FACTORY_CLASS.encodeKeywords(val)));
                    this.factoryClass.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_FACTORY_CLASS);
                    if (oldValue != null) {
                        if (this.factoryClass.equals(oldValue)) {
                            this.factoryClass = oldValue;
                        }
                        if (this.factoryClass != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_FACTORY_CLASS, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_ID) {
                if (this.id != null || force) {
                    Value<String> oldValue = this.id;
                    String val = this.resource().binding(PROP_ID).read();
                    this.id = new Value((IModelElement)this, PROP_ID, ((ValueNormalizationService)this.service((ModelProperty)PROP_ID, ValueNormalizationService.class)).normalize(PROP_ID.encodeKeywords(val)));
                    this.id.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ID);
                    if (oldValue != null) {
                        if (this.id.equals(oldValue)) {
                            this.id = oldValue;
                        }
                        if (this.id != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_ID, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_OVERRIDES) {
                if (this.overrides == null) {
                    if (force) {
                        this.overrides = new ModelElementList((IModelElement)this, PROP_OVERRIDES);
                        ListBindingImpl binding = this.resource().binding(PROP_OVERRIDES);
                        this.overrides.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_OVERRIDES);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_OVERRIDES);
                    boolean notified = this.overrides.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_OVERRIDES, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_TYPE_CLASS && (this.typeClass != null || force)) {
                ReferenceValue<JavaTypeName, JavaType> oldValue = this.typeClass;
                String val = this.resource().binding(PROP_TYPE_CLASS).read();
                this.typeClass = new ReferenceValue((IModelElement)this, PROP_TYPE_CLASS, ((ValueNormalizationService)this.service((ModelProperty)PROP_TYPE_CLASS, ValueNormalizationService.class)).normalize(PROP_TYPE_CLASS.encodeKeywords(val)));
                this.typeClass.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_TYPE_CLASS);
                if (oldValue != null) {
                    if (this.typeClass.equals(oldValue)) {
                        this.typeClass = oldValue;
                    }
                    if (this.typeClass != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_TYPE_CLASS, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_DESCRIPTION) {
            return this.getDescription();
        }
        if (property == PROP_FACTORY_CLASS) {
            return this.getFactoryClass();
        }
        if (property == PROP_ID) {
            return this.getId();
        }
        if (property == PROP_OVERRIDES) {
            return this.getOverrides();
        }
        if (property == PROP_TYPE_CLASS) {
            return this.getTypeClass();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_DESCRIPTION) {
            this.setDescription((String)value);
            return;
        }
        if (property == PROP_FACTORY_CLASS) {
            if (!(value instanceof String)) {
                this.setFactoryClass((JavaTypeName)value);
            } else {
                this.setFactoryClass((String)value);
            }
            return;
        }
        if (property == PROP_ID) {
            this.setId((String)value);
            return;
        }
        if (property == PROP_TYPE_CLASS) {
            if (!(value instanceof String)) {
                this.setTypeClass((JavaTypeName)value);
            } else {
                this.setTypeClass((String)value);
            }
            return;
        }
        super.write(property, value);
    }
}

