/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;
import org.eclipse.sapphire.ui.diagram.def.IDiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.swt.graphiti.DiagramRenderingContext;
import org.eclipse.sapphire.ui.swt.graphiti.editor.DiagramGeometryWrapper;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditorContextMenuProvider;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditorInput;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphireDiagramFeatureProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.editor.FormEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphireDiagramEditor
extends DiagramEditor {
    private SapphireDiagramEditorPagePart diagramPart;
    private DiagramGeometryWrapper diagramGeometry;
    private IDiagramEditorPageDef diagramPageDef;
    private SapphireDiagramPartListener diagramPartListener;
    private int defaultX = 50;
    private int defaultY = 50;
    private static int xInc = 100;
    private static int yInc = 0;
    private List<SapphirePart> selectedParts = null;
    private boolean editorIsDirty = false;

    public SapphireDiagramEditor(IModelElement rootModelElement, IPath pageDefinitionLocation) {
        String bundleId = pageDefinitionLocation.segment(0);
        String pageId = pageDefinitionLocation.lastSegment();
        String relPath = pageDefinitionLocation.removeFirstSegments(1).removeLastSegments(1).toPortableString();
        ISapphireUiDef def = SapphireUiDefFactory.load((String)bundleId, (String)relPath);
        this.diagramPageDef = (IDiagramEditorPageDef)def.getPartDef(pageId, true, IDiagramEditorPageDef.class);
        this.diagramPart = new SapphireDiagramEditorPagePart();
        this.diagramPart.init(null, rootModelElement, (ISapphirePartDef)this.diagramPageDef, Collections.emptyMap());
        this.diagramPartListener = new SapphireDiagramPartListener(){

            public void handleNodeUpdateEvent(DiagramNodeEvent event) {
                SapphireDiagramEditor.this.updateNode((DiagramNodePart)event.getPart());
            }

            public void handleNodeAddEvent(DiagramNodeEvent event) {
                SapphireDiagramEditor.this.addNode((DiagramNodePart)event.getPart());
            }

            public void handleNodeDeleteEvent(DiagramNodeEvent event) {
                SapphireDiagramEditor.this.removeNode((DiagramNodePart)event.getPart());
            }

            public void handleNodeMoveEvent(DiagramNodeEvent event) {
                SapphireDiagramEditor.this.moveNode((DiagramNodePart)event.getPart());
            }

            public void handleConnectionUpdateEvent(DiagramConnectionEvent event) {
                SapphireDiagramEditor.this.updateConnection((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionEndpointEvent(DiagramConnectionEvent event) {
                SapphireDiagramEditor.this.updateConnectionEndpoint((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionAddEvent(DiagramConnectionEvent event) {
                SapphireDiagramEditor.this.addConnectionIfPossible((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionDeleteEvent(DiagramConnectionEvent event) {
                SapphireDiagramEditor.this.removeConnection((DiagramConnectionPart)event.getPart());
            }

            public void handleConnectionAddBendpointEvent(DiagramConnectionEvent event) {
                SapphireDiagramEditor.this.markEditorDirty();
            }

            public void handleConnectionRemoveBendpointEvent(DiagramConnectionEvent event) {
                SapphireDiagramEditor.this.markEditorDirty();
            }

            public void handleConnectionMoveBendpointEvent(DiagramConnectionEvent event) {
                SapphireDiagramEditor.this.markEditorDirty();
            }

            public void handleConnectionMoveLabelEvent(DiagramConnectionEvent event) {
                SapphireDiagramEditor.this.markEditorDirty();
            }

            public void handleGridStateChangeEvent(DiagramPageEvent event) {
                SapphireDiagramEditor.this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)new Boolean(SapphireDiagramEditor.this.diagramPart.isGridVisible()));
                SapphireDiagramEditor.this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)new Boolean(SapphireDiagramEditor.this.diagramPart.isGridVisible()));
                SapphireDiagramEditor.this.markEditorDirty();
            }

            public void handleGuideStateChangeEvent(DiagramPageEvent event) {
                SapphireDiagramEditor.this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)new Boolean(SapphireDiagramEditor.this.diagramPart.isShowGuides()));
                SapphireDiagramEditor.this.markEditorDirty();
            }

            public void handleDiagramUpdateEvent(DiagramPageEvent event) {
                SapphireDiagramEditor.this.refreshPalette();
            }
        };
        this.diagramPart.addListener((SapphirePartListener)this.diagramPartListener);
    }

    public SapphireDiagramEditorPagePart getPart() {
        return this.diagramPart;
    }

    protected ContextMenuProvider createContextMenuProvider() {
        return new SapphireDiagramEditorContextMenuProvider(this);
    }

    protected boolean shouldRegisterContextMenu() {
        return false;
    }

    public boolean isDirty() {
        return this.editorIsDirty;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorPart activeEditor;
        boolean editorIsActive = this.getSite().getPage().isPartVisible((IWorkbenchPart)this);
        if (!editorIsActive && (activeEditor = this.getSite().getPage().getActiveEditor()) != null) {
            editorIsActive = this.getSite().getPage().isPartVisible((IWorkbenchPart)activeEditor);
            if (activeEditor instanceof FormEditor && !((Object)((Object)this)).equals(((FormEditor)activeEditor).getActiveEditor())) {
                editorIsActive = false;
            }
        }
        if (editorIsActive) {
            IStructuredSelection structuredSelection;
            if (selection instanceof IStructuredSelection) {
                structuredSelection = (IStructuredSelection)selection;
                ArrayList<PictogramElement> peList = new ArrayList<PictogramElement>();
                for (Object object : structuredSelection) {
                    if (object instanceof EObject) {
                        List referencingPes = Graphiti.getLinkService().getPictogramElements(this.getDiagramTypeProvider().getDiagram(), (EObject)object);
                        if (referencingPes.size() <= 0) continue;
                        peList.addAll(referencingPes);
                        continue;
                    }
                    PictogramElement[] relatedPictogramElements = this.getDiagramTypeProvider().getNotificationService().calculateRelatedPictogramElements(new Object[]{object});
                    int i = 0;
                    while (i < relatedPictogramElements.length) {
                        peList.add(relatedPictogramElements[i]);
                        ++i;
                    }
                }
                PictogramElement[] pes = null;
                if (peList.size() > 0) {
                    pes = peList.toArray(new PictogramElement[peList.size()]);
                }
                if (pes != null && pes.length > 0) {
                    this.selectPictogramElements(pes);
                }
            }
            this.updateActions(this.getSelectionActions());
            if (selection instanceof StructuredSelection) {
                structuredSelection = (StructuredSelection)selection;
                ArrayList<SapphirePart> partList = new ArrayList<SapphirePart>();
                for (Object object : structuredSelection) {
                    EditPart editPart = null;
                    if (object instanceof EditPart) {
                        editPart = (EditPart)object;
                    } else if (object instanceof IAdaptable) {
                        editPart = (EditPart)((IAdaptable)object).getAdapter(EditPart.class);
                    }
                    if (editPart != null && editPart.getModel() instanceof PictogramElement) {
                        PictogramElement pe = (PictogramElement)editPart.getModel();
                        if (pe instanceof Diagram) {
                            partList.add((SapphirePart)this.getPart());
                        } else {
                            SapphireDiagramFeatureProvider sfp = (SapphireDiagramFeatureProvider)this.getDiagramTypeProvider().getFeatureProvider();
                            Object bo = sfp.getBusinessObjectForPictogramElement(pe);
                            if (bo instanceof SapphirePart) {
                                partList.add((SapphirePart)bo);
                            }
                        }
                    }
                    if (partList.size() == 1) {
                        this.getPart().setSelection((SapphirePart)partList.get(0));
                    } else {
                        this.getPart().setSelection(null);
                    }
                    this.selectedParts = partList;
                }
            }
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        SapphireDiagramEditorInput diagramInput = (SapphireDiagramEditorInput)input;
        IFile npFile = diagramInput.getLayoutFile();
        this.diagramGeometry = new DiagramGeometryWrapper(npFile, this.getPart());
        if (this.diagramGeometry.isGridPropertySet()) {
            this.diagramPart.syncGridStateWithDiagramLayout(this.diagramGeometry.isGridVisible());
        }
        if (this.diagramGeometry.isShowGuidesPropertySet()) {
            this.diagramPart.syncGuideStateWithDiagramLayout(this.diagramGeometry.isShowGuides());
        }
    }

    protected void initializeGraphicalViewer() {
        SapphireActionHandler layoutHandler;
        SapphireAction layoutAction;
        SapphireDiagramEditorInput diagramInput;
        super.initializeGraphicalViewer();
        this.syncDiagramWithModel();
        boolean isGridVisibleInViewer = (Boolean)this.getGraphicalViewer().getProperty("SnapToGrid.isVisible");
        if (this.diagramPart.isGridVisible() != isGridVisibleInViewer) {
            this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)this.diagramPart.isGridVisible());
            this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)this.diagramPart.isGridVisible());
        }
        boolean isShowGuidesInViewer = (Boolean)this.getGraphicalViewer().getProperty("SnapToGeometry.isEnabled");
        if (this.diagramPart.isShowGuides() != isShowGuidesInViewer) {
            this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)this.diagramPart.isShowGuides());
        }
        if ((diagramInput = (SapphireDiagramEditorInput)this.getEditorInput()).noExistingLayout() && (layoutAction = this.diagramPart.getAction("Sapphire.Diagram.Layout")) != null && (layoutHandler = layoutAction.getFirstActiveHandler()) != null) {
            SapphireDiagramFeatureProvider fp = (SapphireDiagramFeatureProvider)this.getDiagramTypeProvider().getFeatureProvider();
            DiagramRenderingContext ctx = fp.getRenderingContext((ISapphirePart)this.diagramPart);
            layoutHandler.execute((SapphireRenderingContext)ctx);
        }
        this.editorIsDirty = false;
        this.firePropertyChange(257);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.getDiagramGeometry().write();
            this.editorIsDirty = false;
            this.firePropertyChange(257);
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log((Throwable)e);
        }
    }

    public void dispose() {
        super.dispose();
        this.diagramPart.dispose();
    }

    public List<SapphirePart> getSelectedParts() {
        return this.selectedParts;
    }

    public Point getDefaultNodePosition() {
        int x = this.defaultX;
        int y = this.defaultY;
        this.defaultX += xInc;
        this.defaultY += yInc;
        EList containerShapes = this.getDiagramTypeProvider().getDiagram().getChildren();
        boolean overlap = true;
        block0: do {
            overlap = false;
            for (Shape shape : containerShapes) {
                int nodeX = shape.getGraphicsAlgorithm().getX();
                int nodeY = shape.getGraphicsAlgorithm().getY();
                if (Math.abs(nodeX - x) > 10 || Math.abs(nodeY - y) > 10) continue;
                overlap = true;
                x += 10;
                y += 10;
                continue block0;
            }
        } while (overlap);
        return new Point(x, y);
    }

    public DiagramGeometryWrapper getDiagramGeometry() {
        return this.diagramGeometry;
    }

    public void syncDiagramWithModel() {
        final Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)diagram);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                SapphireDiagramEditor.this.removeConnections(diagram);
                SapphireDiagramEditor.this.removeNodes(diagram);
                SapphireDiagramEditor.this.reconstructNodes(diagram);
                SapphireDiagramEditor.this.reconstructConnections(diagram);
            }
        });
    }

    private void removeConnections(Diagram diagram) {
        EList cons = diagram.getConnections();
        Iterator consIt = cons.iterator();
        HashSet<Connection> allCons = new HashSet<Connection>();
        while (consIt.hasNext()) {
            Connection con = (Connection)consIt.next();
            allCons.add(con);
        }
        for (Connection con : allCons) {
            Graphiti.getPeService().deletePictogramElement((PictogramElement)con);
        }
    }

    private void removeNodes(Diagram diagram) {
        EList containerShapes = diagram.getChildren();
        Iterator shapeIt = containerShapes.iterator();
        HashSet<Shape> allShapes = new HashSet<Shape>();
        while (shapeIt.hasNext()) {
            Shape shape = (Shape)shapeIt.next();
            allShapes.add(shape);
        }
        for (Shape containerShape : allShapes) {
            Graphiti.getPeService().deletePictogramElement((PictogramElement)containerShape);
        }
    }

    private void reconstructNodes(Diagram diagram) {
        for (DiagramNodeTemplate nodeTemplate : this.diagramPart.getNodeTemplates()) {
            if (!this.diagramPart.isNodeTemplateVisible(nodeTemplate)) continue;
            for (DiagramNodePart nodePart : nodeTemplate.getDiagramNodes()) {
                Bounds bounds = nodePart.getNodeBounds();
                if (bounds.getX() == -1 || bounds.getY() == -1) {
                    Point pt = this.getDefaultNodePosition();
                    bounds.setX(pt.getX());
                    bounds.setY(pt.getY());
                }
                AddContext ctx = new AddContext();
                ctx.setNewObject((Object)nodePart);
                ctx.setTargetContainer((ContainerShape)diagram);
                ctx.setX(bounds.getX());
                ctx.setY(bounds.getY());
                ctx.setWidth(bounds.getWidth());
                ctx.setHeight(bounds.getHeight());
                IAddFeature ft = this.getDiagramTypeProvider().getFeatureProvider().getAddFeature((IAddContext)ctx);
                ft.add((IAddContext)ctx);
            }
        }
    }

    private void reconstructConnections(Diagram diagram) {
        for (DiagramConnectionTemplate connTemplate : this.diagramPart.getConnectionTemplates()) {
            for (DiagramConnectionPart connPart : connTemplate.getDiagramConnections(null)) {
                this.addConnection(connPart);
            }
        }
        for (DiagramNodeTemplate nodeTemplate : this.diagramPart.getNodeTemplates()) {
            DiagramEmbeddedConnectionTemplate embeddedConnTemplate = nodeTemplate.getEmbeddedConnectionTemplate();
            if (embeddedConnTemplate == null) continue;
            for (DiagramConnectionPart connPart : embeddedConnTemplate.getDiagramConnections(null)) {
                this.addConnection(connPart);
            }
        }
        for (DiagramImplicitConnectionTemplate implicitConnTemplate : this.diagramPart.getImplicitConnectionTemplates()) {
            for (DiagramImplicitConnectionPart implicitConn : implicitConnTemplate.getImplicitConnections()) {
                this.addConnection((DiagramConnectionPart)implicitConn);
            }
        }
    }

    private ContainerShape getContainerShape(Object bo) {
        PictogramElement[] pictograms;
        ContainerShape containerShape = null;
        PictogramElement[] pictogramElementArray = pictograms = this.getDiagramTypeProvider().getFeatureProvider().getAllPictogramElementsForBusinessObject(bo);
        int n = pictograms.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement pictogram = pictogramElementArray[n2];
            if (pictogram instanceof ContainerShape) {
                containerShape = (ContainerShape)pictogram;
                break;
            }
            ++n2;
        }
        return containerShape;
    }

    private Connection getConnection(Object bo) {
        PictogramElement[] pictograms;
        PictogramElement[] pictogramElementArray = pictograms = this.getDiagramTypeProvider().getFeatureProvider().getAllPictogramElementsForBusinessObject(bo);
        int n = pictograms.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement pictogram = pictogramElementArray[n2];
            if (pictogram instanceof Connection) {
                return (Connection)pictogram;
            }
            ++n2;
        }
        return null;
    }

    private Connection addConnection(DiagramConnectionPart connPart) {
        Connection conn = null;
        IModelElement endpoint1 = connPart.getEndpoint1();
        IModelElement endpoint2 = connPart.getEndpoint2();
        DiagramNodePart nodePart1 = this.diagramPart.getDiagramNodePart(endpoint1);
        DiagramNodePart nodePart2 = this.diagramPart.getDiagramNodePart(endpoint2);
        if (nodePart1 != null && nodePart2 != null) {
            ContainerShape sourceShape = this.getContainerShape(nodePart1);
            ContainerShape targetShape = this.getContainerShape(nodePart2);
            if (sourceShape != null && targetShape != null) {
                Anchor sourceAnchor = (Anchor)sourceShape.getAnchors().get(0);
                Anchor targetAnchor = (Anchor)targetShape.getAnchors().get(0);
                AddConnectionContext connCtx = new AddConnectionContext(sourceAnchor, targetAnchor);
                connCtx.setNewObject((Object)connPart);
                IAddFeature fcfp = this.getDiagramTypeProvider().getFeatureProvider().getAddFeature((IAddContext)connCtx);
                conn = (Connection)fcfp.add((IAddContext)connCtx);
                if (conn instanceof FreeFormConnection && connPart.getConnectionBendpoints().size() > 0) {
                    FreeFormConnection freeConn = (FreeFormConnection)conn;
                    List bps = connPart.getConnectionBendpoints();
                    EList bendpoints = freeConn.getBendpoints();
                    int index = 0;
                    for (Point pt : bps) {
                        org.eclipse.graphiti.mm.algorithms.styles.Point newPoint = Graphiti.getGaService().createPoint(pt.getX(), pt.getY());
                        bendpoints.add(index++, newPoint);
                    }
                }
            }
        }
        return conn;
    }

    private void updateNode(DiagramNodePart nodePart) {
        IFeatureProvider fp = this.getDiagramTypeProvider().getFeatureProvider();
        ContainerShape pe = this.getContainerShape(nodePart);
        if (pe != null) {
            UpdateContext context = new UpdateContext((PictogramElement)pe);
            fp.updateIfPossible((IUpdateContext)context);
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    SapphireDiagramEditor.this.refresh();
                }
            });
            this.markEditorDirty();
        }
    }

    private void addNode(DiagramNodePart nodePart) {
        IFeatureProvider fp = this.getDiagramTypeProvider().getFeatureProvider();
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        AddContext ctx = new AddContext();
        ctx.setNewObject((Object)nodePart);
        Point pt = nodePart.getNodePosition();
        ctx.setX(pt.getX());
        ctx.setY(pt.getY());
        ctx.setTargetContainer((ContainerShape)diagram);
        fp.addIfPossible((IAddContext)ctx);
    }

    private void removeNode(DiagramNodePart nodePart) {
        RemoveContext rc;
        IRemoveFeature removeFeature;
        IFeatureProvider fp = this.getDiagramTypeProvider().getFeatureProvider();
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)diagram);
        ContainerShape pe = this.getContainerShape(nodePart);
        if (pe != null && (removeFeature = fp.getRemoveFeature((IRemoveContext)(rc = new RemoveContext((PictogramElement)pe)))) != null) {
            ted.getCommandStack().execute((Command)new RecordingCommand(ted, (IRemoveContext)rc){
                private final /* synthetic */ IRemoveContext val$rc;
                {
                    this.val$rc = iRemoveContext;
                    super($anonymous0);
                }

                protected void doExecute() {
                    removeFeature.remove(this.val$rc);
                }
            });
        }
    }

    private void moveNode(DiagramNodePart nodePart) {
        ContainerShape nodeShape = this.getContainerShape(nodePart);
        if (nodeShape == null) {
            return;
        }
        this.markEditorDirty();
        int oldX = nodeShape.getGraphicsAlgorithm().getX();
        int oldY = nodeShape.getGraphicsAlgorithm().getY();
        Bounds newBounds = nodePart.getNodeBounds();
        int newX = newBounds.getX();
        int newY = newBounds.getY();
        if (newX != oldX || newY != oldY) {
            Diagram diagram = this.getDiagramTypeProvider().getDiagram();
            TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)diagram);
            IFeatureProvider fp = this.getDiagramTypeProvider().getFeatureProvider();
            final MoveShapeContext moveContext = new MoveShapeContext((Shape)nodeShape);
            moveContext.setX(newX);
            moveContext.setY(newY);
            final IMoveShapeFeature moveFeature = fp.getMoveShapeFeature((IMoveShapeContext)moveContext);
            if (moveFeature != null) {
                ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                    protected void doExecute() {
                        moveFeature.moveShape((IMoveShapeContext)moveContext);
                    }
                });
            }
        }
    }

    private void updateConnection(DiagramConnectionPart connPart) {
        IFeatureProvider fp = this.getDiagramTypeProvider().getFeatureProvider();
        Connection pe = this.getConnection(connPart);
        if (pe != null) {
            UpdateContext context = new UpdateContext((PictogramElement)pe);
            fp.updateIfPossible((IUpdateContext)context);
        }
    }

    private void updateConnectionEndpoint(DiagramConnectionPart connPart) {
        this.removeConnection(connPart);
        this.addConnectionIfPossible(connPart);
    }

    private void removeConnection(DiagramConnectionPart connPart) {
        RemoveContext rc;
        IRemoveFeature removeFeature;
        IFeatureProvider fp = this.getDiagramTypeProvider().getFeatureProvider();
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)diagram);
        Connection pe = this.getConnection(connPart);
        if (pe != null && (removeFeature = fp.getRemoveFeature((IRemoveContext)(rc = new RemoveContext((PictogramElement)pe)))) != null) {
            ted.getCommandStack().execute((Command)new RecordingCommand(ted, (IRemoveContext)rc){
                private final /* synthetic */ IRemoveContext val$rc;
                {
                    this.val$rc = iRemoveContext;
                    super($anonymous0);
                }

                protected void doExecute() {
                    removeFeature.remove(this.val$rc);
                }
            });
        }
    }

    private void addConnectionIfPossible(final DiagramConnectionPart connPart) {
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)diagram);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                SapphireDiagramEditor.this.addConnection(connPart);
            }
        });
    }

    private void markEditorDirty() {
        this.editorIsDirty = true;
        this.firePropertyChange(257);
    }
}

