/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.features;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.ILayoutService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.sapphire.ui.Color;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.LineStyle;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.def.ConnectionEndpointType;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionEndpointDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.swt.graphiti.DiagramRenderingContext;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireConnectionRouter;
import org.eclipse.sapphire.ui.swt.graphiti.features.TextUtil;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphireDiagramFeatureProvider;

public class SapphireAddConnectionFeature
extends AbstractAddFeature {
    private static final IColorConstant DEFAULT_LINK_COLOR = new ColorConstant(51, 51, 153);

    public SapphireAddConnectionFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return context instanceof IAddConnectionContext && context.getNewObject() instanceof DiagramConnectionPart;
    }

    public PictogramElement add(IAddContext context) {
        IAddConnectionContext addConContext = (IAddConnectionContext)context;
        DiagramConnectionPart connectionPart = (DiagramConnectionPart)context.getNewObject();
        IDiagramConnectionDef connDef = connectionPart.getConnectionDef();
        IColorConstant linkColor = this.getLinkColor(connDef);
        org.eclipse.graphiti.mm.algorithms.styles.LineStyle linkStyle = this.getLinkStyle(connDef);
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        FreeFormConnection connection = peCreateService.createFreeFormConnection(this.getDiagram());
        connection.setStart(addConContext.getSourceAnchor());
        connection.setEnd(addConContext.getTargetAnchor());
        if (connectionPart.getConnectionBendpoints().isEmpty()) {
            Point bendPoint = SapphireConnectionRouter.getInstance().route(connection);
            if (bendPoint != null) {
                connection.getBendpoints().add((Object)Graphiti.getCreateService().createPoint(bendPoint.x, bendPoint.y));
                connectionPart.addBendpoint(0, bendPoint.x, bendPoint.y);
            }
        } else {
            SapphireConnectionRouter.getInstance().addConnection(connection);
        }
        IGaService gaService = Graphiti.getGaService();
        Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
        polyline.setForeground(this.manageColor(linkColor));
        polyline.setLineWidth((Integer)connDef.getLineWidth().getContent());
        polyline.setLineStyle(linkStyle);
        this.link((PictogramElement)connection, connectionPart);
        ConnectionDecorator textDecorator = peCreateService.createConnectionDecorator((Connection)connection, true, 0.5, true);
        Diagram diagram = (Diagram)context.getTargetContainer();
        Text text = TextUtil.createDefaultText(diagram, (GraphicsAlgorithmContainer)textDecorator, connectionPart.getLabel());
        text.setForeground(this.manageColor(linkColor));
        if (connectionPart.getLabelPosition() != null) {
            gaService.setLocation((GraphicsAlgorithm)text, connectionPart.getLabelPosition().getX(), connectionPart.getLabelPosition().getY());
        } else {
            Point labelPos = this.getTextLocation((Connection)connection);
            if (labelPos != null) {
                gaService.setLocation((GraphicsAlgorithm)text, labelPos.x, labelPos.y);
            }
        }
        this.createEndpointDecorator((Connection)connection, connDef.getEndpoint1(), linkColor, true);
        this.createEndpointDecorator((Connection)connection, connDef.getEndpoint2(), linkColor, false);
        IDirectEditingInfo directEditingInfo = this.getFeatureProvider().getDirectEditingInfo();
        directEditingInfo.setMainPictogramElement((PictogramElement)textDecorator);
        directEditingInfo.setPictogramElement((PictogramElement)textDecorator);
        directEditingInfo.setGraphicsAlgorithm((GraphicsAlgorithm)text);
        DiagramRenderingContext renderingCtx = new DiagramRenderingContext((ISapphirePart)connectionPart, (SapphireDiagramEditor)this.getDiagramEditor(), (GraphicsAlgorithmContainer)connection);
        SapphireDiagramFeatureProvider sfp = (SapphireDiagramFeatureProvider)this.getFeatureProvider();
        sfp.addRenderingContext((SapphirePart)connectionPart, renderingCtx);
        return connection;
    }

    private ConnectionDecorator createEndpointDecorator(Connection connection, IDiagramConnectionEndpointDef endpointDef, IColorConstant color, boolean begin) {
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ConnectionDecorator cd = null;
        cd = begin ? peCreateService.createConnectionDecorator(connection, false, 0.0, true) : peCreateService.createConnectionDecorator(connection, false, 1.0, true);
        if (endpointDef.getType().getContent() == ConnectionEndpointType.ARROW) {
            int[] nArray = new int[6];
            nArray[0] = -8;
            nArray[1] = 5;
            nArray[4] = -8;
            nArray[5] = -5;
            Polygon polygon = Graphiti.getGaCreateService().createPolygon((GraphicsAlgorithmContainer)cd, nArray);
            polygon.setBackground(this.manageColor(color));
            polygon.setFilled(Boolean.valueOf(true));
        } else if (endpointDef.getType().getContent() == ConnectionEndpointType.CIRCLE) {
            Ellipse ellipse = Graphiti.getGaCreateService().createEllipse((GraphicsAlgorithmContainer)cd);
            ellipse.setHeight(8);
            ellipse.setWidth(8);
            ellipse.setBackground(this.manageColor(color));
            ellipse.setFilled(Boolean.valueOf(true));
        } else if (endpointDef.getType().getContent() == ConnectionEndpointType.ELLIPSE) {
            Ellipse ellipse = Graphiti.getGaCreateService().createEllipse((GraphicsAlgorithmContainer)cd);
            ellipse.setHeight(6);
            ellipse.setWidth(10);
            ellipse.setBackground(this.manageColor(color));
            ellipse.setFilled(Boolean.valueOf(true));
        }
        return cd;
    }

    private IColorConstant getLinkColor(IDiagramConnectionDef def) {
        Color color;
        IColorConstant linkColor = DEFAULT_LINK_COLOR;
        if (def != null && (color = (Color)def.getLineColor().getContent()) != null) {
            linkColor = new ColorConstant(color.getRed(), color.getGreen(), color.getBlue());
        }
        return linkColor;
    }

    private org.eclipse.graphiti.mm.algorithms.styles.LineStyle getLinkStyle(IDiagramConnectionDef def) {
        org.eclipse.graphiti.mm.algorithms.styles.LineStyle linkStyle = org.eclipse.graphiti.mm.algorithms.styles.LineStyle.SOLID;
        if (def != null) {
            LineStyle style = (LineStyle)def.getLineStyle().getContent();
            if (style == LineStyle.DASH) {
                linkStyle = org.eclipse.graphiti.mm.algorithms.styles.LineStyle.DASH;
            } else if (style == LineStyle.DOT) {
                linkStyle = org.eclipse.graphiti.mm.algorithms.styles.LineStyle.DOT;
            } else if (style == LineStyle.DASH_DOT) {
                linkStyle = org.eclipse.graphiti.mm.algorithms.styles.LineStyle.DASHDOT;
            }
        }
        return linkStyle;
    }

    private Point getTextLocation(Connection conn) {
        Anchor endAnchor = conn.getEnd();
        ILayoutService layoutService = Graphiti.getLayoutService();
        ILocation endLocation = layoutService.getLocationRelativeToDiagram(endAnchor);
        Point endPoint = new Point(endLocation.getX(), endLocation.getY());
        Point midPoint = GraphitiUiInternal.getGefService().getConnectionPointAt(conn, 0.5);
        if (midPoint != null) {
            int deltaY;
            int deltaX;
            if (Math.signum(endPoint.x - midPoint.x) == Math.signum(endPoint.y - midPoint.y)) {
                deltaX = 3;
                deltaY = -10;
            } else {
                deltaX = 3;
                deltaY = 0;
            }
            return new Point(deltaX, deltaY);
        }
        return null;
    }
}

