/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.palette.impl.ConnectionCreationToolEntry;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.graphiti.palette.impl.PaletteCompartmentEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.def.HorizontalAlignment;
import org.eclipse.sapphire.ui.def.VerticalAlignment;
import org.eclipse.sapphire.ui.diagram.def.DecoratorPlacement;
import org.eclipse.sapphire.ui.diagram.def.DiagramPaletteCompartmentConstants;
import org.eclipse.sapphire.ui.diagram.def.IDiagramDecoratorDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImageDecoratorDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeProblemDecoratorDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramPaletteCompartmentDef;
import org.eclipse.sapphire.ui.diagram.def.ProblemDecoratorSize;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireCreateConnectionFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireCreateFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireCreateNodeFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireDoubleClickNodeFeature;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphirePaletteCompartmentEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphireDiagramToolBehaviorProvider
extends DefaultToolBehaviorProvider {
    private static final int SMALL_ERROR_DECORATOR_WIDTH = 7;
    private static final int SMALL_ERROR_DECORATOR_HEIGHT = 8;
    private static final int LARGE_ERROR_DECORATOR_WIDTH = 16;
    private static final int LARGE_ERROR_DECORATOR_HEIGHT = 16;

    public SapphireDiagramToolBehaviorProvider(IDiagramTypeProvider dtp) {
        super(dtp);
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        return null;
    }

    public IPaletteCompartmentEntry[] getPalette() {
        IPaletteCompartmentEntry compartment;
        int n;
        int n2;
        ICreateConnectionFeature[] iCreateConnectionFeatureArray;
        HashMap<IPaletteCompartmentEntry, List<SapphireCreateFeature>> compartmentFeatureMap = new HashMap<IPaletteCompartmentEntry, List<SapphireCreateFeature>>();
        SapphireDiagramEditor diagramEditor = (SapphireDiagramEditor)this.getDiagramTypeProvider().getDiagramEditor();
        IDiagramEditorPageDef pageDef = (IDiagramEditorPageDef)diagramEditor.getPart().getDefinition();
        ArrayList<IPaletteCompartmentEntry> compartments = new ArrayList<IPaletteCompartmentEntry>();
        ModelElementList compartmentDefs = pageDef.getPaletteCompartments();
        if (compartmentDefs.size() == 0) {
            String label = LabelTransformer.transform((String)DiagramPaletteCompartmentConstants.CONNECTIONS_COMPARTMENT_LABEL, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
            Object connEntry = new SapphirePaletteCompartmentEntry(label, "Sapphire.Diagram.Palette.Connections", null);
            compartments.add((IPaletteCompartmentEntry)connEntry);
            String label2 = LabelTransformer.transform((String)DiagramPaletteCompartmentConstants.NODES_COMPARTMENT_LABEL, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
            SapphirePaletteCompartmentEntry nodeEntry = new SapphirePaletteCompartmentEntry(label2, "Sapphire.Diagram.Palette.Nodes", null);
            compartments.add((IPaletteCompartmentEntry)nodeEntry);
        } else {
            for (IDiagramPaletteCompartmentDef compartmentDef : compartmentDefs) {
                String label = LabelTransformer.transform((String)((String)compartmentDef.getLabel().getContent()), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
                SapphirePaletteCompartmentEntry entry = new SapphirePaletteCompartmentEntry(label, (String)compartmentDef.getId().getContent(), null);
                compartments.add((IPaletteCompartmentEntry)entry);
            }
        }
        IFeatureProvider featureProvider = this.getFeatureProvider();
        ICreateConnectionFeature[] createConnectionFeatures = featureProvider.getCreateConnectionFeatures();
        ICreateFeature[] createFeatures = featureProvider.getCreateFeatures();
        if (createConnectionFeatures.length > 0) {
            iCreateConnectionFeatureArray = createConnectionFeatures;
            n2 = createConnectionFeatures.length;
            n = 0;
            while (n < n2) {
                ICreateConnectionFeature createConnectionFeature = iCreateConnectionFeatureArray[n];
                SapphireCreateConnectionFeature sapphireConnFeature = (SapphireCreateConnectionFeature)createConnectionFeature;
                compartment = this.getPaletteCompartmentEntry(sapphireConnFeature, compartments);
                if (compartment == null) {
                    compartment = (IPaletteCompartmentEntry)compartments.get(0);
                }
                this.addFeatureToCompartmentMap(sapphireConnFeature, compartment, compartmentFeatureMap);
                ++n;
            }
        }
        iCreateConnectionFeatureArray = createFeatures;
        n2 = createFeatures.length;
        n = 0;
        while (n < n2) {
            ICreateConnectionFeature createFeature = iCreateConnectionFeatureArray[n];
            SapphireCreateNodeFeature sapphireNodeFeature = (SapphireCreateNodeFeature)createFeature;
            compartment = this.getPaletteCompartmentEntry(sapphireNodeFeature, compartments);
            if (compartment == null) {
                compartment = (IPaletteCompartmentEntry)compartments.get(0);
            }
            this.addFeatureToCompartmentMap(sapphireNodeFeature, compartment, compartmentFeatureMap);
            ++n;
        }
        for (IPaletteCompartmentEntry compartmentEntry : compartmentFeatureMap.keySet()) {
            List createFeatureList = (List)compartmentFeatureMap.get(compartmentEntry);
            Object[] featureArr = createFeatureList.toArray(new SapphireCreateFeature[createFeatureList.size()]);
            Arrays.sort(featureArr);
            this.addToolsToCompartmentEntry((SapphireCreateFeature[])featureArr, (PaletteCompartmentEntry)compartmentEntry);
        }
        IPaletteCompartmentEntry[] res = compartments.toArray(new IPaletteCompartmentEntry[compartments.size()]);
        return res;
    }

    private IPaletteCompartmentEntry getPaletteCompartmentEntry(SapphireCreateFeature createFeature, List<IPaletteCompartmentEntry> compartments) {
        IPaletteCompartmentEntry foundCompartment = null;
        String compartmentId = createFeature.getPaletteCompartmentId();
        if (compartmentId != null) {
            for (IPaletteCompartmentEntry compartment : compartments) {
                String compartmentId2 = ((SapphirePaletteCompartmentEntry)compartment).getPaletteEntryId();
                if (!compartmentId.equals(compartmentId2)) continue;
                foundCompartment = compartment;
                break;
            }
        }
        return foundCompartment;
    }

    private void addFeatureToCompartmentMap(SapphireCreateFeature createFeature, IPaletteCompartmentEntry compartment, Map<IPaletteCompartmentEntry, List<SapphireCreateFeature>> compartmentFeatureMap) {
        if (!compartmentFeatureMap.containsKey(compartment)) {
            compartmentFeatureMap.put(compartment, new ArrayList());
        }
        List<SapphireCreateFeature> list = compartmentFeatureMap.get(compartment);
        list.add(createFeature);
    }

    private void addToolsToCompartmentEntry(SapphireCreateFeature[] createFeatures, PaletteCompartmentEntry entry) {
        SapphireCreateFeature[] sapphireCreateFeatureArray = createFeatures;
        int n = createFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            SapphireCreateFeature feature;
            SapphireCreateFeature createFeature = sapphireCreateFeatureArray[n2];
            if (createFeature instanceof SapphireCreateConnectionFeature) {
                feature = (SapphireCreateConnectionFeature)createFeature;
                ConnectionCreationToolEntry ccTool = new ConnectionCreationToolEntry(feature.getCreateName(), feature.getCreateDescription(), ((SapphireCreateConnectionFeature)feature).getCreateImageId(), feature.getCreateLargeImageId());
                ccTool.addCreateConnectionFeature((ICreateConnectionFeature)feature);
                entry.addToolEntry((IToolEntry)ccTool);
            } else if (createFeature instanceof SapphireCreateNodeFeature) {
                feature = (SapphireCreateNodeFeature)createFeature;
                ObjectCreationToolEntry objectCreationToolEntry = new ObjectCreationToolEntry(feature.getCreateName(), feature.getCreateDescription(), ((SapphireCreateNodeFeature)feature).getCreateImageId(), feature.getCreateLargeImageId(), (ICreateFeature)feature);
                entry.addToolEntry((IToolEntry)objectCreationToolEntry);
            }
            ++n2;
        }
    }

    public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
        PictogramElement[] pes;
        PictogramElement[] pictogramElementArray = pes = context.getPictogramElements();
        int n = pes.length;
        int n2 = 0;
        while (n2 < n) {
            Object bo;
            PictogramElement pe = pictogramElementArray[n2];
            if (pe instanceof ContainerShape) {
                DiagramNodePart nodePart;
                bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
                if (bo instanceof DiagramNodePart && ((nodePart = (DiagramNodePart)bo).getDefaultActionHandler() != null || nodePart.canEditLabel())) {
                    SapphireDoubleClickNodeFeature dblClikFeature = new SapphireDoubleClickNodeFeature(this.getFeatureProvider(), (ISapphirePart)nodePart);
                    return dblClikFeature;
                }
            } else if (pe instanceof ConnectionDecorator && pe.getGraphicsAlgorithm() instanceof Text && (bo = this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)pe.eContainer())) instanceof DiagramConnectionPart) {
                SapphireDoubleClickNodeFeature dblClikFeature = new SapphireDoubleClickNodeFeature(this.getFeatureProvider(), (ISapphirePart)((DiagramConnectionPart)bo));
                return dblClikFeature;
            }
            ++n2;
        }
        return null;
    }

    public IDecorator[] getDecorators(PictogramElement pe) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof DiagramNodePart) {
            ArrayList<IDecorator> decoratorList = new ArrayList<IDecorator>();
            DiagramNodePart nodePart = (DiagramNodePart)bo;
            if (((Boolean)nodePart.getProblemIndicatorDef().isShowDecorator().getContent()).booleanValue()) {
                this.addNodeProblemDecorator(pe, nodePart, decoratorList);
            }
            List imageDecorators = nodePart.getImageDecorators();
            for (IDiagramImageDecoratorDef imageDecorator : imageDecorators) {
                this.addNodeImageDecorator(pe, imageDecorator, decoratorList);
            }
            return decoratorList.toArray(new IDecorator[0]);
        }
        return super.getDecorators(pe);
    }

    public String getToolTip(GraphicsAlgorithm ga) {
        String name;
        PictogramElement pe = ga.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo instanceof DiagramNodePart && (name = ((DiagramNodePart)bo).getLabel()) != null && name.length() > 0) {
            return name;
        }
        return super.getToolTip(ga);
    }

    public boolean isShowGuides() {
        SapphireDiagramEditor diagramEditor = (SapphireDiagramEditor)this.getDiagramTypeProvider().getDiagramEditor();
        return diagramEditor.getPart().isGridVisible();
    }

    private void addNodeProblemDecorator(PictogramElement pe, DiagramNodePart nodePart, List<IDecorator> decoratorList) {
        IModelElement model = nodePart.getModelElement();
        IDiagramNodeProblemDecoratorDef decoratorDef = nodePart.getProblemIndicatorDef();
        Status status = model.validate();
        ImageDecorator imageRenderingDecorator = null;
        if (status.severity() != Status.Severity.OK) {
            if (status.severity() == Status.Severity.WARNING) {
                imageRenderingDecorator = decoratorDef.getSize().getContent() == ProblemDecoratorSize.SMALL ? new ImageDecorator("org.eclipse.sapphire.ui.swt.graphiti.warning") : new ImageDecorator("org.eclipse.graphiti.eclipse.warning");
            } else if (status.severity() == Status.Severity.ERROR) {
                imageRenderingDecorator = decoratorDef.getSize().getContent() == ProblemDecoratorSize.SMALL ? new ImageDecorator("org.eclipse.sapphire.ui.swt.graphiti.error") : new ImageDecorator("org.eclipse.graphiti.eclipse.error");
            }
        }
        if (imageRenderingDecorator != null) {
            int indicatorWidth = decoratorDef.getSize().getContent() == ProblemDecoratorSize.LARGE ? 16 : 7;
            int indicatorHeight = decoratorDef.getSize().getContent() == ProblemDecoratorSize.LARGE ? 16 : 8;
            Point pt = this.getDecoratorPosition(pe, (IDiagramDecoratorDef)decoratorDef, indicatorWidth, indicatorHeight);
            imageRenderingDecorator.setX(pt.getX());
            imageRenderingDecorator.setY(pt.getY());
            imageRenderingDecorator.setMessage(status.message());
            decoratorList.add((IDecorator)imageRenderingDecorator);
        }
    }

    private void addNodeImageDecorator(PictogramElement pe, IDiagramImageDecoratorDef imageDecoratorDef, List<IDecorator> decoratorList) {
        String imageId = (String)imageDecoratorDef.getImageId().getContent();
        if (imageId != null) {
            ImageDecorator imageRenderingDecorator = new ImageDecorator(imageId);
            org.eclipse.swt.graphics.Image image = GraphitiUi.getImageService().getImageForId(imageId);
            int imageWidth = image.getImageData().width;
            int imageHeight = image.getImageData().height;
            Point pt = this.getDecoratorPosition(pe, (IDiagramDecoratorDef)imageDecoratorDef, imageWidth, imageHeight);
            imageRenderingDecorator.setX(pt.getX());
            imageRenderingDecorator.setY(pt.getY());
            decoratorList.add((IDecorator)imageRenderingDecorator);
        }
    }

    private Point getDecoratorPosition(PictogramElement pe, IDiagramDecoratorDef decoratorDef, int decoratorWidth, int decoratorHeight) {
        GraphicsAlgorithm referencedGA = null;
        GraphicsAlgorithm text = null;
        ContainerShape containerShape = (ContainerShape)pe;
        EList children = containerShape.getChildren();
        for (Shape child : children) {
            GraphicsAlgorithm ga = child.getGraphicsAlgorithm();
            if (ga instanceof Image) {
                if (decoratorDef.getDecoratorPlacement().getContent() != DecoratorPlacement.IMAGE) continue;
                referencedGA = ga;
                break;
            }
            if (!(ga instanceof Text)) continue;
            if (decoratorDef.getDecoratorPlacement().getContent() == DecoratorPlacement.LABEL) {
                referencedGA = ga;
                break;
            }
            if (text != null) continue;
            text = (Text)ga;
        }
        if (referencedGA == null) {
            referencedGA = text;
        }
        if (referencedGA != null) {
            HorizontalAlignment horizontalAlign = (HorizontalAlignment)decoratorDef.getHorizontalAlignment().getContent();
            int offsetX = 0;
            int offsetY = 0;
            if (horizontalAlign == HorizontalAlignment.RIGHT) {
                offsetX = referencedGA.getWidth() - decoratorWidth;
                offsetX -= ((Integer)decoratorDef.getHorizontalMargin().getContent()).intValue();
            } else if (horizontalAlign == HorizontalAlignment.LEFT) {
                offsetX += ((Integer)decoratorDef.getHorizontalMargin().getContent()).intValue();
            } else if (horizontalAlign == HorizontalAlignment.CENTER) {
                offsetX = referencedGA.getWidth() - decoratorWidth >> 1;
            }
            VerticalAlignment verticalAlign = (VerticalAlignment)decoratorDef.getVerticalAlignment().getContent();
            if (verticalAlign == VerticalAlignment.BOTTOM) {
                offsetY = referencedGA.getHeight() - decoratorHeight;
                offsetY -= ((Integer)decoratorDef.getVerticalMargin().getContent()).intValue();
            } else if (verticalAlign == VerticalAlignment.TOP) {
                offsetY += ((Integer)decoratorDef.getVerticalMargin().getContent()).intValue();
            } else if (verticalAlign == VerticalAlignment.CENTER) {
                offsetY = (referencedGA.getHeight() - decoratorHeight) / 2;
            }
            return new Point(offsetX + referencedGA.getX(), offsetY + referencedGA.getY());
        }
        return new Point(0, 0);
    }
}

