/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphirePropertyEditorActionHandler;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireJumpActionHandler
extends SapphirePropertyEditorActionHandler {
    private ModelPropertyListener listener;
    private List<String> dependencies;

    @Override
    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        super.init(action, def);
        this.dependencies = new ArrayList<String>();
        this.initDependencies(this.dependencies);
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                SapphireJumpActionHandler.this.refreshEnablementState();
            }
        };
        IModelElement element = this.getModelElement();
        for (String dependency : this.dependencies) {
            element.addListener(this.listener, dependency);
        }
        this.refreshEnablementState();
    }

    protected void initDependencies(List<String> dependencies) {
        this.dependencies.add(this.getProperty().getName());
    }

    public final ValueProperty getProperty() {
        return (ValueProperty)super.getProperty();
    }

    @Override
    public void dispose() {
        super.dispose();
        IModelElement element = this.getModelElement();
        for (String dependency : this.dependencies) {
            element.removeListener(this.listener, dependency);
        }
    }
}

