/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.MutableReference;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireEditorFormPage;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireSection;
import org.eclipse.sapphire.ui.def.IEditorPageDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.form.editors.masterdetails.def.IMasterDetailsEditorPageDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.state.IMasterDetailsEditorPageState;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.TableWrapLayoutUtil;
import org.eclipse.sapphire.ui.swt.SapphireToolTip;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireMenuActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarManagerActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterDetailsEditorPage
extends SapphireEditorFormPage {
    private IMasterDetailsEditorPageDef definition;
    private RootSection mainSection;
    private ContentOutline contentOutlinePage;
    private IPartListener2 partListener;
    private SapphirePartListener editorPagePartListener;

    public MasterDetailsEditorPage(SapphireEditor editor, IModelElement rootModelElement, IPath pageDefinitionLocation) {
        this(editor, rootModelElement, pageDefinitionLocation, null);
    }

    public MasterDetailsEditorPage(SapphireEditor editor, IModelElement rootModelElement, IPath pageDefinitionLocation, String pageName) {
        super(editor, MasterDetailsEditorPage.createEditorPagePart(editor, rootModelElement, pageDefinitionLocation));
        IMasterDetailsEditorPageState state;
        MasterDetailsEditorPagePart part = this.getPart();
        try {
            File stateFile = editor.getDefaultStateStorageFile((Object)this);
            state = (IMasterDetailsEditorPageState)IMasterDetailsEditorPageState.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(stateFile)));
        }
        catch (ResourceStoreException resourceStoreException) {
            state = (IMasterDetailsEditorPageState)IMasterDetailsEditorPageState.TYPE.instantiate();
        }
        part.setState(state);
        this.definition = part.getDefinition();
        String partName = pageName;
        if (partName == null) {
            partName = this.definition.getPageName().getLocalizedText(CapitalizationType.TITLE_STYLE, false);
        }
        this.setPartName(partName);
        SapphireAction outlineHideAction = this.getPart().getActions("Sapphire.EditorPage").getAction("Sapphire.Outline.Hide");
        SapphireActionHandler outlineHideActionHandler = new SapphireActionHandler(){

            protected Object run(SapphireRenderingContext context) {
                MasterDetailsEditorPage.this.setDetailsMaximized(!MasterDetailsEditorPage.this.isDetailsMaximized());
                return null;
            }
        };
        outlineHideActionHandler.init(outlineHideAction, null);
        outlineHideActionHandler.setChecked(this.isDetailsMaximized());
        outlineHideAction.addHandler(outlineHideActionHandler);
    }

    private static MasterDetailsEditorPagePart createEditorPagePart(SapphireEditor editor, IModelElement rootModelElement, IPath pageDefinitionLocation) {
        String bundleId = pageDefinitionLocation.segment(0);
        String pageId = pageDefinitionLocation.lastSegment();
        String relPath = pageDefinitionLocation.removeFirstSegments(1).removeLastSegments(1).toPortableString();
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, relPath);
        IEditorPageDef editorPageDef = (IEditorPageDef)def.getPartDef(pageId, true, IEditorPageDef.class);
        if (editorPageDef == null) {
            throw new RuntimeException();
        }
        MasterDetailsEditorPagePart editorPagePart = new MasterDetailsEditorPagePart();
        editorPagePart.init(editor, rootModelElement, editorPageDef, Collections.<String, String>emptyMap());
        return editorPagePart;
    }

    public ISapphirePartDef getDefinition() {
        return this.definition;
    }

    @Override
    public String getId() {
        return this.getPartName();
    }

    @Override
    public MasterDetailsEditorPagePart getPart() {
        return (MasterDetailsEditorPagePart)super.getPart();
    }

    public MasterDetailsContentOutline getContentTree() {
        return this.getPart().getContentOutline();
    }

    public IDetailsPage getCurrentDetailsPage() {
        return this.mainSection.getCurrentDetailsSection();
    }

    /*
     * Unable to fully structure code
     */
    protected void createFormContent(IManagedForm managedForm) {
        block5: {
            part = this.getPart();
            form = managedForm.getForm();
            try {
                toolkit = managedForm.getToolkit();
                toolkit.decorateFormHeading(managedForm.getForm().getForm());
                form.setText(this.definition.getPageHeaderText().getLocalizedText(CapitalizationType.TITLE_STYLE, false));
                this.mainSection = new RootSection();
                this.mainSection.createContent(managedForm);
                doc = (ISapphireDocumentation)this.definition.getDocumentation().element();
                if (doc != null) {
                    docdef = null;
                    docdef = doc instanceof ISapphireDocumentationDef != false ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
                    if (docdef != null) {
                        SapphireHelpSystem.setHelp((Control)managedForm.getForm().getBody(), docdef);
                    }
                }
                actions = part.getActions("Sapphire.EditorPage");
                actionPresentation = new SapphireToolBarManagerActionPresentation(part, this.getSite().getShell(), actions);
                actionPresentation.setToolBarManager(form.getToolBarManager());
                actionPresentation.render();
                this.editorPagePartListener = new SapphirePartListener(){

                    public void handleEvent(SapphirePartEvent event) {
                        if (event instanceof MasterDetailsEditorPagePart.DetailsFocusRequested) {
                            MasterDetailsEditorPage.this.setFocusOnDetails();
                        }
                    }
                };
                part.addListener(this.editorPagePartListener);
                break block5;
            }
            catch (Exception e) {
                if (this.mainSection == null) break block5;
                this.mainSection.dispose();
                this.mainSection = null;
                body = (Composite)((Form)form.getChildren()[0]).getChildren()[1];
                var9_13 = body.getChildren();
                var8_14 = var9_13.length;
                actionPresentation = 0;
                ** while (actionPresentation < var8_14)
            }
lbl-1000:
            // 1 sources

            {
                control = var9_13[actionPresentation];
                control.dispose();
                ++actionPresentation;
                continue;
            }
lbl35:
            // 1 sources

            bgcolor = body.getDisplay().getSystemColor(1);
            composite = new Composite(body, 0);
            composite.setLayoutData((Object)GridLayoutUtil.gdfill());
            composite.setLayout((Layout)GridLayoutUtil.glayout(1, 5, 5, 10, 5));
            composite.setBackground(bgcolor);
            msgAndShowStackTraceLinkComposite = new Composite(composite, 0);
            msgAndShowStackTraceLinkComposite.setLayoutData((Object)GridLayoutUtil.gdhfill());
            msgAndShowStackTraceLinkComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
            msgAndShowStackTraceLinkComposite.setBackground(bgcolor);
            text = new SapphireFormText(msgAndShowStackTraceLinkComposite, 0);
            text.setLayoutData(GridLayoutUtil.gdhfill());
            text.setText("<form><li style=\"image\" value=\"error\">" + e.getMessage() + "</li></form>", true, false);
            text.setImage("error", ImageData.createFromClassLoader(SapphireImageCache.class, (String)"Error.png"));
            text.setBackground(bgcolor);
            showStackTraceLink = new SapphireFormText(msgAndShowStackTraceLinkComposite, 0);
            showStackTraceLink.setLayoutData(GridLayoutUtil.gd());
            showStackTraceLink.setText("<form><p><a href=\"show-stack\">Show stack trace...</a></p></form>", true, false);
            showStackTraceLink.setBackground(bgcolor);
            showStackTraceLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    showStackTraceLink.setVisible(false);
                    Label separator = new Label(composite, 258);
                    separator.setLayoutData((Object)GridLayoutUtil.gdhfill());
                    separator.setBackground(bgcolor);
                    Text stack = new Text(composite, 2570);
                    stack.setLayoutData((Object)GridLayoutUtil.gdfill());
                    stack.setBackground(bgcolor);
                    StringWriter w = new StringWriter();
                    e.printStackTrace(new PrintWriter(w));
                    stack.setText(w.getBuffer().toString());
                    body.layout(true, true);
                }
            });
        }
        this.partListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (!MasterDetailsEditorPage.this.isDetailsMaximized()) {
                    MasterDetailsEditorPage.this.setOutlineRatioCookie(MasterDetailsEditorPage.this.mainSection.getOutlineRatio());
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        this.getSite().getPage().addPartListener(this.partListener);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = new ContentOutline();
        }
        return this.contentOutlinePage;
    }

    public boolean isDetailsMaximized() {
        return (Boolean)this.getPart().getState().getContentOutlineState().getVisible().getContent() == false;
    }

    public void setDetailsMaximized(boolean maximized) {
        this.mainSection.setDetailsMaximized(maximized);
        try {
            this.getPart().getState().getContentOutlineState().setVisible(!maximized);
            this.getPart().getState().resource().save();
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    public double getOutlineRatio() {
        double contentOutlineRatio = (Double)this.getPart().getState().getContentOutlineState().getRatio().getContent();
        if (contentOutlineRatio < 0.0 || contentOutlineRatio > 1.0) {
            contentOutlineRatio = 0.3;
        }
        return contentOutlineRatio;
    }

    public void setOutlineRatio(Double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new IllegalArgumentException();
        }
        this.mainSection.setOutlineRatio(ratio);
        this.setOutlineRatioCookie(ratio);
    }

    private void setOutlineRatioCookie(Double ratio) {
        try {
            this.getPart().getState().getContentOutlineState().setRatio(ratio);
            this.getPart().getState().resource().save();
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    public void setFocus() {
        if (this.isDetailsMaximized()) {
            this.setFocusOnDetails();
        } else {
            this.setFocusOnContentOutline();
        }
    }

    public void setFocusOnContentOutline() {
        if (this.isDetailsMaximized()) {
            this.setDetailsMaximized(false);
        }
        if (this.mainSection != null) {
            this.mainSection.masterSection.tree.setFocus();
        }
    }

    public void setFocusOnDetails() {
        Control control = this.findFirstFocusableControl(this.mainSection.detailsSectionControl);
        if (control != null) {
            control.setFocus();
        }
    }

    private Control findFirstFocusableControl(Control control) {
        if (control instanceof Text || control instanceof Combo || control instanceof Link || control instanceof List || control instanceof Table || control instanceof Tree) {
            return control;
        }
        if (control instanceof Text) {
            if ((((Text)control).getStyle() & 8) == 0) {
                return control;
            }
        } else if (control instanceof Button) {
            int style = control.getStyle();
            if ((style & 0x20) != 0 || (style & 0x10) != 0) {
                return control;
            }
        } else if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Control res = this.findFirstFocusableControl(child);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
        }
        return null;
    }

    private FilteredTree createContentOutline(Composite parent, final MasterDetailsContentOutline contentTree, boolean addBorders) {
        int treeStyle = (addBorders ? 2048 : 0) | 2;
        final ContentOutlineFilteredTree filteredTree = new ContentOutlineFilteredTree(parent, treeStyle, contentTree);
        final TreeViewer treeViewer = filteredTree.getViewer();
        final Tree tree = treeViewer.getTree();
        ITreeContentProvider contentProvider = new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return contentTree.getRoot().getChildNodes().toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return ((MasterDetailsContentNode)parentElement).getChildNodes().toArray();
            }

            public Object getParent(Object element) {
                return ((MasterDetailsContentNode)element).getParentNode();
            }

            public boolean hasChildren(Object element) {
                return ((MasterDetailsContentNode)element).getChildNodes().size() > 0;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
        LabelProvider labelProvider = new LabelProvider(){
            private final Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

            public String getText(Object element) {
                return ((MasterDetailsContentNode)element).getLabel();
            }

            public Image getImage(Object element) {
                return this.getImage((MasterDetailsContentNode)element);
            }

            private Image getImage(MasterDetailsContentNode node) {
                ImageDescriptor imageDescriptor = node.getImage();
                Image image = this.images.get(imageDescriptor);
                if (image == null) {
                    image = imageDescriptor.createImage();
                    this.images.put(imageDescriptor, image);
                }
                return image;
            }

            public void dispose() {
                for (Image image : this.images.values()) {
                    image.dispose();
                }
            }
        };
        new SapphireToolTip((Control)tree){

            @Override
            protected Object getToolTipArea(Event event) {
                return treeViewer.getCell(new Point(event.x, event.y));
            }

            @Override
            protected boolean shouldCreateToolTip(Event event) {
                if (!super.shouldCreateToolTip(event)) {
                    return false;
                }
                this.setShift(new Point(0, 20));
                tree.setToolTipText("");
                boolean res = false;
                MasterDetailsContentNode node = this.getNode(event);
                if (node != null) {
                    res = !node.getValidationState().ok();
                }
                return res;
            }

            private MasterDetailsContentNode getNode(Event event) {
                TreeItem item = tree.getItem(new Point(event.x, event.y));
                if (item == null) {
                    return null;
                }
                return (MasterDetailsContentNode)item.getData();
            }

            @Override
            protected void afterHideToolTip(Event event) {
                super.afterHideToolTip(event);
                if (event != null && event.widget != treeViewer.getControl()) {
                    treeViewer.getControl().setFocus();
                }
            }

            @Override
            protected void createContent(Event event, Composite parent) {
                MasterDetailsContentNode node = this.getNode(event);
                parent.setLayout((Layout)GridLayoutUtil.glayout(1));
                SapphireFormText text = new SapphireFormText(parent, 524288);
                text.setLayoutData(GridLayoutUtil.gdfill());
                Status validation = node.getValidationState();
                List<Status> items = this.gather(validation);
                StringBuffer buffer = new StringBuffer();
                buffer.append("<form>");
                int count = items.size();
                int i = 0;
                for (Status item : items) {
                    String imageKey = item.severity() == Status.Severity.ERROR ? "error" : "warning";
                    buffer.append("<li style=\"image\" value=\"" + imageKey + "\">" + MiscUtil.escapeForXml((String)item.message()) + "</li>");
                    if (count > 10 && ++i == 9) break;
                }
                if (count > 10) {
                    String msg = NLS.bind((String)Resources.problemsOverflowMessage, (Object)this.numberToString(count - 9));
                    String imageKey = validation.severity() == Status.Severity.ERROR ? "error" : "warning";
                    buffer.append("<br/><li style=\"image\" value=\"" + imageKey + "\">" + msg + "</li>");
                }
                buffer.append("</form>");
                text.setText(buffer.toString(), true, false);
                text.setImage("error", ImageData.createFromClassLoader(SapphireImageCache.class, (String)"Error.png"));
                text.setImage("warning", ImageData.createFromClassLoader(SapphireImageCache.class, (String)"Warning.png"));
            }

            private String numberToString(int number) {
                switch (number) {
                    case 2: {
                        return Resources.two;
                    }
                    case 3: {
                        return Resources.three;
                    }
                    case 4: {
                        return Resources.four;
                    }
                    case 5: {
                        return Resources.five;
                    }
                    case 6: {
                        return Resources.six;
                    }
                    case 7: {
                        return Resources.seven;
                    }
                    case 8: {
                        return Resources.eight;
                    }
                    case 9: {
                        return Resources.nine;
                    }
                }
                return String.valueOf(number);
            }

            private List<Status> gather(Status status) {
                ArrayList<Status> items = new ArrayList<Status>();
                this.gather(status, items);
                return items;
            }

            private void gather(Status status, List<Status> items) {
                if (status.children().isEmpty()) {
                    items.add(status);
                } else {
                    for (Status child : status.children()) {
                        this.gather(child, items);
                    }
                }
            }
        };
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        treeViewer.setInput(new Object());
        final MutableReference ignoreSelectionChange = new MutableReference((Object)false);
        final MutableReference ignoreExpandedStateChange = new MutableReference((Object)false);
        final MasterDetailsContentOutline.Listener contentTreeListener = new MasterDetailsContentOutline.Listener(){

            @Override
            public void handleNodeUpdate(MasterDetailsContentNode node) {
                treeViewer.update((Object)node, null);
            }

            @Override
            public void handleNodeStructureChange(MasterDetailsContentNode node) {
                treeViewer.refresh((Object)node);
            }

            @Override
            public void handleSelectionChange(List<MasterDetailsContentNode> selection) {
                if (((Boolean)ignoreSelectionChange.get()).booleanValue()) {
                    return;
                }
                StructuredSelection sel = selection.isEmpty() ? StructuredSelection.EMPTY : new StructuredSelection(selection);
                if (!treeViewer.getSelection().equals(sel)) {
                    for (MasterDetailsContentNode node : selection) {
                        treeViewer.reveal((Object)node);
                    }
                    treeViewer.setSelection((ISelection)sel);
                }
            }

            @Override
            public void handleNodeExpandedStateChange(MasterDetailsContentNode node) {
                if (((Boolean)ignoreExpandedStateChange.get()).booleanValue()) {
                    return;
                }
                boolean expandedState = node.isExpanded();
                if (treeViewer.getExpandedState((Object)node) != expandedState) {
                    treeViewer.setExpandedState((Object)node, expandedState);
                }
            }

            @Override
            public void handleFilterChange(String newFilterText) {
                filteredTree.changeFilterText(newFilterText);
            }
        };
        contentTree.addListener(contentTreeListener);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ignoreSelectionChange.set((Object)true);
                try {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ArrayList<MasterDetailsContentNode> nodes = new ArrayList<MasterDetailsContentNode>();
                    Iterator itr = selection.iterator();
                    while (itr.hasNext()) {
                        nodes.add((MasterDetailsContentNode)itr.next());
                    }
                    contentTree.setSelectedNodes(nodes);
                }
                finally {
                    ignoreSelectionChange.set((Object)false);
                }
            }
        });
        treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                ignoreExpandedStateChange.set((Object)true);
                try {
                    MasterDetailsContentNode node = (MasterDetailsContentNode)event.getElement();
                    node.setExpanded(true);
                }
                finally {
                    ignoreExpandedStateChange.set((Object)false);
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                ignoreExpandedStateChange.set((Object)true);
                try {
                    MasterDetailsContentNode node = (MasterDetailsContentNode)event.getElement();
                    node.setExpanded(false);
                }
                finally {
                    ignoreExpandedStateChange.set((Object)false);
                }
            }
        });
        final ContentOutlineActionSupport actionSupport = new ContentOutlineActionSupport(contentTree, tree);
        treeViewer.setExpandedElements(contentTree.getExpandedNodes().toArray());
        contentTreeListener.handleSelectionChange(contentTree.getSelectedNodes());
        filteredTree.changeFilterText(contentTree.getFilterText());
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                contentTree.removeListener(contentTreeListener);
                actionSupport.dispose();
            }
        });
        return filteredTree;
    }

    private static void updateExpandedState(MasterDetailsContentOutline contentTree, Tree tree) {
        HashSet<MasterDetailsContentNode> expandedNodes = new HashSet<MasterDetailsContentNode>();
        MasterDetailsEditorPage.gatherExpandedNodes(tree.getItems(), expandedNodes);
        contentTree.setExpandedNodes(expandedNodes);
    }

    private static void gatherExpandedNodes(TreeItem[] items, Set<MasterDetailsContentNode> result) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getExpanded()) {
                result.add((MasterDetailsContentNode)item.getData());
                MasterDetailsEditorPage.gatherExpandedNodes(item.getItems(), result);
            }
            ++n2;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getContentTree().dispose();
        if (this.mainSection != null) {
            this.mainSection.dispose();
        }
        if (this.partListener != null) {
            this.getSite().getPage().removePartListener(this.partListener);
        }
        if (this.editorPagePartListener != null) {
            this.getPart().removeListener(this.editorPagePartListener);
        }
    }

    private final class ContentOutline
    extends Page
    implements IContentOutlinePage {
        private Composite outerComposite = null;
        private FilteredTree filteredTree = null;
        private TreeViewer treeViewer = null;

        private ContentOutline() {
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            pageSite.setSelectionProvider((ISelectionProvider)this);
        }

        public void createControl(Composite parent) {
            this.outerComposite = new Composite(parent, 0);
            this.outerComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 5, 5));
            this.outerComposite.setBackground(Display.getCurrent().getSystemColor(1));
            this.filteredTree = MasterDetailsEditorPage.this.createContentOutline(this.outerComposite, MasterDetailsEditorPage.this.getContentTree(), false);
            this.filteredTree.setLayoutData((Object)GridLayoutUtil.gdfill());
            this.treeViewer = this.filteredTree.getViewer();
            MasterDetailsEditorPagePart part = MasterDetailsEditorPage.this.getPart();
            SapphireActionGroup actions = part.getActions("Sapphire.EditorPage.Outline.Header");
            SapphireToolBarManagerActionPresentation actionsPresentation = new SapphireToolBarManagerActionPresentation(part, this.getSite().getShell(), actions);
            actionsPresentation.setToolBarManager(this.getSite().getActionBars().getToolBarManager());
            actionsPresentation.render();
        }

        public Control getControl() {
            return this.outerComposite;
        }

        public void setFocus() {
            this.treeViewer.getControl().setFocus();
        }

        public ISelection getSelection() {
            if (this.treeViewer == null) {
                return StructuredSelection.EMPTY;
            }
            return this.treeViewer.getSelection();
        }

        public void setSelection(ISelection selection) {
            if (this.treeViewer != null) {
                this.treeViewer.setSelection(selection);
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ContentOutlineActionSupport {
        private final MasterDetailsContentOutline contentTree;
        private final MasterDetailsContentOutline.Listener contentOutlineListener;
        private final Tree tree;
        private final Menu menu;
        private SapphireActionPresentationManager actionPresentationManager;
        private SapphireActionGroup tempActions;

        private ContentOutlineActionSupport(MasterDetailsContentOutline contentOutline, Tree tree) {
            this.contentTree = contentOutline;
            this.tree = tree;
            this.menu = new Menu((Control)tree);
            this.tree.setMenu(this.menu);
            this.contentOutlineListener = new MasterDetailsContentOutline.Listener(){

                @Override
                public void handleSelectionChange(List<MasterDetailsContentNode> selection) {
                    ContentOutlineActionSupport.this.handleSelectionChangedEvent(selection);
                }
            };
            this.contentTree.addListener(this.contentOutlineListener);
            this.handleSelectionChangedEvent(contentOutline.getSelectedNodes());
        }

        private void handleSelectionChangedEvent(List<MasterDetailsContentNode> selection) {
            SapphireActionGroup actions;
            MenuItem[] menuItemArray = this.menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                item.dispose();
                ++n2;
            }
            if (this.tempActions != null) {
                this.tempActions.dispose();
                this.tempActions = null;
            }
            if (this.actionPresentationManager != null) {
                this.actionPresentationManager.dispose();
                this.actionPresentationManager = null;
            }
            MasterDetailsEditorPagePart part = MasterDetailsEditorPage.this.getPart();
            if (selection.size() == 1) {
                MasterDetailsContentNode node = selection.get(0);
                actions = node.getActions("Sapphire.EditorPage.Outline.Node");
            } else {
                actions = this.tempActions = new SapphireActionGroup(part, "Sapphire.EditorPage.Outline");
            }
            this.actionPresentationManager = new SapphireActionPresentationManager(new SapphireRenderingContext((ISapphirePart)part, this.menu.getShell()), actions);
            SapphireMenuActionPresentation menuActionPresentation = new SapphireMenuActionPresentation(this.actionPresentationManager);
            menuActionPresentation.setMenu(this.menu);
            menuActionPresentation.render();
            SapphireKeyboardActionPresentation keyboardActionPresentation = new SapphireKeyboardActionPresentation(this.actionPresentationManager);
            keyboardActionPresentation.attach((Control)this.tree);
            keyboardActionPresentation.render();
        }

        public void dispose() {
            this.contentTree.removeListener(this.contentOutlineListener);
            if (this.tempActions != null) {
                this.tempActions.dispose();
                this.tempActions = null;
            }
            if (this.actionPresentationManager != null) {
                this.actionPresentationManager.dispose();
                this.actionPresentationManager = null;
            }
        }
    }

    private static final class ContentOutlineFilteredTree
    extends FilteredTree {
        private final MasterDetailsContentOutline contentTree;
        private WorkbenchJob refreshJob;

        public ContentOutlineFilteredTree(Composite parent, int treeStyle, MasterDetailsContentOutline contentTree) {
            super(parent, treeStyle, new PatternFilter(), true);
            this.contentTree = contentTree;
            this.setBackground(Display.getCurrent().getSystemColor(1));
        }

        protected WorkbenchJob doCreateRefreshJob() {
            final WorkbenchJob base = super.doCreateRefreshJob();
            this.refreshJob = new WorkbenchJob(base.getName()){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IStatus st = base.runInUIThread((IProgressMonitor)new NullProgressMonitor());
                    if (st.getSeverity() == 8) {
                        return st;
                    }
                    ContentOutlineFilteredTree.this.contentTree.setFilterText(ContentOutlineFilteredTree.this.getFilterString());
                    MasterDetailsEditorPage.updateExpandedState(ContentOutlineFilteredTree.this.contentTree, ContentOutlineFilteredTree.this.getViewer().getTree());
                    return org.eclipse.core.runtime.Status.OK_STATUS;
                }
            };
            return this.refreshJob;
        }

        public void changeFilterText(String filterText) {
            String currentFilterText = this.getFilterString();
            if (currentFilterText != null && !currentFilterText.equals(filterText)) {
                this.setFilterText(filterText);
                this.textChanged();
            }
        }
    }

    private static class DetailsSection
    extends SapphireRenderingContext
    implements IDetailsPage {
        private MasterDetailsContentNode node;
        protected IManagedForm mform;
        protected FormToolkit toolkit;

        public DetailsSection() {
            super((ISapphirePart)null, (Shell)null);
        }

        public SapphirePart getPart() {
            return this.node;
        }

        public void initialize(IManagedForm form) {
            this.mform = form;
            this.toolkit = this.mform.getToolkit();
        }

        public final void createContents(Composite parent) {
            this.composite = parent;
            this.shell = this.composite.getShell();
            TableWrapLayout twl = TableWrapLayoutUtil.twlayout(1, 10, 10, 10, 10);
            twl.verticalSpacing = 20;
            parent.setLayout((Layout)twl);
            this.createSections();
        }

        public void commit(boolean onSave) {
        }

        public void dispose() {
        }

        public boolean isDirty() {
            return false;
        }

        public boolean isStale() {
            return false;
        }

        public void refresh() {
        }

        public void setFocus() {
        }

        public boolean setFormInput(Object input) {
            return false;
        }

        public void adapt(Control control) {
            super.adapt(control);
            if (control instanceof Composite) {
                this.toolkit.adapt((Composite)control);
            } else if (control instanceof Label) {
                this.toolkit.adapt(control, false, false);
            } else {
                this.toolkit.adapt(control, true, true);
            }
        }

        public void selectionChanged(IFormPart part, ISelection selection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            this.node = ssel.size() == 1 ? (MasterDetailsContentNode)ssel.getFirstElement() : null;
            this.createSections();
        }

        protected void createSections() {
            Composite rootComposite = this.getComposite();
            Control[] controlArray = rootComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setVisible(false);
                control.dispose();
                ++n2;
            }
            if (this.node != null) {
                for (SapphireSection section : this.node.getSections()) {
                    if (!section.checkVisibleWhenCondition()) continue;
                    section.render(this);
                }
            }
            rootComposite.getParent().layout(true, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MasterSection
    extends Section {
        private IManagedForm managedForm;
        private SectionPart sectionPart;
        private TreeViewer treeViewer;
        private Tree tree;

        public MasterSection(IManagedForm managedForm, Composite parent) {
            super(parent, 256);
            FormToolkit toolkit = managedForm.getToolkit();
            FormColors colors = toolkit.getColors();
            this.setMenu(parent.getMenu());
            toolkit.adapt((Control)this, true, true);
            if (this.toggle != null) {
                this.toggle.setHoverDecorationColor(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER"));
                this.toggle.setDecorationColor(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
            }
            this.setFont(this.createBoldFont(colors.getDisplay(), this.getFont()));
            colors.initializeSectionToolBarColors();
            this.setTitleBarBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
            this.setTitleBarBorderColor(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
            this.setTitleBarForeground(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
            this.marginWidth = 10;
            this.marginHeight = 10;
            this.setLayoutData(GridLayoutUtil.gdfill());
            this.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
            this.setText(MasterDetailsEditorPage.this.definition.getOutlineHeaderText().getLocalizedText(CapitalizationType.TITLE_STYLE, false));
            Composite client = toolkit.createComposite((Composite)this);
            client.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
            this.managedForm = managedForm;
            MasterDetailsContentOutline contentTree = MasterDetailsEditorPage.this.getContentTree();
            FilteredTree filteredTree = MasterDetailsEditorPage.this.createContentOutline(client, contentTree, true);
            this.treeViewer = filteredTree.getViewer();
            this.tree = this.treeViewer.getTree();
            this.sectionPart = new SectionPart((Section)this);
            this.managedForm.addPart((IFormPart)this.sectionPart);
            contentTree.addListener(new MasterDetailsContentOutline.Listener(){

                @Override
                public void handleSelectionChange(List<MasterDetailsContentNode> selection) {
                    MasterSection.this.handleSelectionChangedEvent(selection);
                }
            });
            ToolBar toolbar = new ToolBar((Composite)this, 0x800100);
            this.setTextClient((Control)toolbar);
            MasterDetailsEditorPagePart part = MasterDetailsEditorPage.this.getPart();
            SapphireActionGroup actions = part.getActions("Sapphire.EditorPage.Outline.Header");
            SapphireToolBarActionPresentation actionsPresentation = new SapphireToolBarActionPresentation(part, MasterDetailsEditorPage.this.getSite().getShell(), actions);
            actionsPresentation.setToolBar(toolbar);
            actionsPresentation.render();
            toolkit.paintBordersFor((Composite)this);
            this.setClient((Control)client);
        }

        private Font createBoldFont(Display display, Font regularFont) {
            FontData[] fontDatas = regularFont.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setStyle(fontDatas[i].getStyle() | 1);
                ++i;
            }
            return new Font((Device)display, fontDatas);
        }

        private void handleSelectionChangedEvent(List<MasterDetailsContentNode> selection) {
            StructuredSelection sel = selection.isEmpty() ? StructuredSelection.EMPTY : new StructuredSelection((Object)selection.get(0));
            this.managedForm.fireSelectionChanged((IFormPart)this.sectionPart, (ISelection)sel);
        }
    }

    private static final class Resources
    extends NLS {
        public static String problemsOverflowMessage;
        public static String two;
        public static String three;
        public static String four;
        public static String five;
        public static String six;
        public static String seven;
        public static String eight;
        public static String nine;

        static {
            Resources.initializeMessages((String)MasterDetailsEditorPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private final class RootSection
    extends MasterDetailsBlock {
        private MasterSection masterSection;
        private List<IDetailsPage> detailsSections = new ArrayList<IDetailsPage>();
        private Control detailsSectionControl = null;

        public void createContent(IManagedForm managedForm) {
            super.createContent(managedForm);
            this.setOutlineRatio(MasterDetailsEditorPage.this.getOutlineRatio());
            try {
                Field field = this.detailsPart.getClass().getDeclaredField("pageBook");
                field.setAccessible(true);
                this.detailsSectionControl = (Control)field.get(this.detailsPart);
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
            this.masterSection.handleSelectionChangedEvent(MasterDetailsEditorPage.this.getContentTree().getSelectedNodes());
            this.setDetailsMaximized(MasterDetailsEditorPage.this.isDetailsMaximized());
        }

        protected void createMasterPart(IManagedForm managedForm, Composite parent) {
            this.masterSection = new MasterSection(managedForm, parent);
            SectionPart spart = new SectionPart((Section)this.masterSection);
            managedForm.addPart((IFormPart)spart);
        }

        protected void registerPages(DetailsPart detailsPart) {
            DetailsSection detailsPage = new DetailsSection();
            detailsPart.registerPage(MasterDetailsContentNode.class, (IDetailsPage)detailsPage);
            this.detailsSections.add(detailsPage);
        }

        protected void applyLayoutData(SashForm sashForm) {
            sashForm.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhhint(GridLayoutUtil.gdfill(), 200), 400));
        }

        public IDetailsPage getCurrentDetailsSection() {
            return this.detailsPart.getCurrentPage();
        }

        public void setDetailsMaximized(boolean maximized) {
            this.sashForm.setMaximizedControl(maximized ? this.detailsSectionControl : null);
        }

        public double getOutlineRatio() {
            Control[] children = this.sashForm.getChildren();
            int outline = children[0].getSize().x;
            int details = children[1].getSize().x;
            int total = outline + details;
            double ratio = (double)outline / (double)total;
            return ratio;
        }

        public void setOutlineRatio(double ratio) {
            int outline = (int)(2.147483647E9 * ratio);
            int details = Integer.MAX_VALUE - outline;
            this.sashForm.setWeights(new int[]{outline, details});
        }

        public void dispose() {
            if (this.masterSection != null) {
                this.masterSection.dispose();
            }
            for (IDetailsPage section : this.detailsSections) {
                section.dispose();
            }
        }

        protected void createToolBarActions(IManagedForm managedForm) {
        }
    }
}

