/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer;

import java.util.List;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.SapphireActionType;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireHotSpotsActionPresentation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class SapphireMenuActionPresentation
extends SapphireHotSpotsActionPresentation {
    private Menu menu;

    public SapphireMenuActionPresentation(SapphireActionPresentationManager manager) {
        super(manager);
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    public void render() {
        final SapphireRenderingContext context = this.getManager().getContext();
        boolean first = true;
        String lastGroup = null;
        for (final SapphireAction action : this.getActions()) {
            MenuItem menuItem;
            String group = action.getGroup();
            if (!first && !MiscUtil.equal(lastGroup, (Object)group)) {
                new MenuItem(this.menu, 2);
            }
            first = false;
            lastGroup = group;
            final List<SapphireActionHandler> handlers = action.getActiveHandlers();
            if (action.getType() == SapphireActionType.PUSH) {
                if (handlers.size() == 1) {
                    menuItem = new MenuItem(this.menu, 8);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            ((SapphireActionHandler)handlers.get(0)).execute(context);
                        }
                    });
                } else {
                    Menu childMenu = new Menu(this.menu);
                    menuItem = new MenuItem(this.menu, 64);
                    menuItem.setMenu(childMenu);
                    for (SapphireActionHandler handler : action.getActiveHandlers()) {
                        this.renderMenuItem(childMenu, handler);
                    }
                }
            } else if (action.getType() == SapphireActionType.TOGGLE) {
                menuItem = new MenuItem(this.menu, 32);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        ((SapphireActionHandler)handlers.get(0)).execute(context);
                    }
                });
            } else {
                throw new IllegalStateException();
            }
            final Runnable updateActionLabelOp = new Runnable(){

                public void run() {
                    if (!menuItem.isDisposed()) {
                        menuItem.setText(LabelTransformer.transform((String)action.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false));
                    }
                }
            };
            Runnable updateActionImageOp = new Runnable(){

                public void run() {
                    if (!menuItem.isDisposed()) {
                        menuItem.setImage(context.getImageCache().getImage(action.getImage(16)));
                    }
                }
            };
            final Runnable updateActionEnablementStateOp = new Runnable(){

                public void run() {
                    if (!menuItem.isDisposed()) {
                        menuItem.setEnabled(action.isEnabled());
                    }
                }
            };
            final Runnable updateActionCheckedStateOp = new Runnable(){

                public void run() {
                    if (!menuItem.isDisposed()) {
                        menuItem.setSelection(action.isChecked());
                    }
                }
            };
            action.addListener(new SapphireActionSystemPart.Listener(){

                public void handleEvent(SapphireActionSystemPart.Event event) {
                    String type = event.getType();
                    if (type.equals("label")) {
                        updateActionLabelOp.run();
                    } else if (type.equals("image")) {
                        updateActionLabelOp.run();
                    } else if (type.equals("enablement")) {
                        updateActionEnablementStateOp.run();
                    } else if (type.equals("checked")) {
                        updateActionCheckedStateOp.run();
                    }
                }
            });
            updateActionLabelOp.run();
            updateActionImageOp.run();
            updateActionEnablementStateOp.run();
            updateActionCheckedStateOp.run();
        }
    }
}

