/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.t0008.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueNormalizationService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.tests.modeling.el.t0008.ITestModelElement;
import org.eclipse.sapphire.tests.modeling.el.t0008.ITestModelRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestModelRoot
extends ModelElement
implements ITestModelRoot {
    private ModelElementHandle<ITestModelElement> element;
    private Value<Integer> integer;

    public TestModelRoot(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public TestModelRoot(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<ITestModelElement> getElement() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.element == null) {
                this.refresh((ModelProperty)PROP_ELEMENT, true);
            }
            return this.element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Integer> getInteger() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.integer == null) {
                this.refresh((ModelProperty)PROP_INTEGER, true);
            }
            return this.integer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInteger(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_INTEGER.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_INTEGER, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_INTEGER, true);
            if (!TestModelRoot.equal((String)this.integer.getText(false), (String)value)) {
                this.resource().binding(PROP_INTEGER).write(value);
                this.refresh((ModelProperty)PROP_INTEGER, false);
            }
        }
    }

    @Override
    public void setInteger(Integer value) {
        this.setInteger(value != null ? ((ValueSerializationService)this.service((ModelProperty)PROP_INTEGER, ValueSerializationService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ELEMENT) {
                if (this.element == null) {
                    if (force) {
                        this.element = new ModelElementHandle((IModelElement)this, PROP_ELEMENT);
                        this.element.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_ELEMENT);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ELEMENT);
                    boolean notified = this.element.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ELEMENT, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_INTEGER && (this.integer != null || force)) {
                Value<Integer> oldValue = this.integer;
                String val = this.resource().binding(PROP_INTEGER).read();
                this.integer = new Value((IModelElement)this, PROP_INTEGER, ((ValueNormalizationService)this.service((ModelProperty)PROP_INTEGER, ValueNormalizationService.class)).normalize(PROP_INTEGER.encodeKeywords(val)));
                this.integer.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_INTEGER);
                if (oldValue != null) {
                    if (this.integer.equals(oldValue)) {
                        this.integer = oldValue;
                    }
                    if (this.integer != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_INTEGER, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_ELEMENT) {
            return this.getElement();
        }
        if (property == PROP_INTEGER) {
            return this.getInteger();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_INTEGER) {
            if (!(value instanceof String)) {
                this.setInteger((Integer)value);
            } else {
                this.setInteger((String)value);
            }
            return;
        }
        super.write(property, value);
    }
}

