/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.misc.t0011;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.misc.t0011.TestElementChild;
import org.eclipse.sapphire.tests.modeling.misc.t0011.TestElementRoot;

public final class TestModelingMisc0011
extends SapphireTestCase {
    private TestModelingMisc0011(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestModelingMisc0011");
        suite.addTest((Test)new TestModelingMisc0011("testFromEmptyModel"));
        suite.addTest((Test)new TestModelingMisc0011("testFromExistingModel"));
        return suite;
    }

    public void testFromEmptyModel() throws Exception {
        TestElementRoot root = (TestElementRoot)TestElementRoot.TYPE.instantiate();
        TestElementChild x = (TestElementChild)root.getChildren().addNewElement();
        x.setId("x");
        x.setContent("123");
        TestElementChild y = (TestElementChild)root.getChildren().addNewElement();
        y.setId("y");
        y.setReference("x");
        TestElementChild z = (TestElementChild)root.getChildren().addNewElement();
        z.setId("z");
        z.setReference("y");
        TestModelingMisc0011.assertEquals((String)y.getContent().getText(), (String)"123");
        TestModelingMisc0011.assertEquals((String)z.getContent().getText(), (String)"123");
        x.setContent("456");
        TestModelingMisc0011.assertEquals((String)y.getContent().getText(), (String)"456");
        TestModelingMisc0011.assertEquals((String)z.getContent().getText(), (String)"456");
    }

    public void testFromExistingModel() throws Exception {
        RootXmlResource rootXmlResource = new RootXmlResource(new XmlResourceStore(this.loadResource("TestData.xml")));
        TestElementRoot root = (TestElementRoot)TestElementRoot.TYPE.instantiate((Resource)rootXmlResource);
        TestElementChild x = (TestElementChild)root.getChildren().get(0);
        TestElementChild y = (TestElementChild)root.getChildren().get(1);
        TestElementChild z = (TestElementChild)root.getChildren().get(2);
        TestModelingMisc0011.assertEquals((String)y.getContent().getText(), (String)"123");
        TestModelingMisc0011.assertEquals((String)z.getContent().getText(), (String)"123");
        x.setContent("456");
        TestModelingMisc0011.assertEquals((String)y.getContent().getText(), (String)"456");
        TestModelingMisc0011.assertEquals((String)z.getContent().getText(), (String)"456");
    }
}

