/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ImageService;
import org.eclipse.sapphire.modeling.ModelElementService;
import org.eclipse.sapphire.modeling.ModelElementServiceFactory;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.annotations.Image;

public final class StaticImageService
extends ImageService {
    private ImageData image;

    public void init(IModelElement element, String[] params) {
        super.init(element, params);
        ModelElementType type = element.getModelElementType();
        Image imageAnnotation = type.getAnnotation(Image.class);
        this.image = ImageData.createFromClassLoader(type.getAnnotationHostClass(imageAnnotation), imageAnnotation.path());
    }

    public ImageData provide() {
        return this.image;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelElementServiceFactory {
        @Override
        public boolean applicable(IModelElement element, Class<? extends ModelElementService> service) {
            return element.getModelElementType().getAnnotation(Image.class) != null;
        }

        @Override
        public ModelElementService create(IModelElement element, Class<? extends ModelElementService> service) {
            return new StaticImageService();
        }
    }
}

