/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.serialization.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.modeling.serialization.ValueSerialization;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueSerializationServiceFactory
extends ModelPropertyServiceFactory {
    private static final ValueSerializationService DEFAULT_SERIALIZER = new ValueSerializationService(){

        protected Object decodeFromString(String value) {
            return value;
        }
    };

    @Override
    public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        return property instanceof ValueProperty;
    }

    @Override
    public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        Class<?> type = property.getTypeClass();
        ValueSerializationService serializer = null;
        if (type != String.class) {
            ValueSerialization valueSerializerAnnotation = property.getAnnotation(ValueSerialization.class);
            if (valueSerializerAnnotation != null) {
                try {
                    serializer = valueSerializerAnnotation.service().newInstance();
                    serializer.init(element, property, valueSerializerAnnotation.params());
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
            if (serializer == null) {
                serializer = SapphireModelingExtensionSystem.createValueSerializer(element, (ValueProperty)property, type);
                if (serializer != null) {
                    try {
                        serializer.init(element, property, new String[0]);
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                        serializer = null;
                    }
                } else {
                    String message = NLS.bind(Resources.noSerializer, element.getModelElementType().getModelElementClass().getName(), property.getName(), type.getName());
                    LoggingService.log(Status.createErrorStatus(message));
                }
            }
        }
        if (serializer == null) {
            serializer = DEFAULT_SERIALIZER;
        }
        final ValueSerializationService finalSerializer = serializer;
        ValueSerializationService wrapper = new ValueSerializationService(){

            public String encode(Object value) {
                return finalSerializer.encode(value);
            }

            protected Object decodeFromString(String value) {
                return finalSerializer.decode(value);
            }
        };
        return wrapper;
    }

    private static final class Resources
    extends NLS {
        public static String noSerializer;

        static {
            Resources.initializeMessages(ValueSerializationServiceFactory.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

