/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validation;

import java.util.Arrays;
import java.util.List;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathValidation {
    @Deprecated
    public static final Status validateExtensions(String fileName, String[] validFileExtensions) {
        return PathValidation.validateExtensions(fileName, Arrays.asList(validFileExtensions));
    }

    public static final Status validateExtensions(String fileName, List<String> validFileExtensions) {
        int count;
        int n = count = validFileExtensions == null ? 0 : validFileExtensions.size();
        if (count > 0) {
            String trimmedFileName = fileName.trim();
            int lastdot = trimmedFileName.lastIndexOf(46);
            String extension = lastdot == -1 ? "" : trimmedFileName.substring(lastdot + 1);
            boolean match = false;
            if (extension != null && extension.length() != 0) {
                for (String ext : validFileExtensions) {
                    if (!extension.equalsIgnoreCase(ext)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                String message;
                if (count == 1) {
                    message = NLS.bind(Resources.invalidFileExtensionOne, trimmedFileName, validFileExtensions.get(0));
                } else if (count == 2) {
                    message = NLS.bind(Resources.invalidFileExtensionTwo, trimmedFileName, validFileExtensions.get(0), validFileExtensions.get(1));
                } else {
                    StringBuilder buf = new StringBuilder();
                    for (String ext : validFileExtensions) {
                        if (buf.length() != 0) {
                            buf.append(", ");
                        }
                        buf.append(ext);
                    }
                    message = NLS.bind(Resources.invalidFileExtensionMultiple, trimmedFileName, buf.toString());
                }
                return Status.createErrorStatus(message);
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String invalidFileExtensionOne;
        public static String invalidFileExtensionTwo;
        public static String invalidFileExtensionMultiple;

        static {
            Resources.initializeMessages(PathValidation.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

