/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FileExtensions;
import org.eclipse.sapphire.modeling.annotations.ValidFileExtensions;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.FileExtensionsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeclarativeFileExtensionsService
extends FileExtensionsService {
    private FunctionResult functionResult;

    @Override
    public void initFileExtensionsService(IModelElement element, ModelProperty property, String[] params) {
        FileExtensions fileExtensionsAnnotation = property.getAnnotation(FileExtensions.class);
        if (fileExtensionsAnnotation != null) {
            Function function = null;
            try {
                function = ExpressionLanguageParser.parse(fileExtensionsAnnotation.expr());
            }
            catch (Exception e) {
                LoggingService.log(e);
                function = null;
            }
            if (function != null) {
                function = FailSafeFunction.create(function, Literal.create(List.class), Literal.create(Collections.emptyList()));
                this.functionResult = function.evaluate(new ModelElementFunctionContext(element));
                this.functionResult.addListener(new FunctionResult.Listener(){

                    public void handleValueChanged() {
                        DeclarativeFileExtensionsService.this.refresh();
                    }
                });
            }
        } else {
            ValidFileExtensions validFileExtensionsAnnotation = property.getAnnotation(ValidFileExtensions.class);
            if (validFileExtensionsAnnotation != null) {
                ArrayList<String> extensions = new ArrayList<String>();
                String[] stringArray = validFileExtensionsAnnotation.value();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    if ((extension = extension.trim()).length() > 0) {
                        extensions.add(extension);
                    }
                    ++n2;
                }
                this.functionResult = Literal.create(extensions).evaluate(new ModelElementFunctionContext(element));
            }
        }
    }

    @Override
    protected void compute(List<String> extensions) {
        if (this.functionResult != null) {
            for (Object extension : (List)this.functionResult.value()) {
                extensions.add((String)extension);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.functionResult != null) {
            try {
                this.functionResult.dispose();
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return property instanceof ValueProperty && (property.hasAnnotation(FileExtensions.class) || property.hasAnnotation(ValidFileExtensions.class));
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return new DeclarativeFileExtensionsService();
        }
    }
}

