/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphirePageBook;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireWithDirectiveHelper;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.def.ISapphireCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphireLabelDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.ISapphireWithDirectiveDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.binding.RadioButtonsGroup;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireKeyboardActionPresentation;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireWithDirective
extends SapphirePageBook {
    private ModelPath path;
    private IModelElement element;
    private ElementProperty property;
    private IModelElement elementForChildParts;
    private ModelPropertyListener listener;

    @Override
    protected void init() {
        ISapphireWithDirectiveDef def = (ISapphireWithDirectiveDef)this.definition;
        SapphireWithDirectiveHelper.ResolvePathResult resolvePathResult = SapphireWithDirectiveHelper.resolvePath(this.getModelElement(), def, this.params);
        if (resolvePathResult.property == null) {
            throw new IllegalStateException();
        }
        this.path = resolvePathResult.path;
        this.element = resolvePathResult.element;
        this.property = resolvePathResult.property;
        super.init();
        this.setExposePageValidationState(true);
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                SapphireWithDirective.this.updateCurrentPage(false);
            }
        };
        this.element.addListener(this.listener, this.property.getName());
        this.updateCurrentPage(true);
    }

    @Override
    protected ISapphireCompositeDef initDefaultPageDef() {
        ISapphireUiDef root = (ISapphireUiDef)ISapphireUiDef.TYPE.instantiate();
        ISapphireCompositeDef composite = (ISapphireCompositeDef)root.getPartDefs().addNewElement(ISapphireCompositeDef.TYPE);
        ISapphireLabelDef label = (ISapphireLabelDef)composite.getContent().addNewElement(ISapphireLabelDef.TYPE);
        label.setText(Resources.noAdditionalPropertiesMessage);
        return composite;
    }

    public ModelPath getPath() {
        return this.path;
    }

    @Override
    public IModelElement getLocalModelElement() {
        return this.element;
    }

    public ElementProperty getProperty() {
        return this.property;
    }

    @Override
    public void render(final SapphireRenderingContext context) {
        ISapphireWithDirectiveDef def = (ISapphireWithDirectiveDef)this.definition;
        Composite composite = new Composite(context.getComposite(), 0);
        composite.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2));
        composite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        context.adapt((Control)composite);
        if (this.property != null) {
            ModelPropertyListener modelPropertyListener;
            List allPossibleTypes = this.property.getAllPossibleTypes();
            int allPossibleTypesCount = allPossibleTypes.size();
            final IModelElement element = this.element;
            final ElementProperty property = this.property;
            Style defaultStyle = allPossibleTypesCount == 1 ? Style.CHECKBOX : (allPossibleTypesCount <= 3 ? Style.RADIO_BUTTONS : Style.DROP_DOWN_LIST);
            Style style = Style.decode(def.getHint("style"));
            if (style == null || style == Style.CHECKBOX && allPossibleTypesCount != 1) {
                style = defaultStyle;
            }
            SapphireActionGroup actions = this.getActions(this.getMainActionContext());
            final SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager(context, actions);
            final SapphireKeyboardActionPresentation actionPresentationKeyboard = new SapphireKeyboardActionPresentation(actionPresentationManager);
            Composite typeSelectorComposite = new Composite(composite, 0);
            typeSelectorComposite.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 0x1000000), 2));
            typeSelectorComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
            context.adapt((Control)typeSelectorComposite);
            PropertyEditorAssistDecorator decorator = new PropertyEditorAssistDecorator(this, this.element, (ModelProperty)this.property, context, typeSelectorComposite);
            decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), style == Style.DROP_DOWN_LIST ? 128 : 0x1000000));
            if (style == Style.CHECKBOX) {
                final Button masterCheckBox = new Button(typeSelectorComposite, 32);
                masterCheckBox.setLayoutData((Object)GridLayoutUtil.gd());
                masterCheckBox.setText(LabelTransformer.transform((String)def.getLabel().getLocalizedText(), (CapitalizationType)CapitalizationType.FIRST_WORD_ONLY, (boolean)true));
                context.adapt((Control)masterCheckBox);
                decorator.addEditorControl((Control)masterCheckBox);
                actionPresentationKeyboard.attach((Control)masterCheckBox);
                modelPropertyListener = new ModelPropertyListener(){

                    public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                        IModelElement subModelElement = element.read(property).element();
                        masterCheckBox.setSelection(subModelElement != null);
                        masterCheckBox.setEnabled(element.isPropertyEnabled((ModelProperty)property));
                        if (subModelElement != null) {
                            context.setHelp((Control)masterCheckBox, subModelElement, (ModelProperty)property);
                        }
                    }
                };
                masterCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        block4: {
                            try {
                                ModelElementHandle handle = element.read(property);
                                if (masterCheckBox.getSelection()) {
                                    handle.element(true);
                                } else {
                                    handle.remove();
                                }
                            }
                            catch (Exception e) {
                                EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                                if (editFailedException != null) break block4;
                                SapphireUiFrameworkPlugin.log(e);
                            }
                        }
                    }
                });
            } else if (style == Style.RADIO_BUTTONS) {
                final RadioButtonsGroup radioButtonsGroup = new RadioButtonsGroup(context, typeSelectorComposite, false);
                radioButtonsGroup.setLayoutData(GridLayoutUtil.gdhfill());
                context.adapt((Control)radioButtonsGroup);
                final Button noneButton = radioButtonsGroup.addRadioButton(Resources.noneSelection);
                decorator.addEditorControl((Control)noneButton);
                actionPresentationKeyboard.attach((Control)noneButton);
                final HashMap<ModelElementType, Button> typeToButton = new HashMap<ModelElementType, Button>();
                final HashMap<Button, ModelElementType> buttonToType = new HashMap<Button, ModelElementType>();
                for (ModelElementType type : allPossibleTypes) {
                    String label = type.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
                    Button button = radioButtonsGroup.addRadioButton(label);
                    typeToButton.put(type, button);
                    buttonToType.put(button, type);
                    decorator.addEditorControl((Control)button);
                    actionPresentationKeyboard.attach((Control)button);
                }
                modelPropertyListener = new ModelPropertyListener(){

                    public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                        IModelElement subModelElement = element.read(property).element();
                        Button button = subModelElement == null ? noneButton : (Button)typeToButton.get(subModelElement.getModelElementType());
                        if (radioButtonsGroup.getSelection() != button) {
                            radioButtonsGroup.setSelection(button);
                        }
                        radioButtonsGroup.setEnabled(element.isPropertyEnabled((ModelProperty)property));
                    }
                };
                radioButtonsGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        block4: {
                            try {
                                ModelElementHandle handle = element.read(property);
                                Button button = radioButtonsGroup.getSelection();
                                if (button == noneButton) {
                                    handle.remove();
                                } else {
                                    ModelElementType type = (ModelElementType)buttonToType.get(button);
                                    handle.element(true, type);
                                }
                            }
                            catch (Exception e) {
                                EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                                if (editFailedException != null) break block4;
                                SapphireUiFrameworkPlugin.log(e);
                            }
                        }
                    }
                });
            } else if (style == Style.DROP_DOWN_LIST) {
                final Combo combo = new Combo(typeSelectorComposite, 2060);
                combo.setLayoutData((Object)GridLayoutUtil.gdhfill());
                context.adapt((Control)combo);
                decorator.addEditorControl((Control)combo);
                actionPresentationKeyboard.attach((Control)combo);
                combo.add(Resources.noneSelection);
                final HashMap<ModelElementType, Integer> typeToIndex = new HashMap<ModelElementType, Integer>();
                final HashMap<Integer, ModelElementType> indexToType = new HashMap<Integer, ModelElementType>();
                int index = 1;
                for (ModelElementType type : allPossibleTypes) {
                    String label = type.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
                    combo.add(label);
                    typeToIndex.put(type, index);
                    indexToType.put(index, type);
                    ++index;
                }
                modelPropertyListener = new ModelPropertyListener(){

                    public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                        IModelElement subModelElement = element.read(property).element();
                        int index = subModelElement == null ? 0 : (Integer)typeToIndex.get(subModelElement.getModelElementType());
                        if (combo.getSelectionIndex() != index) {
                            combo.select(index);
                        }
                        combo.setEnabled(element.isPropertyEnabled((ModelProperty)property));
                    }
                };
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        block4: {
                            try {
                                ModelElementHandle handle = element.read(property);
                                int index = combo.getSelectionIndex();
                                if (index == 0) {
                                    handle.remove();
                                } else {
                                    ModelElementType type = (ModelElementType)indexToType.get(index);
                                    handle.element(true, type);
                                }
                            }
                            catch (Exception e) {
                                EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                                if (editFailedException != null) break block4;
                                SapphireUiFrameworkPlugin.log(e);
                            }
                        }
                    }
                });
            } else {
                throw new IllegalStateException();
            }
            actionPresentationKeyboard.render();
            Composite separatorComposite = new Composite(composite, 0);
            separatorComposite.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2), 9));
            separatorComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 5));
            context.adapt((Control)separatorComposite);
            Label separator = new Label(separatorComposite, 258);
            separator.setLayoutData((Object)GridLayoutUtil.gdhfill());
            modelPropertyListener.handlePropertyChangedEvent(null);
            element.addListener(modelPropertyListener, property.getName());
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    element.removeListener(modelPropertyListener, property.getName());
                    actionPresentationManager.dispose();
                    actionPresentationKeyboard.dispose();
                }
            });
        }
        super.render(new SapphireRenderingContext(this, context, composite));
    }

    @Override
    protected Object parsePageKey(String pageKeyString) {
        ISapphireUiDef rootdef = (ISapphireUiDef)this.definition.nearest(ISapphireUiDef.class);
        Class<?> cl = rootdef.resolveClass(pageKeyString);
        return SapphirePageBook.ClassBasedKey.create(cl);
    }

    @Override
    protected Status computeValidationState() {
        Status state = super.computeValidationState();
        if (this.property != null) {
            Status.CompositeStatusFactory factory = Status.factoryForComposite();
            factory.merge(this.element.read(this.property).validate(false));
            factory.merge(state);
            state = factory.create();
        }
        return state;
    }

    private void updateCurrentPage(boolean force) {
        IModelElement child = this.element.read(this.property).element();
        if (force || this.elementForChildParts != child) {
            this.elementForChildParts = child;
            if (this.elementForChildParts == null) {
                this.changePage(this.element, null);
            } else {
                this.changePage(this.elementForChildParts, SapphirePageBook.ClassBasedKey.create(this.elementForChildParts));
            }
        }
    }

    @Override
    public boolean setFocus(ModelPath path) {
        if (this.path.isPrefixOf(path)) {
            ModelPath tail = path.makeRelativeTo(this.path);
            if (this.property == null || this.element.isPropertyEnabled((ModelProperty)this.property) && this.element.read(this.property) != null) {
                return super.setFocus(tail);
            }
        }
        return false;
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.WithDirective");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.element.removeListener(this.listener, this.property.getName());
        }
    }

    private static final class Resources
    extends NLS {
        public static String noneSelection;
        public static String noAdditionalPropertiesMessage;

        static {
            Resources.initializeMessages((String)SapphireWithDirective.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Style {
        CHECKBOX("checkbox"),
        RADIO_BUTTONS("radio.buttons"),
        DROP_DOWN_LIST("drop.down.list");

        private final String text;

        public static Style decode(String text) {
            if (text != null) {
                Style[] styleArray = Style.values();
                int n = styleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Style style = styleArray[n2];
                    if (style.text.equals(text)) {
                        return style;
                    }
                    ++n2;
                }
            }
            return null;
        }

        private Style(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

