/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SourceEditorService;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;

public final class OutlineNodeShowInSourceActionHandler
extends SapphireActionHandler {
    private IModelElement element;
    private ModelPropertyListener listener;

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        super.init(action, def);
        this.element = ((MasterDetailsContentNode)this.getPart()).getLocalModelElement();
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                OutlineNodeShowInSourceActionHandler.this.refreshEnablementState();
            }
        };
        this.element.addListener(this.listener, ModelPath.ALL_DESCENDENTS);
        this.refreshEnablementState();
    }

    private void refreshEnablementState() {
        MasterDetailsContentNode node = (MasterDetailsContentNode)this.getPart();
        IModelElement element = node.getLocalModelElement();
        Resource resource = element.resource();
        this.setEnabled(resource instanceof XmlResource && ((XmlResource)resource).getXmlElement() != null);
    }

    protected Object run(SapphireRenderingContext context) {
        MasterDetailsContentNode node = (MasterDetailsContentNode)this.getPart();
        IModelElement element = node.getLocalModelElement();
        ((SourceEditorService)element.adapt(SourceEditorService.class)).show(element, null);
        return null;
    }

    public void dispose() {
        super.dispose();
        this.element.removeListener(this.listener, ModelPath.ALL_DESCENDENTS);
    }
}

