/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.AuxTextProvider;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.binding.AbstractBinding;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public abstract class PropertyEditorRenderer {
    private static final String RELATED_CONTENT_WIDTH = "sapphire.related.content.width";
    protected final SapphireRenderingContext context;
    private final SapphirePropertyEditor part;
    protected PropertyEditorAssistDecorator decorator;
    private Label auxTextControl;
    private AuxTextProvider auxTextProvider;
    private final Set<Control> controls;
    private boolean spanBothColumns;
    protected AbstractBinding binding;
    private final SapphireActionGroup actions;
    private final SapphireActionPresentationManager actionPresentationManager;
    private final SapphireKeyboardActionPresentation actionPresentationKeyboard;
    private final List<Runnable> onDisposeOperations = new ArrayList<Runnable>();

    public PropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        this.context = context;
        this.part = part;
        this.controls = new HashSet<Control>();
        this.spanBothColumns = false;
        this.actions = part.getActions(part.getActionContext());
        this.actionPresentationManager = new SapphireActionPresentationManager(this.context, this.actions);
        this.actionPresentationManager.setLabel(NLS.bind((String)Resources.actionsContextLabel, (Object)this.part.getProperty().getLabel(true, CapitalizationType.NO_CAPS, false)));
        this.actionPresentationKeyboard = new SapphireKeyboardActionPresentation(this.actionPresentationManager);
    }

    public SapphireRenderingContext getUiContext() {
        return this.context;
    }

    public SapphirePropertyEditor getPart() {
        return this.part;
    }

    public IModelElement getModelElement() {
        return this.part.getLocalModelElement();
    }

    public ModelProperty getProperty() {
        return this.part.getProperty();
    }

    public SapphireImageCache getImageCache() {
        return this.part.getImageCache();
    }

    public final SapphireActionGroup getActions() {
        return this.actions;
    }

    public final SapphireActionPresentationManager getActionPresentationManager() {
        return this.actionPresentationManager;
    }

    protected boolean canExpandVertically() {
        return false;
    }

    protected final boolean getSpanBothColumns() {
        return this.spanBothColumns;
    }

    protected final void setSpanBothColumns(boolean spanBothColumns) {
        this.spanBothColumns = spanBothColumns;
    }

    public final void create(Composite parent) {
        this.createContents(parent);
        String auxText = this.part.getRenderingHint("aux.text", null);
        Class auxTextProviderClass = this.part.getRenderingHint("aux.text.provider", null);
        if (auxTextProviderClass != null) {
            try {
                this.auxTextProvider = (AuxTextProvider)auxTextProviderClass.newInstance();
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
        if (auxText != null || this.auxTextProvider != null) {
            if (!this.spanBothColumns) {
                Label placeholder = new Label(parent, 0);
                placeholder.setLayoutData((Object)GridLayoutUtil.gd());
                placeholder.setText("");
                this.context.adapt((Control)placeholder);
            }
            int hindent = this.part.getLeftMarginHint() + 9;
            this.auxTextControl = new Label(parent, 64);
            this.auxTextControl.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), this.spanBothColumns ? 2 : 1), hindent), 10));
            this.auxTextControl.setForeground(parent.getDisplay().getSystemColor(16));
            SwtUtil.reflowOnResize((Control)this.auxTextControl);
            this.addControl((Control)this.auxTextControl);
            if (auxText != null) {
                this.auxTextControl.setText(auxText);
            }
        }
        final SapphirePropertyEditor part = this.getPart();
        final IModelElement modelElement = this.getModelElement();
        final ModelProperty property = this.getProperty();
        final ModelPropertyListener propertyChangeListener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PropertyEditorRenderer.this.handlePropertyChangedEvent();
                    }
                });
            }
        };
        modelElement.addListener(propertyChangeListener, property.getName());
        this.handlePropertyChangedEvent();
        final SapphirePartListener partListener = new SapphirePartListener(){

            public void handleFocusReceivedEvent(SapphirePartEvent event) {
                PropertyEditorRenderer.this.handleFocusReceivedEvent();
            }
        };
        part.addListener(partListener);
        this.actionPresentationKeyboard.render();
        this.addOnDisposeOperation(new Runnable(){

            public void run() {
                part.removeListener(partListener);
                modelElement.removeListener(propertyChangeListener, property.getName());
            }
        });
    }

    protected abstract void createContents(Composite var1);

    protected final Composite createMainComposite(Composite parent) {
        GridData gd;
        List<SapphirePart> relatedContentParts = this.part.getRelatedContent();
        int count = relatedContentParts.size();
        if (this.canExpandVertically()) {
            boolean expandVertically = this.part.getRenderingHint("expand.vertically", false);
            int heightHint = this.part.getRenderingHint("height", 10) * 15;
            gd = GridLayoutUtil.gdhhint(expandVertically ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), heightHint);
        } else {
            gd = GridLayoutUtil.gdhfill();
        }
        if (this.spanBothColumns) {
            gd = GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(gd, 2), this.part.getLeftMarginHint());
        }
        gd = GridLayoutUtil.gdwhint(gd, 200);
        final Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)gd);
        this.context.adapt((Control)composite);
        if (count == 0) {
            return composite;
        }
        composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(3, 0, 0), 0));
        boolean vcenter = this.part.isSingleLinePart() && relatedContentParts.size() == 1 && relatedContentParts.get(0).isSingleLinePart();
        Composite mainPropertyEditorOuterComposite = new Composite(composite, 0);
        mainPropertyEditorOuterComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 4, 0, 0));
        mainPropertyEditorOuterComposite.setLayoutData((Object)(vcenter ? GridLayoutUtil.gdhfill() : GridLayoutUtil.gdfill()));
        final Composite mainPropertyEditorComposite = new Composite(mainPropertyEditorOuterComposite, 0);
        mainPropertyEditorComposite.setLayoutData((Object)(vcenter ? GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 2) : GridLayoutUtil.gdfill()));
        final Sash sash = new Sash(composite, 512);
        sash.setLayoutData((Object)GridLayoutUtil.gdhhint(GridLayoutUtil.gdvfill(), 1));
        final Composite relatedContentComposite = new Composite(composite, 0);
        relatedContentComposite.setLayoutData((Object)(vcenter ? GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 2) : GridLayoutUtil.gdfill()));
        relatedContentComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        relatedContentComposite.setData(RELATED_CONTENT_WIDTH, (Object)((double)this.part.getRelatedContentWidth() / 100.0));
        composite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                PropertyEditorRenderer.refreshSashFormLayout(composite, mainPropertyEditorComposite, relatedContentComposite, sash);
            }
        });
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int width = composite.getClientArea().width - sash.getBounds().width;
                double ratio = (double)(width - event.x) / (double)width;
                if (ratio < 0.2) {
                    ratio = 0.2;
                }
                if (ratio > 0.8) {
                    ratio = 0.8;
                }
                relatedContentComposite.setData(PropertyEditorRenderer.RELATED_CONTENT_WIDTH, (Object)ratio);
                PropertyEditorRenderer.refreshSashFormLayout(composite, mainPropertyEditorComposite, relatedContentComposite, sash);
            }
        });
        this.context.adapt((Control)composite);
        for (SapphirePart relatedContentPart : relatedContentParts) {
            relatedContentPart.render(new SapphireRenderingContext(relatedContentPart, this.context, relatedContentComposite));
        }
        return mainPropertyEditorComposite;
    }

    private static final void refreshSashFormLayout(Composite rootComposite, Composite mainPropertyEditorComposite, Composite relatedContentComposite, Sash sash) {
        int mainPropertyEditorCompositeWidth;
        int rootCompositeWidth = rootComposite.getClientArea().width - sash.getBounds().width;
        double relatedContentCompositeWidthRatio = (Double)relatedContentComposite.getData(RELATED_CONTENT_WIDTH);
        int relatedContentCompositeWidth = (int)((double)rootCompositeWidth * relatedContentCompositeWidthRatio);
        ((GridData)mainPropertyEditorComposite.getLayoutData()).widthHint = mainPropertyEditorCompositeWidth = rootCompositeWidth - relatedContentCompositeWidth;
        ((GridData)relatedContentComposite.getLayoutData()).widthHint = relatedContentCompositeWidth;
        rootComposite.layout(true, true);
    }

    protected final PropertyEditorAssistDecorator createDecorator(Composite parent) {
        this.decorator = new PropertyEditorAssistDecorator(this.part, this.context, parent);
        return this.decorator;
    }

    protected final void addControl(final Control control) {
        IModelElement element = this.getModelElement();
        ModelProperty property = this.getProperty();
        this.controls.add(control);
        control.setEnabled(element.isPropertyEnabled(property));
        control.setData("property", (Object)property);
        control.setData("element", (Object)element);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                PropertyEditorRenderer.this.controls.remove(control);
                boolean timeToDispose = true;
                for (Control control2 : PropertyEditorRenderer.this.controls) {
                    if (control2.isDisposed()) continue;
                    timeToDispose = false;
                }
                if (timeToDispose) {
                    PropertyEditorRenderer.this.dispose();
                }
            }
        });
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.addControl(child);
                ++n2;
            }
        }
        this.actionPresentationKeyboard.attach(control);
        this.context.setHelp(control, element, property);
    }

    protected void handlePropertyChangedEvent() {
        boolean enabled = this.getModelElement().isPropertyEnabled(this.getProperty());
        for (Control control : this.controls) {
            if (control.isDisposed()) continue;
            control.setEnabled(enabled);
        }
        if (this.auxTextProvider != null) {
            String auxText = this.auxTextProvider.getAuxText(this.getModelElement(), this.getProperty());
            this.auxTextControl.setText("(" + auxText + ")");
        }
    }

    protected void handleFocusReceivedEvent() {
    }

    protected final void addOnDisposeOperation(Runnable op) {
        this.onDisposeOperations.add(op);
    }

    private final void dispose() {
        for (Runnable op : this.onDisposeOperations) {
            try {
                op.run();
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
        this.onDisposeOperations.clear();
    }

    private static final class Resources
    extends NLS {
        public static String actionsContextLabel;

        static {
            Resources.initializeMessages((String)PropertyEditorRenderer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

