/******************************************************************************
 * Copyright (c) 2011 Oracle
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Konstantin Komissarchik - initial implementation and ongoing maintenance
 ******************************************************************************/

package org.eclipse.sapphire.ui.def.internal;

import org.eclipse.sapphire.ui.def.IDefinitionReference;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;

/**
 * @author <a href="mailto:konstantin.komissarchik@oracle.com">Konstantin Komissarchik</a>
 */

public final class DefinitionReferenceMethods
{
    public static ISapphireUiDef resolve( final IDefinitionReference ref )
    {
        final ISapphireUiDef sdef = ref.nearest( ISapphireUiDef.class );
        final String path = ref.getPath().getText();
        
        if( path != null )
        {
            return SapphireUiDefFactory.load( sdef, path );
        }
        
        return null;
    }
    
}
