/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.xml.schema.XmlChoiceGroup;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinitionByReference;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlDocumentSchema {
    private String namespace;
    private String schemaLocation;
    private final Map<String, String> importedNamespaces;
    private final Map<String, XmlContentModel> contentModels;
    private final Map<String, XmlElementDefinition> topLevelElements;

    private XmlDocumentSchema(String namespace, String schemaLocation, Map<String, String> importedNamespaces, Map<String, XmlContentModel.Factory> contentModels, List<XmlElementDefinition.Factory> topLevelElements) {
        this.namespace = namespace;
        this.schemaLocation = schemaLocation;
        this.importedNamespaces = new HashMap<String, String>(importedNamespaces);
        this.contentModels = new HashMap<String, XmlContentModel>();
        for (Map.Entry<String, XmlContentModel.Factory> entry : contentModels.entrySet()) {
            XmlContentModel.Factory factory = entry.getValue();
            if (factory == null) continue;
            this.contentModels.put(entry.getKey(), this.optimize(factory.create(this)));
        }
        this.topLevelElements = new HashMap<String, XmlElementDefinition>();
        for (XmlElementDefinition.Factory factory : topLevelElements) {
            XmlElementDefinition def = (XmlElementDefinition)this.optimize(factory.create(this));
            this.topLevelElements.put(def.getName().getLocalPart(), def);
        }
        for (Map.Entry entry : this.topLevelElements.entrySet()) {
            XmlElementDefinition definition = (XmlElementDefinition)entry.getValue();
            if (!definition.isAbstract()) continue;
            ArrayList<XmlElementDefinition> substitutionList = new ArrayList<XmlElementDefinition>();
            for (Map.Entry<String, XmlElementDefinition> map2 : this.topLevelElements.entrySet()) {
                XmlElementDefinition definition2 = map2.getValue();
                if (!definition.getName().equals(definition2.getSubstitutionGroup())) continue;
                XmlElementDefinitionByReference.Factory def = new XmlElementDefinitionByReference.Factory();
                def.setName(definition2.getName());
                def.setMinOccur(definition2.getMinOccur());
                def.setMaxOccur(definition2.getMaxOccur());
                substitutionList.add((XmlElementDefinition)((XmlElementDefinition.Factory)def).create(this));
            }
            definition.setSubstitutionList(substitutionList);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public String getSchemaLocation(String namespace) {
        String res;
        if (namespace.equals(this.namespace)) {
            res = this.schemaLocation;
        } else {
            res = this.importedNamespaces.get(namespace);
            if (res == null) {
                res = namespace;
            }
        }
        return res;
    }

    public Map<String, String> getSchemaLocations() {
        HashMap<String, String> schemaLocations = new HashMap<String, String>();
        if (this.namespace != null && this.schemaLocation != null) {
            schemaLocations.put(this.namespace, this.schemaLocation);
        }
        schemaLocations.putAll(this.importedNamespaces);
        return Collections.unmodifiableMap(schemaLocations);
    }

    public XmlElementDefinition getElement(String name) {
        return this.topLevelElements.get(name);
    }

    public XmlContentModel getContentModel(String name) {
        return this.contentModels.get(name);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (XmlElementDefinition xmlElementDefinition : this.topLevelElements.values()) {
            xmlElementDefinition.toString(buf, "");
            buf.append("\n\n");
        }
        for (Map.Entry entry : this.contentModels.entrySet()) {
            buf.append((String)entry.getKey());
            buf.append(" = ");
            ((XmlContentModel)entry.getValue()).toString(buf, "");
            buf.append("\n\n");
        }
        return buf.toString();
    }

    private XmlContentModel optimize(XmlContentModel contentModel) {
        if (contentModel instanceof XmlSequenceGroup) {
            XmlSequenceGroup sequenceContentModel = (XmlSequenceGroup)contentModel;
            ArrayList<XmlContentModel> nestedContent = new ArrayList<XmlContentModel>();
            boolean optimized = false;
            for (XmlContentModel child : sequenceContentModel.getNestedContent()) {
                XmlSequenceGroup cs;
                boolean handled = false;
                if (child instanceof XmlSequenceGroup && (cs = (XmlSequenceGroup)child).getMinOccur() == 1 && cs.getMaxOccur() == 1) {
                    for (XmlContentModel nested : cs.getNestedContent()) {
                        nestedContent.add(this.optimize(nested));
                    }
                    handled = true;
                    optimized = true;
                }
                if (handled) continue;
                XmlContentModel optimizedChild = this.optimize(child);
                if (optimizedChild != child) {
                    optimized = true;
                }
                nestedContent.add(optimizedChild);
            }
            if (optimized) {
                return new XmlSequenceGroup(sequenceContentModel.getSchema(), sequenceContentModel.getMinOccur(), sequenceContentModel.getMaxOccur(), nestedContent);
            }
        } else if (contentModel instanceof XmlChoiceGroup) {
            XmlChoiceGroup choiceContentModel = (XmlChoiceGroup)contentModel;
            ArrayList<XmlContentModel> nestedContent = new ArrayList<XmlContentModel>();
            boolean optimized = false;
            for (XmlContentModel child : choiceContentModel.getNestedContent()) {
                XmlContentModel optimizedChild = this.optimize(child);
                if (optimizedChild != child) {
                    optimized = true;
                }
                nestedContent.add(optimizedChild);
            }
            if (optimized) {
                return new XmlChoiceGroup(choiceContentModel.getSchema(), choiceContentModel.getMinOccur(), choiceContentModel.getMaxOccur(), nestedContent);
            }
        }
        return contentModel;
    }

    /* synthetic */ XmlDocumentSchema(String string, String string2, Map map, Map map2, List list, XmlDocumentSchema xmlDocumentSchema) {
        this(string, string2, map, map2, list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory {
        private String namespace;
        private String schemaLocation;
        private final Map<String, String> importedNamespaces = new HashMap<String, String>();
        private final Map<String, XmlContentModel.Factory> contentModels = new HashMap<String, XmlContentModel.Factory>();
        private final List<XmlElementDefinition.Factory> topLevelElements = new ArrayList<XmlElementDefinition.Factory>();

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getSchemaLocation() {
            return this.schemaLocation;
        }

        public void setSchemaLocation(String schemaLocation) {
            this.schemaLocation = schemaLocation;
        }

        public Map<String, String> getImportedNamespaces() {
            return Collections.unmodifiableMap(this.importedNamespaces);
        }

        public void addImportedNamespace(String namespace, String schemaLocation) {
            this.importedNamespaces.put(namespace, schemaLocation);
        }

        public Map<String, XmlContentModel.Factory> getContentModels() {
            return Collections.unmodifiableMap(this.contentModels);
        }

        public XmlContentModel.Factory getContentModel(String name) {
            return this.contentModels.get(name);
        }

        public void addContentModel(String name, XmlContentModel.Factory contentModel) {
            this.contentModels.put(name, contentModel);
        }

        public void removeContentModel(String name) {
            this.contentModels.remove(name);
        }

        public QName createContentModelName() {
            int counter = 1;
            String contentModelName = null;
            do {
                contentModelName = "##@" + String.valueOf(counter);
                ++counter;
            } while (this.contentModels.containsKey(contentModelName));
            this.contentModels.put(contentModelName, null);
            return new QName(this.namespace, contentModelName);
        }

        public List<XmlElementDefinition.Factory> getTopLevelElements() {
            return Collections.unmodifiableList(this.topLevelElements);
        }

        public void addTopLevelElement(XmlElementDefinition.Factory topLevelElement) {
            this.topLevelElements.add(topLevelElement);
        }

        public XmlDocumentSchema create() {
            return new XmlDocumentSchema(this.namespace, this.schemaLocation, this.importedNamespaces, this.contentModels, this.topLevelElements, null);
        }
    }
}

