/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelParticle;
import org.eclipse.sapphire.modeling.ModelPropertyValidationService;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.util.MiscUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transient<T>
extends ModelParticle {
    private final TransientProperty property;
    private final T content;
    private Status valres;

    public Transient(IModelElement parent, TransientProperty property, T content) {
        super(parent, parent.resource());
        this.property = property;
        this.content = content;
        this.valres = null;
    }

    public void init() {
        this.initValidation();
    }

    private void initValidation() {
        if (this.valres == null) {
            Status.CompositeStatusFactory factory = Status.factoryForComposite();
            for (ModelPropertyValidationService svc : this.parent().services(this.property, ModelPropertyValidationService.class)) {
                try {
                    factory.merge(svc.validate());
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
            this.valres = factory.create();
        }
    }

    @Override
    public IModelElement parent() {
        return (IModelElement)super.parent();
    }

    public TransientProperty property() {
        return this.property;
    }

    public T content() {
        return this.content;
    }

    @Override
    public Status validate() {
        this.initValidation();
        return this.valres;
    }

    public boolean equals(Object val) {
        if (this == val) {
            return true;
        }
        if (val == null) {
            return false;
        }
        this.init();
        Transient value = (Transient)val;
        return this.parent() == value.parent() && this.property == value.property && MiscUtil.equal(this.content, value.content) && this.valres.equals(value.valres);
    }

    public int hashCode() {
        int hashCode = this.parent().hashCode();
        hashCode ^= this.property.hashCode();
        return hashCode ^= this.content == null ? 1 : this.content.hashCode();
    }

    public String toString() {
        return this.content == null ? "<null>" : this.content.toString();
    }
}

