/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ValueLabelService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;

public final class EnumValueLabelService
extends ValueLabelService {
    private EnumValueType enumType;
    private ValueSerializationService valueSerializationService;

    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element);
        this.enumType = new EnumValueType(property.getTypeClass());
        this.valueSerializationService = element.service(property, ValueSerializationService.class);
    }

    public String provide(String value) {
        Enum item = (Enum)this.valueSerializationService.decode(value);
        if (item == null) {
            return value;
        }
        return this.enumType.getLabel(item, false, CapitalizationType.NO_CAPS, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return property instanceof ValueProperty && Enum.class.isAssignableFrom(property.getTypeClass());
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return new EnumValueLabelService();
        }
    }
}

