/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.annotations.DependsOn;
import org.eclipse.sapphire.services.DependenciesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeclarativeDependenciesService
extends DependenciesService {
    @Override
    protected void compute(Set<ModelPath> dependencies) {
        HashSet<String> dependenciesAsStrings = new HashSet<String>();
        DependsOn dependsOnAnnotation = this.property().getAnnotation(DependsOn.class);
        if (dependsOnAnnotation != null) {
            String[] stringArray = dependsOnAnnotation.value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dependsOnPropertyRef = stringArray[n2];
                dependenciesAsStrings.add(dependsOnPropertyRef);
                ++n2;
            }
        }
        for (String str : dependenciesAsStrings) {
            ModelPath path = null;
            try {
                path = new ModelPath(str);
            }
            catch (ModelPath.MalformedPathException e) {
                LoggingService.log(e);
            }
            dependencies.add(path);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return property.hasAnnotation(DependsOn.class);
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return new DeclarativeDependenciesService();
        }
    }
}

