/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.t0008;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.t0008.ITestModelElementA;
import org.eclipse.sapphire.tests.modeling.el.t0008.ITestModelElementB;
import org.eclipse.sapphire.tests.modeling.el.t0008.ITestModelRoot;

public final class TestExpr0008
extends TestExpr {
    private TestExpr0008(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestExpr0008");
        suite.addTest((Test)new TestExpr0008("testLiteral1"));
        suite.addTest((Test)new TestExpr0008("testLiteral2"));
        suite.addTest((Test)new TestExpr0008("testLiteral3"));
        suite.addTest((Test)new TestExpr0008("testValueProperty"));
        suite.addTest((Test)new TestExpr0008("testElementProperty"));
        suite.addTest((Test)new TestExpr0008("testNull1"));
        suite.addTest((Test)new TestExpr0008("testNull2"));
        suite.addTest((Test)new TestExpr0008("testNull3"));
        suite.addTest((Test)new TestExpr0008("testUnknownType"));
        return suite;
    }

    public void testLiteral2() {
        FunctionContext context = new FunctionContext();
        TestExpr0008.testForExpectedValue(context, "${ InstanceOf( 12345, 'java.math.BigInteger' ) }", (Object)true);
    }

    public void testLiteral3() {
        FunctionContext context = new FunctionContext();
        TestExpr0008.testForExpectedValue(context, "${ InstanceOf( 12345, 'java.lang.Number' ) }", (Object)true);
    }

    public void testValueProperty() {
        ITestModelRoot root = (ITestModelRoot)ITestModelRoot.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((IModelElement)root);
        root.setInteger(123);
        TestExpr0008.testForExpectedValue((FunctionContext)context, "${ InstanceOf( Integer, 'java.lang.Integer' ) }", (Object)true);
    }

    public void testElementProperty() {
        ITestModelRoot root = (ITestModelRoot)ITestModelRoot.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((IModelElement)root);
        root.getElement().element(true, ITestModelElementA.TYPE);
        TestExpr0008.testForExpectedValue((FunctionContext)context, "${ InstanceOf( Element, 'org.eclipse.sapphire.tests.modeling.el.t0008.ITestModelElementA' ) }", (Object)true);
        root.getElement().element(true, ITestModelElementB.TYPE);
        TestExpr0008.testForExpectedValue((FunctionContext)context, "${ InstanceOf( Element, 'org.eclipse.sapphire.tests.modeling.el.t0008.ITestModelElementB' ) }", (Object)true);
        root.getElement().remove();
        TestExpr0008.testForExpectedValue((FunctionContext)context, "${ InstanceOf( Element, 'org.eclipse.sapphire.tests.modeling.el.t0008.ITestModelElementB' ) }", (Object)false);
    }

    public void testNull1() {
        FunctionContext context = new FunctionContext();
        TestExpr0008.testForExpectedValue(context, "${ InstanceOf( null, null ) }", (Object)false);
    }

    public void testNull2() {
        FunctionContext context = new FunctionContext();
        TestExpr0008.testForExpectedValue(context, "${ InstanceOf( 'x', null ) }", (Object)false);
    }

    public void testNull3() {
        FunctionContext context = new FunctionContext();
        TestExpr0008.testForExpectedValue(context, "${ InstanceOf( null, 'java.lang.String' ) }", (Object)false);
    }

    public void testLiteral1() {
        FunctionContext context = new FunctionContext();
        TestExpr0008.testForExpectedValue(context, "${ InstanceOf( 'x', 'java.lang.String' ) }", (Object)true);
    }

    public void testUnknownType() {
        FunctionContext context = new FunctionContext();
        TestExpr0008.testForExpectedValue(context, "${ InstanceOf( 12345, 'java.lang.FooBar' ) }", (Object)false);
    }
}

