/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.services.t0003.internal;

import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.tests.services.t0003.ITestModel;
import org.eclipse.sapphire.tests.services.t0003.ITestModelItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestModel
extends ModelElement
implements ITestModel {
    private ModelElementHandle<ITestModelItem> item;
    private ModelElementHandle<ITestModelItem> itemImplied;
    private ModelElementList<ITestModelItem> items;

    public TestModel(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public TestModel(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<ITestModelItem> getItem() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.item == null) {
                this.refresh((ModelProperty)PROP_ITEM, true);
            }
            return this.item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<ITestModelItem> getItems() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.items == null) {
                this.refresh((ModelProperty)PROP_ITEMS, true);
            }
            return this.items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITestModelItem getItemImplied() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.itemImplied == null) {
                this.refresh((ModelProperty)PROP_ITEM_IMPLIED, true);
            }
            return (ITestModelItem)this.itemImplied.element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ITEM) {
                if (this.item == null) {
                    if (force) {
                        this.item = new ModelElementHandle((IModelElement)this, PROP_ITEM);
                        this.item.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_ITEM);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ITEM);
                    boolean notified = this.item.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ITEM, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_ITEMS) {
                if (this.items == null) {
                    if (force) {
                        this.items = new ModelElementList((IModelElement)this, PROP_ITEMS);
                        ListBindingImpl binding = this.resource().binding(PROP_ITEMS);
                        this.items.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_ITEMS);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ITEMS);
                    boolean notified = this.items.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ITEMS, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_ITEM_IMPLIED) {
                if (this.itemImplied == null) {
                    if (force) {
                        this.itemImplied = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_ITEM_IMPLIED);
                        this.itemImplied.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_ITEM_IMPLIED);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ITEM_IMPLIED);
                    boolean notified = this.itemImplied.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ITEM_IMPLIED, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_ITEM) {
            return this.getItem();
        }
        if (property == PROP_ITEMS) {
            return this.getItems();
        }
        if (property == PROP_ITEM_IMPLIED) {
            return this.getItemImplied();
        }
        return super.read(property);
    }
}

