/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.editor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditorFactory;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.sapphire.modeling.StatusException;
import org.eclipse.sapphire.modeling.util.internal.FileUtil;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditorInput;

public class SapphireDiagramEditorFactory {
    public static final String SAPPHIRE_DIAGRAM_TYPE = "sapphireDiagram";

    public static SapphireDiagramEditorInput createEditorInput(IFile file) throws StatusException, CoreException {
        return SapphireDiagramEditorFactory.createEditorInput(file, null, false);
    }

    public static SapphireDiagramEditorInput createEditorInput(IFile file, String diagramPageId, boolean sideBySideLayoutFile) throws StatusException, CoreException {
        IFolder diagramSettingRootFolder;
        IPath diagramSettingFolderPath;
        IFolder diagramSettingFolder;
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        IPath inputFilePath = file.getProjectRelativePath().removeLastSegments(1);
        String inputFileName = file.getName();
        String fileName = inputFileName.endsWith(".xml") ? inputFileName.substring(0, inputFileName.indexOf(".xml")) : inputFileName;
        if (diagramPageId != null) {
            fileName = String.valueOf(fileName) + "_" + diagramPageId;
        }
        if (!(diagramSettingFolder = project.getFolder(diagramSettingFolderPath = (diagramSettingRootFolder = project.getFolder(".settings/org.eclipse.sapphire.ui.diagram/")).getProjectRelativePath().append(inputFilePath))).exists()) {
            FileUtil.mkdirs((File)diagramSettingFolder.getLocation().toFile());
            diagramSettingFolder.refreshLocal(1, null);
        }
        IFolder layoutFolder = !sideBySideLayoutFile ? diagramSettingFolder : (IFolder)file.getParent();
        boolean existingLayout = true;
        IFile layoutFile = layoutFolder.getFile(String.valueOf(fileName) + ".layout");
        if (!layoutFile.exists()) {
            layoutFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            existingLayout = false;
        }
        final Diagram diagram = Graphiti.getPeCreateService().createDiagram(SAPPHIRE_DIAGRAM_TYPE, fileName, 10, true);
        URI uri = URI.createHierarchicalURI((String)"Virtual", null, null, (String[])new String[]{"diagram", fileName}, null, null);
        TransactionalEditingDomain editingDomain = DiagramEditorFactory.createResourceSetAndEditingDomain();
        final Resource diagramResource = editingDomain.getResourceSet().createResource(uri);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                diagramResource.getContents().add((Object)diagram);
            }
        });
        String providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
        SapphireDiagramEditorInput diagramEditorInput = SapphireDiagramEditorInput.createEditorInput(diagram, editingDomain, providerId, false);
        diagramEditorInput.setLayoutFile(layoutFile);
        diagramEditorInput.setNoExistingLayout(!existingLayout);
        return diagramEditorInput;
    }
}

