/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.IFormDef;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphirePartContainer
extends SapphirePart {
    private List<SapphirePart> childParts;
    private List<SapphirePart> childPartsReadOnly;

    @Override
    protected void init() {
        super.init();
        this.childParts = new ArrayList<SapphirePart>();
        this.childPartsReadOnly = Collections.unmodifiableList(this.childParts);
        IModelElement modelElementForChildParts = this.getModelElementForChildParts();
        if (modelElementForChildParts != null) {
            SapphirePartListener childPartListener = new SapphirePartListener(){

                public void handleValidateStateChange(Status oldValidateState, Status newValidationState) {
                    SapphirePartContainer.this.updateValidationState();
                }
            };
            IFormDef def = this.getFormDefinition();
            for (ISapphirePartDef childPartDef : def.getContent()) {
                SapphirePart childPart = SapphirePartContainer.create(this, modelElementForChildParts, childPartDef, this.params);
                this.childParts.add(childPart);
                childPart.addListener(childPartListener);
            }
        }
        this.updateValidationState();
    }

    public IFormDef getFormDefinition() {
        return (IFormDef)this.definition;
    }

    protected IModelElement getModelElementForChildParts() {
        return this.getModelElement();
    }

    public List<SapphirePart> getChildParts() {
        return this.childPartsReadOnly;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        for (SapphirePart child : this.childParts) {
            child.render(context);
        }
    }

    @Override
    protected Status computeValidationState() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (SapphirePart child : this.childParts) {
            factory.add(child.getValidationState());
        }
        return factory.create();
    }

    @Override
    public boolean setFocus() {
        for (SapphirePart child : this.getChildParts()) {
            if (!child.setFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setFocus(ModelPath path) {
        for (SapphirePart child : this.getChildParts()) {
            if (!child.setFocus(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SapphirePart child : this.childParts) {
            child.dispose();
        }
    }
}

