/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.swt.SapphireControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class SapphirePropertyPage
extends PropertyPage {
    private final String compositeDefPath;
    private IModelElement modelElement = null;

    public SapphirePropertyPage(String compositeDefPath) {
        this.compositeDefPath = compositeDefPath;
    }

    protected abstract IModelElement createModelElement();

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDefaultsButton().setVisible(false);
        parent.layout(true, true);
    }

    protected Control createContents(Composite parent) {
        this.modelElement = this.createModelElement();
        final SapphireControl control = new SapphireControl(parent, this.modelElement, this.compositeDefPath);
        final Runnable messageUpdateOperation = new Runnable(){

            public void run() {
                Status st = control.getPart().getValidationState();
                if (st.severity() == Status.Severity.ERROR) {
                    SapphirePropertyPage.this.setMessage(st.message(), 3);
                    SapphirePropertyPage.this.setValid(false);
                } else if (st.severity() == Status.Severity.WARNING) {
                    SapphirePropertyPage.this.setMessage(st.message(), 2);
                    SapphirePropertyPage.this.setValid(true);
                } else {
                    SapphirePropertyPage.this.setMessage(null);
                    SapphirePropertyPage.this.setValid(true);
                }
            }
        };
        messageUpdateOperation.run();
        SapphirePartListener messageUpdateListener = new SapphirePartListener(){

            public void handleValidateStateChange(Status oldValidateState, Status newValidationState) {
                messageUpdateOperation.run();
            }
        };
        control.getPart().addListener(messageUpdateListener);
        return control;
    }

    public boolean performOk() {
        try {
            this.modelElement.resource().save();
            return true;
        }
        catch (ResourceStoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Resources.errorDialogTitle, (String)e.getMessage());
            return false;
        }
    }

    protected void performApply() {
        this.performOk();
    }

    private static final class Resources
    extends NLS {
        public static String errorDialogTitle;

        static {
            Resources.initializeMessages((String)SapphirePropertyPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

