/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireBrowseActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

public class AbsoluteFilePathBrowseActionHandler
extends SapphireBrowseActionHandler {
    public static final String ID = "Sapphire.Browse.File.Absolute";
    public static final String PARAM_EXTENSIONS = "extensions";
    private FileExtensionsService fileExtensionService;
    private List<String> staticFileExtensionsList;

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        super.init(action, def);
        this.setId(ID);
        this.setLabel(Resources.label);
        this.addImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        IModelElement element = this.getModelElement();
        ValueProperty property = this.getProperty();
        String staticFileExtensions = def.getParam(PARAM_EXTENSIONS);
        if (staticFileExtensions == null) {
            this.fileExtensionService = (FileExtensionsService)element.service((ModelProperty)property, FileExtensionsService.class);
            if (this.fileExtensionService == null) {
                this.staticFileExtensionsList = Collections.emptyList();
            }
        } else {
            this.staticFileExtensionsList = new ArrayList<String>();
            String[] stringArray = staticFileExtensions.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if ((extension = extension.trim()).length() > 0) {
                    this.staticFileExtensionsList.add(extension);
                }
                ++n2;
            }
        }
    }

    protected String browse(SapphireRenderingContext context) {
        List extensions;
        ValueProperty property = this.getProperty();
        FileDialog dialog = new FileDialog(context.getShell());
        dialog.setText(property.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false));
        Value value = this.getModelElement().read(property);
        Path path = (Path)value.getContent();
        if (path != null && path.segmentCount() > 1) {
            dialog.setFilterPath(path.removeLastSegments(1).toOSString());
            dialog.setFileName(path.lastSegment());
        }
        if (!(extensions = this.fileExtensionService == null ? this.staticFileExtensionsList : this.fileExtensionService.extensions()).isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (String extension : extensions) {
                if (buf.length() > 0) {
                    buf.append(';');
                }
                buf.append("*.");
                buf.append(extension);
            }
            dialog.setFilterExtensions(new String[]{buf.toString()});
        }
        return dialog.open();
    }

    private static final class Resources
    extends NLS {
        public static String label;

        static {
            Resources.initializeMessages((String)AbsoluteFilePathBrowseActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

