/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologicalSorter<T> {
    private static final String BEFORE_PREFIX = "before:";
    private static final String AFTER_PREFIX = "after:";
    private Map<String, Entity> entities = new LinkedHashMap<String, Entity>();
    private List<CycleListener> cycleListeners = new ArrayList<CycleListener>();

    public Entity entity(T data) {
        return this.entity(this.getClass().getName(), data);
    }

    public Entity entity(String id, T data) {
        String uniqueId = id;
        int counter = 0;
        while (this.entities.containsKey(uniqueId)) {
            uniqueId = String.valueOf(id) + String.valueOf(++counter);
        }
        Entity entity = new Entity(data);
        this.entities.put(uniqueId, entity);
        return entity;
    }

    public void addCycleListener(CycleListener listener) {
        this.cycleListeners.add(listener);
    }

    public void removeCycleListener(CycleListener listener) {
        this.cycleListeners.remove(listener);
    }

    public List<T> sort() {
        ArrayList<Entity> path;
        for (Entity entity : this.entities.values()) {
            Iterator itr = entity.constraints.iterator();
            while (itr.hasNext()) {
                Entity targetEntity;
                String constraint = (String)itr.next();
                String targetEntityId = null;
                boolean after = false;
                if (constraint.startsWith(BEFORE_PREFIX) && constraint.length() > BEFORE_PREFIX.length()) {
                    targetEntityId = constraint.substring(BEFORE_PREFIX.length());
                } else if (constraint.startsWith(AFTER_PREFIX) && constraint.length() > AFTER_PREFIX.length()) {
                    targetEntityId = constraint.substring(AFTER_PREFIX.length());
                    after = true;
                }
                if (targetEntityId == null || (targetEntity = this.entities.get(targetEntityId)) == null) continue;
                if (after) {
                    entity.after(targetEntity);
                } else {
                    entity.before(targetEntity);
                }
                itr.remove();
            }
        }
        this.clearVisited();
        for (Entity entity : this.findLeaves()) {
            path = new ArrayList<Entity>();
            this.dealWithCycles(entity, path);
        }
        for (Entity entity : this.entities.values()) {
            if (entity.visited) continue;
            path = new ArrayList();
            this.dealWithCycles(entity, path);
        }
        this.clearVisited();
        ArrayList result = new ArrayList();
        for (Entity entity : this.findLeaves()) {
            this.visit(entity, result);
        }
        return result;
    }

    private void visit(Entity entity, List<T> result) {
        if (!entity.visited) {
            entity.visited = true;
            for (Entity x : entity.outgoing) {
                this.visit(x, result);
            }
            result.add(entity.data());
        }
    }

    private List<Entity> findLeaves() {
        ArrayList<Entity> leaves = new ArrayList<Entity>();
        for (Entity entity : this.entities.values()) {
            if (!entity.incoming.isEmpty()) continue;
            leaves.add(entity);
        }
        return leaves;
    }

    private void dealWithCycles(Entity entity, List<Entity> path) {
        entity.visited = true;
        int index = path.indexOf(entity);
        if (index == -1) {
            path.add(entity);
            if (entity.outgoing.size() == 1) {
                this.dealWithCycles((Entity)entity.outgoing.iterator().next(), path);
            } else {
                for (Entity x : entity.outgoing) {
                    ArrayList<Entity> pathCopy = new ArrayList<Entity>(path);
                    this.dealWithCycles(x, pathCopy);
                }
            }
        } else {
            if (!this.cycleListeners.isEmpty()) {
                List<Entity> cycle = path.subList(index, path.size());
                for (CycleListener listener : this.cycleListeners) {
                    listener.handleCycle(cycle);
                }
            }
            Entity last = path.get(path.size() - 1);
            last.outgoing.remove(entity);
            entity.incoming.remove(last);
        }
    }

    private void clearVisited() {
        for (Entity entity : this.entities.values()) {
            entity.visited = false;
        }
    }

    private static String convertToString(List<Entity> entities) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int n = entities.size();
        while (i < n) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(entities.get(i));
            ++i;
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CycleException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final List<Entity> cycle;

        public CycleException(List<Entity> cycle) {
            this.cycle = Collections.unmodifiableList(new ArrayList<Entity>(cycle));
        }

        @Override
        public String getMessage() {
            return NLS.bind((String)Resources.cycleDetectedMessage, (Object)TopologicalSorter.convertToString(this.cycle));
        }

        public List<Entity> getCycle() {
            return this.cycle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CycleListener {
        public abstract void handleCycle(List<Entity> var1);
    }

    public static class Entity {
        private final Object data;
        private final Set<Entity> outgoing = new LinkedHashSet<Entity>();
        private final Set<Entity> incoming = new LinkedHashSet<Entity>();
        private final Set<String> constraints = new HashSet<String>();
        private boolean visited;

        private Entity(Object data) {
            this.data = data;
        }

        public Object data() {
            return this.data;
        }

        public void before(Entity entity) {
            this.incoming.add(entity);
            entity.outgoing.add(this);
        }

        public void after(Entity entity) {
            entity.incoming.add(this);
            this.outgoing.add(entity);
        }

        public void constraint(String contraint) {
            this.constraints.add(contraint);
        }

        public String toString() {
            return this.data.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ExceptionCycleListener
    extends CycleListener {
        @Override
        public void handleCycle(List<Entity> cycle) {
            throw new CycleException(cycle);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PrintStreamCycleListener
    extends CycleListener {
        private final PrintStream stream;

        public PrintStreamCycleListener(PrintStream stream) {
            this.stream = stream;
        }

        @Override
        public void handleCycle(List<Entity> cycle) {
            this.stream.println(NLS.bind((String)Resources.cycleDetectedMessage, (Object)TopologicalSorter.convertToString(cycle)));
        }
    }

    private static final class Resources
    extends NLS {
        public static String cycleDetectedMessage;

        static {
            Resources.initializeMessages((String)TopologicalSorter.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

