/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.xml.editor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementDisposedEvent;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SourceEditorService;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.provisional.IDOMSourceEditingTextTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEditorResourceStore
extends XmlResourceStore {
    private SapphireEditor sapphireEditor;
    private StructuredTextEditor sourceEditor;
    private IModelElement rootModelElement;
    private final Map<Node, List<IModelElement>> nodeToModelElementsMap;
    private final Scrubber scrubber;
    private final ModelElementListener modelElementDisposeListener;
    private final XmlSourceEditorService sourceEditorService;

    public XmlEditorResourceStore(SapphireEditor sapphireEditor, StructuredTextEditor sourceEditor) {
        super(null);
        this.sapphireEditor = sapphireEditor;
        this.sourceEditor = sourceEditor;
        this.rootModelElement = null;
        this.nodeToModelElementsMap = new HashMap<Node, List<IModelElement>>();
        this.scrubber = new Scrubber();
        this.scrubber.start();
        this.sourceEditorService = new XmlSourceEditorService();
        this.modelElementDisposeListener = new ModelElementListener(){

            public void handleElementDisposedEvent(ModelElementDisposedEvent event) {
                XmlEditorResourceStore.this.handleElementDisposed(event.getModelElement());
            }
        };
        ISourceEditingTextTools sourceEditingTextTools = (ISourceEditingTextTools)this.sourceEditor.getAdapter(ISourceEditingTextTools.class);
        IDOMSourceEditingTextTools domSourceEditingTextTools = (IDOMSourceEditingTextTools)sourceEditingTextTools;
        Document document = domSourceEditingTextTools.getDOMDocument();
        INodeAdapter adapter = new INodeAdapter(){

            public boolean isAdapterForType(Object type) {
                return false;
            }

            public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
                if (eventType == 2 && newValue instanceof IDOMNode) {
                    XmlEditorResourceStore.addAdapter((IDOMNode)newValue, this);
                }
                XmlEditorResourceStore.this.handleXmlNodeChange((Node)notifier);
            }
        };
        XmlEditorResourceStore.addAdapter((IDOMNode)document, adapter);
        this.setDomDocument(document);
    }

    public final SapphireEditor getEditor() {
        return this.sapphireEditor;
    }

    public final StructuredTextEditor getXmlEditor() {
        return this.sourceEditor;
    }

    public boolean isXmlDeclarationNeeded() {
        return true;
    }

    public void save() throws ResourceStoreException {
        IFile file;
        IEditorInput input = this.sourceEditor.getEditorInput();
        if (input instanceof FileEditorInput && !(file = ((FileEditorInput)input).getFile()).exists()) {
            return;
        }
        this.validateSave();
        this.sourceEditor.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public void validateEdit() {
        IFile file;
        IEditorInput input = this.sourceEditor.getEditorInput();
        if (input instanceof FileEditorInput && !(file = ((FileEditorInput)input).getFile()).exists()) {
            IStatus st = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT);
            if (st.getSeverity() == 4) {
                throw new ValidateEditException();
            }
            try {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new ValidateEditException((Exception)((Object)e));
            }
        }
        if (!this.sourceEditor.validateEditorInputState()) {
            throw new ValidateEditException();
        }
    }

    public void validateSave() {
        if (!this.sourceEditor.validateEditorInputState()) {
            throw new ValidateEditException();
        }
    }

    public <A> A adapt(Class<A> adapterType) {
        Object result = null;
        if (adapterType == ITextEditor.class) {
            result = this.getXmlEditor();
        } else if (adapterType == SourceEditorService.class) {
            result = this.sourceEditorService;
        } else if (adapterType == File.class) {
            IEditorInput input = this.sourceEditor.getEditorInput();
            if (input instanceof FileEditorInput) {
                result = ((FileEditorInput)input).getFile().getLocation().toFile();
            } else {
                URI uri = ((FileStoreEditorInput)input).getURI();
                result = new File(uri);
            }
        } else if (adapterType == IFile.class) {
            IEditorInput input = this.sourceEditor.getEditorInput();
            if (input instanceof FileEditorInput) {
                result = ((FileEditorInput)input).getFile();
            }
        } else if (adapterType == IProject.class) {
            IEditorInput input = this.sourceEditor.getEditorInput();
            if (input instanceof FileEditorInput) {
                result = ((FileEditorInput)input).getFile().getProject();
            }
        } else {
            result = super.adapt(adapterType);
        }
        return (A)result;
    }

    public void registerRootModelElement(IModelElement rootModelElement) {
        this.rootModelElement = rootModelElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModelElement(Node xmlNode, IModelElement element) {
        Map<Node, List<IModelElement>> map = this.nodeToModelElementsMap;
        synchronized (map) {
            List<IModelElement> elements = this.nodeToModelElementsMap.get(xmlNode);
            if (elements == null) {
                elements = new CopyOnWriteArrayList<IModelElement>();
                this.nodeToModelElementsMap.put(xmlNode, elements);
            }
            elements.add(element);
            element.addListener(this.modelElementDisposeListener);
        }
    }

    public void dispose() {
        super.dispose();
        this.scrubber.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleElementDisposed(IModelElement element) {
        XmlElement xmlElement;
        Resource resource = element.resource();
        if (resource instanceof XmlResource && (xmlElement = ((XmlResource)resource).getXmlElement()) != null) {
            Map<Node, List<IModelElement>> map = this.nodeToModelElementsMap;
            synchronized (map) {
                Element xmlNode = xmlElement.getDomNode();
                List<IModelElement> elements = this.nodeToModelElementsMap.get(xmlNode);
                if (elements != null) {
                    elements.remove(element);
                    if (elements.isEmpty()) {
                        this.nodeToModelElementsMap.remove(xmlNode);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IModelElement> getModelElements(Node xmlNode) {
        Map<Node, List<IModelElement>> map = this.nodeToModelElementsMap;
        synchronized (map) {
            Node node = xmlNode;
            List<IModelElement> elements = this.nodeToModelElementsMap.get(node);
            while (elements == null && node != null && !(node instanceof Document)) {
                node = node.getParentNode();
                elements = this.nodeToModelElementsMap.get(node);
            }
            if (elements == null) {
                elements = Collections.singletonList(this.rootModelElement);
            }
            return elements;
        }
    }

    protected void handleXmlNodeChange(Node xmlNode) {
        this.handleXmlNodeChange(xmlNode, this.getModelElements(xmlNode));
    }

    protected void handleXmlNodeChange(Node xmlNode, List<IModelElement> nearestMatchModelElements) {
        DelayedTasksExecutor.schedule((DelayedTasksExecutor.Task)new RefreshElementTask(nearestMatchModelElements));
    }

    private static void addAdapter(IDOMNode node, INodeAdapter adapter) {
        node.addAdapter(adapter);
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            XmlEditorResourceStore.addAdapter((IDOMNode)children.item(i), adapter);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class RefreshElementTask
    extends DelayedTasksExecutor.Task {
        private final List<IModelElement> elements;

        public RefreshElementTask(List<IModelElement> elements) {
            this.elements = elements;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof RefreshElementTask) {
                return this.elements.equals(((RefreshElementTask)((Object)obj)).elements);
            }
            return false;
        }

        public int hashCode() {
            return this.elements.hashCode();
        }

        public void run() {
            for (IModelElement element : this.elements) {
                element.refresh(false, true);
            }
        }
    }

    protected static final class RefreshPropertyTask
    extends DelayedTasksExecutor.Task {
        private final IModelElement element;
        private final ModelProperty property;

        public RefreshPropertyTask(IModelElement element, ModelProperty property) {
            this.element = element;
            this.property = property;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof RefreshPropertyTask) {
                RefreshPropertyTask task = (RefreshPropertyTask)((Object)obj);
                return this.element == task.element && this.property == task.property;
            }
            return false;
        }

        public int hashCode() {
            return this.element.hashCode() + this.property.hashCode();
        }

        public void run() {
            this.element.refresh(this.property, false, true);
        }
    }

    private final class Scrubber
    extends Thread {
        private boolean stopRequested = false;

        private Scrubber() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map nodeToModelElementsMap = XmlEditorResourceStore.this.nodeToModelElementsMap;
            while (true) {
                try {
                    Scrubber.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
                Object object = this;
                synchronized (object) {
                    if (this.stopRequested) {
                        return;
                    }
                }
                object = nodeToModelElementsMap;
                synchronized (object) {
                    Iterator itr = nodeToModelElementsMap.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = itr.next();
                        if (((Node)entry.getKey()).getParentNode() != null) continue;
                        itr.remove();
                    }
                }
            }
        }

        public synchronized void dispose() {
            this.stopRequested = true;
            this.interrupt();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class XmlSourceEditorService
    extends SourceEditorService {
        private XmlSourceEditorService() {
        }

        public boolean find(IModelElement element, ModelProperty property) {
            return element.resource() instanceof XmlResource;
        }

        public void show(IModelElement element, ModelProperty property) {
            List<XmlNode> xmlNodes;
            StructuredTextEditor sourceView = XmlEditorResourceStore.this.getXmlEditor();
            SourceEditorService.Range range = new SourceEditorService.Range();
            if (property != null && !(xmlNodes = this.getXmlNodes(element, property)).isEmpty()) {
                if (property instanceof ValueProperty) {
                    IDOMNode domNode = (IDOMNode)xmlNodes.get(0).getDomNode();
                    if (domNode instanceof IDOMElement) {
                        IDOMElement domElement = (IDOMElement)domNode;
                        if (domElement.hasEndTag()) {
                            range.merge(domElement.getStartEndOffset(), domElement.getEndStartOffset());
                        } else {
                            range.merge(domNode.getStartOffset(), domNode.getEndOffset());
                        }
                    } else if (domNode instanceof IDOMAttr) {
                        IDOMAttr domAttr = (IDOMAttr)domNode;
                        int start = domAttr.getValueRegionStartOffset();
                        range.merge(start + 1, start + domAttr.getValueRegionText().length() - 1);
                    } else {
                        range.merge(domNode.getStartOffset(), domNode.getEndOffset());
                    }
                } else {
                    for (XmlNode xmlNode : xmlNodes) {
                        IDOMNode domNode = (IDOMNode)xmlNode.getDomNode();
                        range.merge(domNode.getStartOffset(), domNode.getEndOffset());
                    }
                }
            }
            if (!range.initialized()) {
                IModelElement modElement = element;
                Resource resource = modElement.resource();
                XmlElement xmlElement = null;
                if (resource != null) {
                    xmlElement = ((XmlResource)resource).getXmlElement();
                }
                while (xmlElement == null && modElement != null) {
                    IModelParticle parent = modElement.parent();
                    if ((modElement = parent instanceof ModelElementList ? (IModelElement)parent.parent() : (IModelElement)parent) == null || (resource = modElement.resource()) == null) continue;
                    xmlElement = ((XmlResource)resource).getXmlElement();
                }
                if (xmlElement != null) {
                    IDOMNode domNode = (IDOMNode)xmlElement.getDomNode();
                    range.merge(domNode.getStartOffset(), domNode.getEndOffset());
                }
            }
            TextSelection textSelection = range.initialized() ? new TextSelection(range.start(), range.end() - range.start()) : null;
            sourceView.getSelectionProvider().setSelection((ISelection)textSelection);
            XmlEditorResourceStore.this.getEditor().showPage((Object)sourceView);
        }

        private List<XmlNode> getXmlNodes(IModelElement element, ModelProperty property) {
            if (property instanceof ListProperty) {
                ModelElementList list = element.read((ListProperty)property);
                ArrayList<XmlNode> xmlNodes = new ArrayList<XmlNode>(list.size());
                for (IModelElement entry : list) {
                    XmlElement xmlNode;
                    Resource resource = entry.resource();
                    if (!(resource instanceof XmlResource) || (xmlNode = ((XmlResource)resource).getXmlElement()) == null) continue;
                    xmlNodes.add((XmlNode)xmlNode);
                }
                return xmlNodes;
            }
            if (property instanceof ElementProperty && !(property instanceof ImpliedElementProperty)) {
                XmlElement xmlNode;
                Resource resource;
                IModelElement child = element.read((ElementProperty)property).element();
                if (child != null && (resource = child.resource()) instanceof XmlResource && (xmlNode = ((XmlResource)resource).getXmlElement()) != null) {
                    return Collections.singletonList(xmlNode);
                }
            } else {
                XmlResource r;
                XmlNode xmlNode;
                Resource resource = element.resource();
                if (resource instanceof XmlResource && (xmlNode = ((XmlValueBindingImpl)(r = (XmlResource)resource).binding((ValueProperty)property)).getXmlNode()) != null) {
                    return Collections.singletonList(xmlNode);
                }
            }
            return Collections.emptyList();
        }
    }
}

