/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CapitalizationType {
    NO_CAPS,
    FIRST_WORD_ONLY,
    TITLE_STYLE;

    private static final Set<String> WORDS_NOT_TO_CAPITALIZE;

    static {
        WORDS_NOT_TO_CAPITALIZE = new HashSet<String>();
        WORDS_NOT_TO_CAPITALIZE.add("a");
        WORDS_NOT_TO_CAPITALIZE.add("an");
        WORDS_NOT_TO_CAPITALIZE.add("and");
        WORDS_NOT_TO_CAPITALIZE.add("as");
        WORDS_NOT_TO_CAPITALIZE.add("at");
        WORDS_NOT_TO_CAPITALIZE.add("but");
        WORDS_NOT_TO_CAPITALIZE.add("by");
        WORDS_NOT_TO_CAPITALIZE.add("if");
        WORDS_NOT_TO_CAPITALIZE.add("in");
        WORDS_NOT_TO_CAPITALIZE.add("nor");
        WORDS_NOT_TO_CAPITALIZE.add("of");
        WORDS_NOT_TO_CAPITALIZE.add("or");
        WORDS_NOT_TO_CAPITALIZE.add("the");
        WORDS_NOT_TO_CAPITALIZE.add("to");
    }

    public String changeTo(String str) {
        if (this == NO_CAPS) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        this.changeTo(buf);
        return buf.toString();
    }

    public void changeTo(StringBuilder str) {
        if (this == NO_CAPS) {
            return;
        }
        boolean isFirstWord = true;
        boolean isFirstLetterInWord = true;
        int i = 0;
        int n = str.length();
        while (i < n) {
            char ch = str.charAt(i);
            if (ch == ' ' || ch == '-' || ch == '(' || ch == '<' || ch == '[' || ch == '{') {
                isFirstWord = false;
                isFirstLetterInWord = true;
            } else {
                if (isFirstLetterInWord) {
                    int startOfWord = i;
                    boolean capitalize = false;
                    if (this == FIRST_WORD_ONLY && isFirstWord) {
                        capitalize = true;
                    } else if (this == TITLE_STYLE) {
                        if (isFirstWord) {
                            capitalize = true;
                        } else {
                            StringBuilder word = new StringBuilder();
                            int endOfWord = -1;
                            int j = i;
                            while (j < n) {
                                char ch2 = str.charAt(j);
                                if (!Character.isLetter(ch2)) {
                                    endOfWord = j - 1;
                                    break;
                                }
                                word.append(ch2);
                                ++j;
                            }
                            int n2 = i = endOfWord == -1 ? n - 1 : endOfWord;
                            if (!WORDS_NOT_TO_CAPITALIZE.contains(word.toString())) {
                                capitalize = true;
                            }
                        }
                    }
                    if (capitalize) {
                        char upper = Character.toUpperCase(ch);
                        str.setCharAt(startOfWord, upper);
                    }
                }
                isFirstLetterInWord = false;
            }
            ++i;
        }
    }
}

