/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.SourceLanguageLocalizationService;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionContext {
    public FunctionResult property(final Object element, final String name) {
        Function f = new Function(){

            public String name() {
                return "ReadProperty";
            }

            public FunctionResult evaluate(FunctionContext context) {
                return new FunctionResult(this, context){

                    protected Object evaluate() throws FunctionException {
                        if (element == null) {
                            throw new FunctionException(Resources.cannotReadPropertiesFromNull);
                        }
                        if (element instanceof Collection && name.equalsIgnoreCase("Size")) {
                            return ((Collection)element).size();
                        }
                        if (element instanceof List) {
                            try {
                                int index = Integer.parseInt(name);
                                List list = (List)element;
                                if (index >= 0 && index < list.size()) {
                                    return list.get(index);
                                }
                                throw new FunctionException(NLS.bind(Resources.indexOutOfBounds, index));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if (element.getClass().isArray()) {
                            if (name.equalsIgnoreCase("Size")) {
                                return Array.getLength(element);
                            }
                            try {
                                int index = Integer.parseInt(name);
                                if (index >= 0 && index < Array.getLength(element)) {
                                    return Array.get(element, index);
                                }
                                throw new FunctionException(NLS.bind(Resources.indexOutOfBounds, index));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if (element instanceof Map) {
                            Map map = (Map)element;
                            if (name.equalsIgnoreCase("Size")) {
                                return map.size();
                            }
                            for (Map.Entry entry : map.entrySet()) {
                                Object key = entry.getKey();
                                if (!(key instanceof String) || !((String)key).equalsIgnoreCase(name)) continue;
                                return entry.getValue();
                            }
                        }
                        if (element == FunctionContext.this) {
                            throw new FunctionException(NLS.bind(Resources.undefinedPropertyMessage, name));
                        }
                        Class<?> cl = element.getClass();
                        String type = cl.isArray() ? String.valueOf(cl.getComponentType().getName()) + "[]" : cl.getName();
                        throw new FunctionException(NLS.bind(Resources.undefinedPropertyMessageExt, name, type));
                    }
                };
            }
        };
        f.init(new Function[0]);
        return f.evaluate(this);
    }

    public Function function(String name, List<Function> arguments) {
        Function function = SapphireModelingExtensionSystem.createFunction(name, arguments.toArray(new Function[arguments.size()]));
        if (function != null) {
            return function;
        }
        throw new FunctionException(NLS.bind(Resources.undefinedFunctionMessage, name));
    }

    public LocalizationService getLocalizationService() {
        return SourceLanguageLocalizationService.INSTANCE;
    }

    public void dispose() {
    }

    private static final class Resources
    extends NLS {
        public static String undefinedPropertyMessage;
        public static String undefinedPropertyMessageExt;
        public static String undefinedFunctionMessage;
        public static String cannotReadPropertiesFromNull;
        public static String indexOutOfBounds;

        static {
            Resources.initializeMessages(FunctionContext.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

