/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.SourceLanguageLocalizationService;
import org.eclipse.sapphire.modeling.util.NLS;

public class ModelElementFunctionContext
extends FunctionContext {
    private final IModelElement element;
    private final LocalizationService localizationService;

    public ModelElementFunctionContext(IModelElement element) {
        this(element, SourceLanguageLocalizationService.INSTANCE);
    }

    public ModelElementFunctionContext(IModelElement element, LocalizationService localizationService) {
        this.element = element;
        this.localizationService = localizationService;
    }

    public final IModelElement element() {
        return this.element;
    }

    public FunctionResult property(Object element, String name) {
        if (element == this || element instanceof IModelElement) {
            IModelElement el = element == this ? this.element() : (IModelElement)element;
            ModelElementType type = el.getModelElementType();
            ModelProperty property = type.getProperty(name);
            if (property != null) {
                ReadPropertyFunction f = new ReadPropertyFunction(el, property){

                    protected Object evaluate() {
                        Object res = this.element.read(this.property);
                        if (res instanceof ModelElementHandle) {
                            res = ((ModelElementHandle)res).element();
                        }
                        return res;
                    }
                };
                f.init(new Function[0]);
                return ((Function)f).evaluate(this);
            }
        } else if (element instanceof ModelElementList) {
            ModelElementList list = (ModelElementList)element;
            if (name.equalsIgnoreCase("Size")) {
                ReadPropertyFunction f = new ReadPropertyFunction(list.parent(), list.getParentProperty()){

                    protected Object evaluate() {
                        return this.element.read((ListProperty)this.property).size();
                    }
                };
                f.init(new Function[0]);
                return ((Function)f).evaluate(this);
            }
            try {
                final int index = Integer.parseInt(name);
                ReadPropertyFunction f = new ReadPropertyFunction(list.parent(), list.getParentProperty()){

                    protected Object evaluate() {
                        ModelElementList list = this.element.read((ListProperty)this.property);
                        if (index >= 0 && index < list.size()) {
                            return list.get(index);
                        }
                        throw new FunctionException(NLS.bind(Resources.indexOutOfBounds, index));
                    }
                };
                f.init(new Function[0]);
                return ((Function)f).evaluate(this);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return super.property(element, name);
    }

    public LocalizationService getLocalizationService() {
        return this.localizationService;
    }

    private static abstract class ReadPropertyFunction
    extends Function {
        protected final IModelElement element;
        protected final ModelProperty property;

        public ReadPropertyFunction(IModelElement element, ModelProperty property) {
            this.element = element;
            this.property = property;
        }

        public final String name() {
            return "ReadProperty";
        }

        public final FunctionResult evaluate(FunctionContext context) {
            final IModelElement element = this.element;
            final ModelProperty property = this.property;
            return new FunctionResult(this, context){
                private ModelPropertyListener listener;

                protected void init() {
                    super.init();
                    this.listener = new ModelPropertyListener(){

                        public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                            this.refresh();
                        }
                    };
                    element.addListener(this.listener, property.getName());
                }

                protected Object evaluate() {
                    return ReadPropertyFunction.this.evaluate();
                }

                public void dispose() {
                    super.dispose();
                    element.removeListener(this.listener, property.getName());
                }
            };
        }

        protected abstract Object evaluate();
    }

    private static final class Resources
    extends NLS {
        public static String indexOutOfBounds;

        static {
            Resources.initializeMessages(ModelElementFunctionContext.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

