/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.serialization;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateSerializationService
extends ValueSerializationService {
    private static final List<DateFormat> STANDARD_FORMATS;
    private List<DateFormat> formats;

    static {
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSZ"));
        formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS"));
        formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm"));
        formats.add(new SimpleDateFormat("yyyy-MM-dd"));
        formats.add(new SimpleDateFormat("HH:mm"));
        formats.add(new SimpleDateFormat("h:mm a"));
        DateFormat format = DateFormat.getDateInstance();
        if (!formats.contains(format)) {
            formats.add(format);
        }
        if (!formats.contains(format = DateFormat.getTimeInstance())) {
            formats.add(format);
        }
        if (!formats.contains(format = DateFormat.getDateTimeInstance())) {
            formats.add(format);
        }
        STANDARD_FORMATS = Collections.unmodifiableList(formats);
    }

    @Override
    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        if (params.length == 0) {
            this.formats = STANDARD_FORMATS;
        } else {
            this.formats = new ArrayList<DateFormat>();
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String format = stringArray[n2];
                this.formats.add(new SimpleDateFormat(format));
                ++n2;
            }
            this.formats = Collections.unmodifiableList(this.formats);
        }
    }

    public List<? extends DateFormat> formats() {
        return this.formats;
    }

    @Override
    protected Object decodeFromString(String value) {
        for (DateFormat dateFormat : this.formats()) {
            try {
                return dateFormat.parse(value);
            }
            catch (ParseException parseException) {}
        }
        return null;
    }

    @Override
    public String encode(Object value) {
        return this.formats().get(0).format((Date)value);
    }
}

